/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

public final class OperatorNameConventions {
    @NotNull
    public static final OperatorNameConventions INSTANCE = new OperatorNameConventions();
    @JvmField
    @NotNull
    public static final Name GET_VALUE;
    @JvmField
    @NotNull
    public static final Name SET_VALUE;
    @JvmField
    @NotNull
    public static final Name PROVIDE_DELEGATE;
    @JvmField
    @NotNull
    public static final Name EQUALS;
    @JvmField
    @NotNull
    public static final Name HASH_CODE;
    @JvmField
    @NotNull
    public static final Name COMPARE_TO;
    @JvmField
    @NotNull
    public static final Name CONTAINS;
    @JvmField
    @NotNull
    public static final Name INVOKE;
    @JvmField
    @NotNull
    public static final Name ITERATOR;
    @JvmField
    @NotNull
    public static final Name GET;
    @JvmField
    @NotNull
    public static final Name SET;
    @JvmField
    @NotNull
    public static final Name NEXT;
    @JvmField
    @NotNull
    public static final Name HAS_NEXT;
    @JvmField
    @NotNull
    public static final Name TO_STRING;
    @JvmField
    @NotNull
    public static final Regex COMPONENT_REGEX;
    @JvmField
    @NotNull
    public static final Name AND;
    @JvmField
    @NotNull
    public static final Name OR;
    @JvmField
    @NotNull
    public static final Name XOR;
    @JvmField
    @NotNull
    public static final Name INV;
    @JvmField
    @NotNull
    public static final Name SHL;
    @JvmField
    @NotNull
    public static final Name SHR;
    @JvmField
    @NotNull
    public static final Name USHR;
    @JvmField
    @NotNull
    public static final Name INC;
    @JvmField
    @NotNull
    public static final Name DEC;
    @JvmField
    @NotNull
    public static final Name PLUS;
    @JvmField
    @NotNull
    public static final Name MINUS;
    @JvmField
    @NotNull
    public static final Name NOT;
    @JvmField
    @NotNull
    public static final Name UNARY_MINUS;
    @JvmField
    @NotNull
    public static final Name UNARY_PLUS;
    @JvmField
    @NotNull
    public static final Name TIMES;
    @JvmField
    @NotNull
    public static final Name DIV;
    @JvmField
    @NotNull
    public static final Name REM;
    @JvmField
    @NotNull
    public static final Name RANGE_TO;
    @JvmField
    @NotNull
    public static final Name RANGE_UNTIL;
    @JvmField
    @NotNull
    public static final Name TIMES_ASSIGN;
    @JvmField
    @NotNull
    public static final Name DIV_ASSIGN;
    @JvmField
    @NotNull
    public static final Name REM_ASSIGN;
    @JvmField
    @NotNull
    public static final Name PLUS_ASSIGN;
    @JvmField
    @NotNull
    public static final Name MINUS_ASSIGN;
    @JvmField
    @NotNull
    public static final Name TO_DOUBLE;
    @JvmField
    @NotNull
    public static final Name TO_FLOAT;
    @JvmField
    @NotNull
    public static final Name TO_LONG;
    @JvmField
    @NotNull
    public static final Name TO_INT;
    @JvmField
    @NotNull
    public static final Name TO_CHAR;
    @JvmField
    @NotNull
    public static final Name TO_SHORT;
    @JvmField
    @NotNull
    public static final Name TO_BYTE;
    @JvmField
    @NotNull
    public static final Set<Name> UNARY_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> SIMPLE_UNARY_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> BINARY_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> SIMPLE_BINARY_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> BITWISE_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> SIMPLE_BITWISE_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> ALL_BINARY_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> ASSIGNMENT_OPERATIONS;
    @JvmField
    @NotNull
    public static final Set<Name> DELEGATED_PROPERTY_OPERATORS;
    @JvmField
    @NotNull
    public static final Set<Name> STATEMENT_LIKE_OPERATORS;
    @JvmField
    @NotNull
    public static final Set<Name> NUMBER_CONVERSIONS;
    @NotNull
    private static final Map<Name, String> TOKENS_BY_OPERATOR_NAME;

    private OperatorNameConventions() {
    }

    static {
        Name name = Name.identifier("getValue");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        GET_VALUE = name;
        Name name2 = Name.identifier("setValue");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        SET_VALUE = name2;
        Name name3 = Name.identifier("provideDelegate");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        PROVIDE_DELEGATE = name3;
        Name name4 = Name.identifier("equals");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        EQUALS = name4;
        Name name5 = Name.identifier("hashCode");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
        HASH_CODE = name5;
        Name name6 = Name.identifier("compareTo");
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"identifier(...)");
        COMPARE_TO = name6;
        Name name7 = Name.identifier("contains");
        Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"identifier(...)");
        CONTAINS = name7;
        Name name8 = Name.identifier("invoke");
        Intrinsics.checkNotNullExpressionValue((Object)name8, (String)"identifier(...)");
        INVOKE = name8;
        Name name9 = Name.identifier("iterator");
        Intrinsics.checkNotNullExpressionValue((Object)name9, (String)"identifier(...)");
        ITERATOR = name9;
        Name name10 = Name.identifier("get");
        Intrinsics.checkNotNullExpressionValue((Object)name10, (String)"identifier(...)");
        GET = name10;
        Name name11 = Name.identifier("set");
        Intrinsics.checkNotNullExpressionValue((Object)name11, (String)"identifier(...)");
        SET = name11;
        Name name12 = Name.identifier("next");
        Intrinsics.checkNotNullExpressionValue((Object)name12, (String)"identifier(...)");
        NEXT = name12;
        Name name13 = Name.identifier("hasNext");
        Intrinsics.checkNotNullExpressionValue((Object)name13, (String)"identifier(...)");
        HAS_NEXT = name13;
        Name name14 = Name.identifier("toString");
        Intrinsics.checkNotNullExpressionValue((Object)name14, (String)"identifier(...)");
        TO_STRING = name14;
        COMPONENT_REGEX = new Regex("component\\d+");
        Name name15 = Name.identifier("and");
        Intrinsics.checkNotNullExpressionValue((Object)name15, (String)"identifier(...)");
        AND = name15;
        Name name16 = Name.identifier("or");
        Intrinsics.checkNotNullExpressionValue((Object)name16, (String)"identifier(...)");
        OR = name16;
        Name name17 = Name.identifier("xor");
        Intrinsics.checkNotNullExpressionValue((Object)name17, (String)"identifier(...)");
        XOR = name17;
        Name name18 = Name.identifier("inv");
        Intrinsics.checkNotNullExpressionValue((Object)name18, (String)"identifier(...)");
        INV = name18;
        Name name19 = Name.identifier("shl");
        Intrinsics.checkNotNullExpressionValue((Object)name19, (String)"identifier(...)");
        SHL = name19;
        Name name20 = Name.identifier("shr");
        Intrinsics.checkNotNullExpressionValue((Object)name20, (String)"identifier(...)");
        SHR = name20;
        Name name21 = Name.identifier("ushr");
        Intrinsics.checkNotNullExpressionValue((Object)name21, (String)"identifier(...)");
        USHR = name21;
        Name name22 = Name.identifier("inc");
        Intrinsics.checkNotNullExpressionValue((Object)name22, (String)"identifier(...)");
        INC = name22;
        Name name23 = Name.identifier("dec");
        Intrinsics.checkNotNullExpressionValue((Object)name23, (String)"identifier(...)");
        DEC = name23;
        Name name24 = Name.identifier("plus");
        Intrinsics.checkNotNullExpressionValue((Object)name24, (String)"identifier(...)");
        PLUS = name24;
        Name name25 = Name.identifier("minus");
        Intrinsics.checkNotNullExpressionValue((Object)name25, (String)"identifier(...)");
        MINUS = name25;
        Name name26 = Name.identifier("not");
        Intrinsics.checkNotNullExpressionValue((Object)name26, (String)"identifier(...)");
        NOT = name26;
        Name name27 = Name.identifier("unaryMinus");
        Intrinsics.checkNotNullExpressionValue((Object)name27, (String)"identifier(...)");
        UNARY_MINUS = name27;
        Name name28 = Name.identifier("unaryPlus");
        Intrinsics.checkNotNullExpressionValue((Object)name28, (String)"identifier(...)");
        UNARY_PLUS = name28;
        Name name29 = Name.identifier("times");
        Intrinsics.checkNotNullExpressionValue((Object)name29, (String)"identifier(...)");
        TIMES = name29;
        Name name30 = Name.identifier("div");
        Intrinsics.checkNotNullExpressionValue((Object)name30, (String)"identifier(...)");
        DIV = name30;
        Name name31 = Name.identifier("rem");
        Intrinsics.checkNotNullExpressionValue((Object)name31, (String)"identifier(...)");
        REM = name31;
        Name name32 = Name.identifier("rangeTo");
        Intrinsics.checkNotNullExpressionValue((Object)name32, (String)"identifier(...)");
        RANGE_TO = name32;
        Name name33 = Name.identifier("rangeUntil");
        Intrinsics.checkNotNullExpressionValue((Object)name33, (String)"identifier(...)");
        RANGE_UNTIL = name33;
        Name name34 = Name.identifier("timesAssign");
        Intrinsics.checkNotNullExpressionValue((Object)name34, (String)"identifier(...)");
        TIMES_ASSIGN = name34;
        Name name35 = Name.identifier("divAssign");
        Intrinsics.checkNotNullExpressionValue((Object)name35, (String)"identifier(...)");
        DIV_ASSIGN = name35;
        Name name36 = Name.identifier("remAssign");
        Intrinsics.checkNotNullExpressionValue((Object)name36, (String)"identifier(...)");
        REM_ASSIGN = name36;
        Name name37 = Name.identifier("plusAssign");
        Intrinsics.checkNotNullExpressionValue((Object)name37, (String)"identifier(...)");
        PLUS_ASSIGN = name37;
        Name name38 = Name.identifier("minusAssign");
        Intrinsics.checkNotNullExpressionValue((Object)name38, (String)"identifier(...)");
        MINUS_ASSIGN = name38;
        Name name39 = Name.identifier("toDouble");
        Intrinsics.checkNotNullExpressionValue((Object)name39, (String)"identifier(...)");
        TO_DOUBLE = name39;
        Name name40 = Name.identifier("toFloat");
        Intrinsics.checkNotNullExpressionValue((Object)name40, (String)"identifier(...)");
        TO_FLOAT = name40;
        Name name41 = Name.identifier("toLong");
        Intrinsics.checkNotNullExpressionValue((Object)name41, (String)"identifier(...)");
        TO_LONG = name41;
        Name name42 = Name.identifier("toInt");
        Intrinsics.checkNotNullExpressionValue((Object)name42, (String)"identifier(...)");
        TO_INT = name42;
        Name name43 = Name.identifier("toChar");
        Intrinsics.checkNotNullExpressionValue((Object)name43, (String)"identifier(...)");
        TO_CHAR = name43;
        Name name44 = Name.identifier("toShort");
        Intrinsics.checkNotNullExpressionValue((Object)name44, (String)"identifier(...)");
        TO_SHORT = name44;
        Name name45 = Name.identifier("toByte");
        Intrinsics.checkNotNullExpressionValue((Object)name45, (String)"identifier(...)");
        TO_BYTE = name45;
        Object[] objectArray = new Name[]{INC, DEC, UNARY_PLUS, UNARY_MINUS, NOT, INV};
        UNARY_OPERATION_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Name[]{UNARY_PLUS, UNARY_MINUS, NOT, INV};
        SIMPLE_UNARY_OPERATION_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Name[]{TIMES, PLUS, MINUS, DIV, REM, RANGE_TO, RANGE_UNTIL};
        BINARY_OPERATION_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Name[]{TIMES, PLUS, MINUS, DIV, REM};
        SIMPLE_BINARY_OPERATION_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Name[]{AND, OR, XOR, INV, SHL, SHR, USHR};
        BITWISE_OPERATION_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Name[]{AND, OR, XOR, SHL, SHR, USHR};
        SIMPLE_BITWISE_OPERATION_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Name[]{EQUALS, CONTAINS, COMPARE_TO};
        ALL_BINARY_OPERATION_NAMES = SetsKt.plus((Set)SetsKt.plus(BINARY_OPERATION_NAMES, (Iterable)BITWISE_OPERATION_NAMES), (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new Name[]{TIMES_ASSIGN, DIV_ASSIGN, REM_ASSIGN, PLUS_ASSIGN, MINUS_ASSIGN};
        ASSIGNMENT_OPERATIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Name[]{GET_VALUE, SET_VALUE, PROVIDE_DELEGATE};
        DELEGATED_PROPERTY_OPERATORS = SetsKt.setOf((Object[])objectArray);
        STATEMENT_LIKE_OPERATORS = SetsKt.plus((Set)SetsKt.setOf((Object)SET), (Iterable)ASSIGNMENT_OPERATIONS);
        objectArray = new Name[]{TO_DOUBLE, TO_FLOAT, TO_LONG, TO_INT, TO_SHORT, TO_BYTE, TO_CHAR};
        NUMBER_CONVERSIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)INC, (Object)"++"), TuplesKt.to((Object)DEC, (Object)"--"), TuplesKt.to((Object)UNARY_PLUS, (Object)"+"), TuplesKt.to((Object)UNARY_MINUS, (Object)"-"), TuplesKt.to((Object)NOT, (Object)"!"), TuplesKt.to((Object)TIMES, (Object)"*"), TuplesKt.to((Object)PLUS, (Object)"+"), TuplesKt.to((Object)MINUS, (Object)"-"), TuplesKt.to((Object)DIV, (Object)"/"), TuplesKt.to((Object)REM, (Object)"%"), TuplesKt.to((Object)RANGE_TO, (Object)".."), TuplesKt.to((Object)RANGE_UNTIL, (Object)"..<")};
        TOKENS_BY_OPERATOR_NAME = MapsKt.mapOf((Pair[])objectArray);
    }
}

