/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Node;
import org.jspecify.annotations.Nullable;

public class Nodes<T extends Node>
extends ArrayList<T> {
    public Nodes() {
    }

    public Nodes(int initialCapacity) {
        super(initialCapacity);
    }

    public Nodes(Collection<T> nodes) {
        super(nodes);
    }

    public Nodes(List<T> nodes) {
        super(nodes);
    }

    @SafeVarargs
    public Nodes(T ... nodes) {
        super(Arrays.asList(nodes));
    }

    @Override
    public Nodes<T> clone() {
        Nodes<T> clone = new Nodes<T>(this.size());
        for (Node node2 : this) {
            clone.add(node2.clone());
        }
        return clone;
    }

    public ArrayList<T> asList() {
        return new ArrayList(this);
    }

    public Nodes<T> remove() {
        for (Node node2 : this) {
            node2.remove();
        }
        return this;
    }

    public String outerHtml() {
        return this.stream().map(Node::outerHtml).collect(StringUtil.joining("\n"));
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    public Nodes<T> before(String html2) {
        for (Node node2 : this) {
            node2.before(html2);
        }
        return this;
    }

    public Nodes<T> after(String html2) {
        for (Node node2 : this) {
            node2.after(html2);
        }
        return this;
    }

    public Nodes<T> wrap(String html2) {
        Validate.notEmpty(html2);
        for (Node node2 : this) {
            node2.wrap(html2);
        }
        return this;
    }

    public @Nullable T first() {
        return (T)(this.isEmpty() ? null : (Node)this.get(0));
    }

    public @Nullable T last() {
        return (T)(this.isEmpty() ? null : (Node)this.get(this.size() - 1));
    }

    @Override
    public T set(int index2, T node2) {
        Validate.notNull(node2);
        Node old = (Node)super.set(index2, node2);
        old.replaceWith((Node)node2);
        return (T)old;
    }

    @Override
    public T remove(int index2) {
        Node old = (Node)super.remove(index2);
        old.remove();
        return (T)old;
    }

    @Override
    public boolean remove(Object o) {
        int index2 = super.indexOf(o);
        if (index2 == -1) {
            return false;
        }
        this.remove(index2);
        return true;
    }

    public T deselect(int index2) {
        return (T)((Node)super.remove(index2));
    }

    public boolean deselect(Object o) {
        return super.remove(o);
    }

    @Override
    public void clear() {
        this.remove();
        super.clear();
    }

    public void deselectAll() {
        super.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean anyRemoved = false;
        for (Object o : c) {
            anyRemoved |= this.remove(o);
        }
        return anyRemoved;
    }

    @Override
    public boolean retainAll(Collection<?> toRemove) {
        boolean anyRemoved = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Node el = (Node)it.next();
            if (toRemove.contains(el)) continue;
            it.remove();
            anyRemoved = true;
        }
        return anyRemoved;
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter2) {
        boolean anyRemoved = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Node node2 = (Node)it.next();
            if (!filter2.test(node2)) continue;
            it.remove();
            anyRemoved = true;
        }
        return anyRemoved;
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.set(i2, (T)((Node)operator.apply((Node)this.get(i2))));
        }
    }
}

