/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.jackson.WebAuthnCBORModule;
import com.webauthn4j.converter.jackson.WebAuthnJSONModule;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.util.AssertUtil;
import org.jetbrains.annotations.NotNull;

public class ObjectConverter {
    private final JsonConverter jsonConverter;
    private final CborConverter cborConverter;

    public ObjectConverter(@NotNull ObjectMapper jsonMapper, @NotNull ObjectMapper cborMapper) {
        AssertUtil.notNull(jsonMapper, "jsonMapper must not be null");
        AssertUtil.notNull(cborMapper, "cborMapper must not be null");
        AssertUtil.isTrue(!(jsonMapper.getFactory() instanceof CBORFactory), "factory of jsonMapper must be JsonFactory.");
        AssertUtil.isTrue(cborMapper.getFactory() instanceof CBORFactory, "factory of cborMapper must be CBORFactory.");
        this.jsonConverter = new JsonConverter(jsonMapper);
        this.cborConverter = new CborConverter(cborMapper);
        ObjectConverter.initializeJsonMapper(jsonMapper, this);
        ObjectConverter.initializeCborMapper(cborMapper, this);
    }

    public ObjectConverter() {
        this(new ObjectMapper(), new ObjectMapper(new CBORFactory()));
    }

    private static void initializeJsonMapper(@NotNull ObjectMapper jsonMapper, @NotNull ObjectConverter objectConverter) {
        jsonMapper.registerModule(new WebAuthnJSONModule(objectConverter));
        jsonMapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, false);
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    private static void initializeCborMapper(@NotNull ObjectMapper cborMapper, @NotNull ObjectConverter objectConverter) {
        cborMapper.registerModule(new WebAuthnCBORModule(objectConverter));
        cborMapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, false);
        cborMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        cborMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @NotNull
    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    @NotNull
    public CborConverter getCborConverter() {
        return this.cborConverter;
    }
}

