/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonType;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ThresholdMixin;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.JsonNodeUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveMaximumValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ExclusiveMaximumValidator.class);
    private final ThresholdMixin typedMaximum;

    public ExclusiveMaximumValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, final JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.EXCLUSIVE_MAXIMUM, validationContext);
        if (!schemaNode.isNumber()) {
            throw new JsonSchemaException("exclusiveMaximum value is not a number");
        }
        final String maximumText = schemaNode.asText();
        if ((schemaNode.isLong() || schemaNode.isInt()) && JsonType.INTEGER.toString().equals(this.getNodeFieldType())) {
            final long lm = schemaNode.asLong();
            this.typedMaximum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node2) {
                    if (node2.isBigInteger()) {
                        int compare = node2.bigIntegerValue().compareTo(new BigInteger(schemaNode.asText()));
                        return compare > 0 || compare == 0;
                    }
                    if (node2.isTextual()) {
                        BigDecimal max = new BigDecimal(maximumText);
                        BigDecimal value = new BigDecimal(node2.asText());
                        int compare = value.compareTo(max);
                        return compare > 0 || compare == 0;
                    }
                    long val = node2.asLong();
                    return lm < val || lm == val;
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(lm);
                }
            };
        } else {
            this.typedMaximum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node2) {
                    if (schemaNode.isDouble() && schemaNode.doubleValue() == Double.POSITIVE_INFINITY) {
                        return false;
                    }
                    if (schemaNode.isDouble() && schemaNode.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return true;
                    }
                    if (node2.isDouble() && node2.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return false;
                    }
                    if (node2.isDouble() && node2.doubleValue() == Double.POSITIVE_INFINITY) {
                        return true;
                    }
                    BigDecimal max = new BigDecimal(maximumText);
                    BigDecimal value = new BigDecimal(node2.asText());
                    int compare = value.compareTo(max);
                    return compare > 0 || compare == 0;
                }

                @Override
                public String thresholdValue() {
                    return maximumText;
                }
            };
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        ExclusiveMaximumValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        if (!JsonNodeUtil.isNumber(node2, this.validationContext.getConfig())) {
            return Collections.emptySet();
        }
        if (this.typedMaximum.crossesThreshold(node2)) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node2)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(this.typedMaximum.thresholdValue())).build());
        }
        return Collections.emptySet();
    }
}

