/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.libcache.PublicationPinState;
import com.ustadmobile.libcache.db.entities.DownloadJobItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00a7@\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u00a7@\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u00a7@\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u00a7@\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u00a7@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u00a7@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u0013H'\u00a8\u0006\u001c"}, d2={"Lcom/ustadmobile/libcache/db/dao/DownloadJobItemDao;", "", "<init>", "()V", "upsertList", "", "items", "", "Lcom/ustadmobile/libcache/db/entities/DownloadJobItem;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findPendingByJobUid", "jobUid", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllByJobUid", "findNumberJobItemsNotComplete", "updateTransferredProgress", "jobItemUid", "transferred", "", "(IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateStatus", "status", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publicationPinState", "Lkotlinx/coroutines/flow/Flow;", "Lcom/ustadmobile/libcache/PublicationPinState;", "pubManifestHash", "respect-lib-cache_release"})
@Dao
public abstract class DownloadJobItemDao {
    @Insert(onConflict=1)
    @Nullable
    public abstract Object upsertList(@NotNull List<DownloadJobItem> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT DownloadJobItem.*\n          FROM DownloadJobItem\n         WHERE DownloadJobItem.djiDjUid = :jobUid\n           AND DownloadJobItem.djiStatus < 21\n    ")
    @Nullable
    public abstract Object findPendingByJobUid(int var1, @NotNull Continuation<? super List<DownloadJobItem>> var2);

    @Query(value="\n        SELECT DownloadJobItem.*\n          FROM DownloadJobItem\n         WHERE DownloadJobItem.djiDjUid = :jobUid\n    ")
    @Nullable
    public abstract Object findAllByJobUid(int var1, @NotNull Continuation<? super List<DownloadJobItem>> var2);

    @Query(value="\n       SELECT COUNT(*)\n         FROM DownloadJobItem\n        WHERE DownloadJobItem.djiDjUid = :jobUid\n          AND DownloadJobItem.djiStatus != 21\n    ")
    @Nullable
    public abstract Object findNumberJobItemsNotComplete(int var1, @NotNull Continuation<? super Integer> var2);

    @Query(value="\n        UPDATE DownloadJobItem\n           SET djiTransferred = :transferred\n         WHERE djiUid = :jobItemUid\n    ")
    @Nullable
    public abstract Object updateTransferredProgress(int var1, long var2, @NotNull Continuation<? super Unit> var4);

    @Query(value="\n        UPDATE DownloadJobItem\n           SET djiStatus = :status\n         WHERE djiUid = :jobItemUid  \n    ")
    @Nullable
    public abstract Object updateStatus(int var1, int var2, @NotNull Continuation<? super Unit> var3);

    @Query(value="\n        WITH MostRecentDlUid(uid) AS (\n            SELECT COALESCE(\n                   (SELECT DownloadJob.djUid\n                      FROM DownloadJob\n                     WHERE DownloadJob.djPubManifestHash = :pubManifestHash\n                  ORDER BY DownloadJob.djTimeCreated DESC\n                     LIMIT 1), 0)\n        )\n        \n        SELECT CASE((SELECT DownloadJob.djStatus\n                       FROM DownloadJob\n                      WHERE DownloadJob.djUid = (SELECT uid FROM MostRecentDlUid)))\n                   WHEN 21 THEN 10\n                   WHEN 11 THEN 3\n                   WHEN 2 THEN 2\n                   ELSE 0\n                   END AS status,\n               (SELECT SUM(DownloadJobItem.djiTransferred)\n                  FROM DownloadJobItem\n                 WHERE DownloadJobItem.djiDjUid = (SELECT uid FROM MostRecentDlUid)) AS transferred,\n               (SELECT SUM(DownloadJobItem.djiTotalSize)\n                  FROM DownloadJobItem\n                 WHERE DownloadJobItem.djiDjUid = (SELECT uid FROM MostRecentDlUid)) AS totalSize  \n    ")
    @NotNull
    public abstract Flow<PublicationPinState> publicationPinState(long var1);
}

