/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.xapi.savestatementonclear;

import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.core.domain.xapi.model.XapiStatement;
import com.ustadmobile.core.domain.xapi.savestatementonclear.SaveStatementOnClearJob;
import com.ustadmobile.core.domain.xapi.savestatementonclear.SaveStatementOnClearUseCase;
import com.ustadmobile.lib.db.entities.xapi.XapiSessionEntity;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/ustadmobile/core/domain/xapi/savestatementonclear/SaveStatementOnClearUseCaseJvm;", "Lcom/ustadmobile/core/domain/xapi/savestatementonclear/SaveStatementOnClearUseCase;", "scheduler", "Lorg/quartz/Scheduler;", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "json", "Lkotlinx/serialization/json/Json;", "(Lorg/quartz/Scheduler;Lcom/ustadmobile/core/account/Endpoint;Lkotlinx/serialization/json/Json;)V", "invoke", "", "statements", "", "Lcom/ustadmobile/core/domain/xapi/model/XapiStatement;", "xapiSession", "Lcom/ustadmobile/lib/db/entities/xapi/XapiSessionEntity;", "core"})
@SourceDebugExtension(value={"SMAP\nSaveStatementOnClearUseCaseJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveStatementOnClearUseCaseJvm.kt\ncom/ustadmobile/core/domain/xapi/savestatementonclear/SaveStatementOnClearUseCaseJvm\n+ 2 uuid.kt\ncom/benasher44/uuid/UuidKt\n*L\n1#1,43:1\n100#2:44\n*S KotlinDebug\n*F\n+ 1 SaveStatementOnClearUseCaseJvm.kt\ncom/ustadmobile/core/domain/xapi/savestatementonclear/SaveStatementOnClearUseCaseJvm\n*L\n36#1:44\n*E\n"})
public final class SaveStatementOnClearUseCaseJvm
implements SaveStatementOnClearUseCase {
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final Endpoint endpoint;
    @NotNull
    private final Json json;

    public SaveStatementOnClearUseCaseJvm(@NotNull Scheduler scheduler, @NotNull Endpoint endpoint, @NotNull Json json) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.scheduler = scheduler;
        this.endpoint = endpoint;
        this.json = json;
    }

    @Override
    public void invoke(@NotNull List<XapiStatement> statements, @NotNull XapiSessionEntity xapiSession) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        Intrinsics.checkNotNullParameter((Object)xapiSession, (String)"xapiSession");
        String statementJsonStr = this.json.encodeToString((SerializationStrategy)BuiltinSerializersKt.ListSerializer(XapiStatement.Companion.serializer()), statements);
        JobDetail quartzJob = JobBuilder.newJob(SaveStatementOnClearJob.class).usingJobData("endpoint", this.endpoint.getUrl()).usingJobData("statements", statementJsonStr).usingJobData("xapiSession", this.json.encodeToString((SerializationStrategy)XapiSessionEntity.Companion.serializer(), (Object)xapiSession)).build();
        boolean $i$f$uuid4 = false;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        TriggerKey triggerKey = new TriggerKey("save-statement-" + uUID);
        Trigger jobTrigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).startNow().build();
        this.scheduler.scheduleJob(quartzJob, jobTrigger);
    }
}

