/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.binding.support.strings;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import uk.co.caprica.vlcj.binding.support.runtime.RuntimeUtil;

public final class NativeUri {
    public static String encodeUri(String uri) {
        String result;
        block4: {
            result = uri;
            if (NativeUri.containsUnicode(uri)) {
                try {
                    URI validUri = new URI(uri);
                    if (validUri.getScheme() == null) {
                        result = NativeUri.toLocalFileUri(uri);
                    }
                }
                catch (URISyntaxException e) {
                    if (!RuntimeUtil.isWindows()) break block4;
                    result = NativeUri.toLocalFileUri(uri);
                }
            }
        }
        return result;
    }

    public static String encodeFileUri(String filename) {
        return NativeUri.toLocalFileUri(filename);
    }

    private static boolean containsUnicode(String value) {
        boolean result = false;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) < '\u0080') continue;
            result = true;
            break;
        }
        return result;
    }

    private static String toLocalFileUri(String value) {
        String asciiString = new File(value).toURI().toASCIIString();
        if (asciiString.startsWith("file://")) {
            return asciiString;
        }
        return asciiString.replaceFirst("file:/", "file:///");
    }

    private NativeUri() {
    }
}

