/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.CoreKt;
import kotlinx.io.InternalIoApi;
import kotlinx.io.PeekSource;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Segment;
import kotlinx.io.SegmentPool;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\r\u0010\u0014\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0000J\"\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u000b2\b\b\u0002\u0010\u001a\u001a\u00020\u000bJ\b\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0086\u0002J\b\u0010\"\u001a\u00020\u0012H\u0017J\b\u0010#\u001a\u00020\u0001H\u0016J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020%H\u0016J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u000bH\u0016J\b\u0010)\u001a\u00020 H\u0016J\b\u0010*\u001a\u00020%H\u0016J\b\u0010+\u001a\u00020\u000bH\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00122\u0006\u0010&\u001a\u00020/2\u0006\u0010(\u001a\u00020\u000bH\u0016J\u0010\u00100\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u000bH\u0016J\u0010\u00101\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u000bH\u0016J\u0010\u00102\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u000bH\u0016J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020/H\u0016J\u0015\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020%H\u0000\u00a2\u0006\u0002\b;J \u0010<\u001a\u00020\u00122\u0006\u00106\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020%H\u0016J\u0018\u0010<\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u000bH\u0016J\u0018\u0010<\u001a\u00020\u00122\u0006\u00106\u001a\u0002072\u0006\u0010(\u001a\u00020\u000bH\u0016J\u0010\u0010=\u001a\u00020\u00122\u0006\u0010>\u001a\u00020 H\u0016J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u00020%H\u0016J\u0010\u0010A\u001a\u00020\u00122\u0006\u0010B\u001a\u00020\u000bH\u0016J\u0010\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020-H\u0016R\u001c\u0010\u0004\u001a\u00020\u00008\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0003\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\t8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006E"}, d2={"Lkotlinx/io/Buffer;", "Lkotlinx/io/Source;", "Lkotlinx/io/Sink;", "()V", "buffer", "getBuffer$annotations", "getBuffer", "()Lkotlinx/io/Buffer;", "head", "Lkotlinx/io/Segment;", "<set-?>", "", "size", "getSize", "()J", "setSize$kotlinx_io_core", "(J)V", "clear", "", "close", "completeSegmentByteCount", "completeSegmentByteCount$kotlinx_io_core", "copy", "copyTo", "out", "startIndex", "endIndex", "emit", "exhausted", "", "flush", "get", "", "position", "hintEmit", "peek", "readAtMostTo", "", "sink", "", "byteCount", "readByte", "readInt", "readLong", "readShort", "", "readTo", "Lkotlinx/io/RawSink;", "request", "require", "skip", "toString", "", "transferFrom", "source", "Lkotlinx/io/RawSource;", "transferTo", "writableSegment", "minimumCapacity", "writableSegment$kotlinx_io_core", "write", "writeByte", "byte", "writeInt", "int", "writeLong", "long", "writeShort", "short", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buffer.kt\nkotlinx/io/Buffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -Util.kt\nkotlinx/io/_UtilKt\n+ 4 Buffer.kt\nkotlinx/io/BufferKt\n*L\n1#1,677:1\n1#2:678\n1#2:720\n1#2:725\n1#2:728\n1#2:732\n97#3:679\n97#3:680\n97#3:681\n97#3:682\n97#3:683\n97#3:684\n97#3:685\n97#3:686\n97#3:687\n97#3:688\n106#3:689\n106#3:690\n100#3:691\n100#3:692\n100#3:693\n100#3:694\n100#3:695\n100#3:696\n100#3:697\n100#3:698\n52#3:719\n53#3:721\n109#3:722\n38#3:723\n52#3:724\n53#3:726\n52#3:727\n53#3:729\n38#3:730\n52#3:731\n53#3:733\n112#3:734\n655#4,20:699\n*S KotlinDebug\n*F\n+ 1 Buffer.kt\nkotlinx/io/Buffer\n*L\n309#1:720\n347#1:725\n355#1:728\n416#1:732\n96#1:679\n101#1:680\n124#1:681\n125#1:682\n126#1:683\n127#1:684\n133#1:685\n134#1:686\n135#1:687\n136#1:688\n160#1:689\n161#1:690\n167#1:691\n168#1:692\n169#1:693\n170#1:694\n171#1:695\n172#1:696\n173#1:697\n174#1:698\n309#1:719\n309#1:721\n314#1:722\n327#1:723\n347#1:724\n347#1:726\n355#1:727\n355#1:729\n396#1:730\n416#1:731\n416#1:733\n619#1:734\n289#1:699,20\n*E\n"})
public final class Buffer
implements Source,
Sink {
    @JvmField
    @Nullable
    public Segment head;
    private long size;
    @NotNull
    private final Buffer buffer = this;

    public final long getSize() {
        return this.size;
    }

    public final void setSize$kotlinx_io_core(long l) {
        this.size = l;
    }

    @Override
    @NotNull
    public Buffer getBuffer() {
        return this.buffer;
    }

    @InternalIoApi
    public static /* synthetic */ void getBuffer$annotations() {
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long byteCount) {
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.size < byteCount) {
            throw new EOFException("Buffer doesn't contain required number of bytes (size: " + this.size + ", required: " + byteCount + ')');
        }
    }

    @Override
    public boolean request(long byteCount) {
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount + " < 0";
            throw new IllegalArgumentException(string.toString());
        }
        return this.size >= byteCount;
    }

    @Override
    public byte readByte() {
        this.require(1L);
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment;
        int pos = segment2.pos;
        int limit = segment2.limit;
        byte[] data = segment2.data;
        byte b = data[pos++];
        --this.size;
        if (pos == limit) {
            this.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = pos;
        }
        return b;
    }

    @Override
    public short readShort() {
        byte $this$and$iv;
        this.require(2L);
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment;
        int pos = segment2.pos;
        int limit = segment2.limit;
        if (limit - pos < 2) {
            byte $this$and$iv2;
            byte by = this.readByte();
            int other$iv = 255;
            boolean $i$f$and = false;
            int n = ($this$and$iv2 & other$iv) << 8;
            $this$and$iv2 = this.readByte();
            other$iv = 255;
            $i$f$and = false;
            int s = n | $this$and$iv2 & other$iv;
            return (short)s;
        }
        byte[] data = segment2.data;
        byte other$iv = data[pos++];
        int other$iv2 = 255;
        boolean $i$f$and = false;
        int n = ($this$and$iv & other$iv2) << 8;
        $this$and$iv = data[pos++];
        other$iv2 = 255;
        $i$f$and = false;
        int s = n | $this$and$iv & other$iv2;
        this.size -= 2L;
        if (pos == limit) {
            this.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = pos;
        }
        return (short)s;
    }

    @Override
    public int readInt() {
        byte $this$and$iv;
        this.require(4L);
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment;
        int pos = segment2.pos;
        int limit = segment2.limit;
        if ((long)(limit - pos) < 4L) {
            byte $this$and$iv2;
            byte by = this.readByte();
            int other$iv = 255;
            boolean $i$f$and = false;
            int n = ($this$and$iv2 & other$iv) << 24;
            $this$and$iv2 = this.readByte();
            other$iv = 255;
            $i$f$and = false;
            int n2 = n | ($this$and$iv2 & other$iv) << 16;
            $this$and$iv2 = this.readByte();
            other$iv = 255;
            $i$f$and = false;
            int n3 = n2 | ($this$and$iv2 & other$iv) << 8;
            $this$and$iv2 = this.readByte();
            other$iv = 255;
            $i$f$and = false;
            return n3 | $this$and$iv2 & other$iv;
        }
        byte[] data = segment2.data;
        byte $i$f$and = data[pos++];
        int other$iv = 255;
        boolean $i$f$and2 = false;
        int n = ($this$and$iv & other$iv) << 24;
        $this$and$iv = data[pos++];
        other$iv = 255;
        $i$f$and2 = false;
        int n4 = n | ($this$and$iv & other$iv) << 16;
        $this$and$iv = data[pos++];
        other$iv = 255;
        $i$f$and2 = false;
        int n5 = n4 | ($this$and$iv & other$iv) << 8;
        $this$and$iv = data[pos++];
        other$iv = 255;
        $i$f$and2 = false;
        int i = n5 | $this$and$iv & other$iv;
        this.size -= 4L;
        if (pos == limit) {
            this.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = pos;
        }
        return i;
    }

    @Override
    public long readLong() {
        byte $this$and$iv;
        this.require(8L);
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment;
        int pos = segment2.pos;
        int limit = segment2.limit;
        if ((long)(limit - pos) < 8L) {
            int $this$and$iv2;
            int n = this.readInt();
            long other$iv = 0xFFFFFFFFL;
            boolean $i$f$and = false;
            long l = ((long)$this$and$iv2 & other$iv) << 32;
            $this$and$iv2 = this.readInt();
            other$iv = 0xFFFFFFFFL;
            $i$f$and = false;
            return l | (long)$this$and$iv2 & other$iv;
        }
        byte[] data = segment2.data;
        byte $i$f$and = data[pos++];
        long other$iv = 255L;
        boolean $i$f$and2 = false;
        long l = ((long)$this$and$iv & other$iv) << 56;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l2 = l | ((long)$this$and$iv & other$iv) << 48;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l3 = l2 | ((long)$this$and$iv & other$iv) << 40;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l4 = l3 | ((long)$this$and$iv & other$iv) << 32;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l5 = l4 | ((long)$this$and$iv & other$iv) << 24;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l6 = l5 | ((long)$this$and$iv & other$iv) << 16;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long l7 = l6 | ((long)$this$and$iv & other$iv) << 8;
        $this$and$iv = data[pos++];
        other$iv = 255L;
        $i$f$and2 = false;
        long v = l7 | (long)$this$and$iv & other$iv;
        this.size -= 8L;
        if (pos == limit) {
            this.head = segment2.pop();
            SegmentPool.recycle(segment2);
        } else {
            segment2.pos = pos;
        }
        return v;
    }

    @Override
    @InternalIoApi
    public void hintEmit() {
    }

    @Override
    public void emit() {
    }

    @Override
    public void flush() {
    }

    public final void copyTo(@NotNull Buffer out, long startIndex, long endIndex) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        _UtilKt.checkBounds(this.size, startIndex, endIndex);
        if (startIndex == endIndex) {
            return;
        }
        long currentOffset = startIndex;
        long remainingByteCount = endIndex - startIndex;
        out.size += remainingByteCount;
        Segment s = this.head;
        while (true) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            if (currentOffset < (long)(segment.limit - s.pos)) break;
            currentOffset -= (long)(s.limit - s.pos);
            s = s.next;
        }
        while (remainingByteCount > 0L) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            Segment copy = segment.sharedCopy();
            copy.pos += (int)currentOffset;
            copy.limit = Math.min(copy.pos + (int)remainingByteCount, copy.limit);
            if (out.head == null) {
                out.head = copy.next = (copy.prev = copy);
            } else {
                Segment segment2 = out.head;
                Intrinsics.checkNotNull((Object)segment2);
                Segment segment3 = segment2.prev;
                Intrinsics.checkNotNull((Object)segment3);
                segment3.push(copy);
            }
            remainingByteCount -= (long)(copy.limit - copy.pos);
            currentOffset = 0L;
            s = s.next;
        }
    }

    public static /* synthetic */ void copyTo$default(Buffer buffer, Buffer buffer2, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = buffer.size;
        }
        buffer.copyTo(buffer2, l, l2);
    }

    public final long completeSegmentByteCount$kotlinx_io_core() {
        long result = this.size;
        if (result == 0L) {
            return 0L;
        }
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = segment.prev;
        Intrinsics.checkNotNull((Object)segment2);
        Segment tail = segment2;
        if (tail.limit < 8192 && tail.owner) {
            result -= (long)(tail.limit - tail.pos);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final byte get(long position) {
        void offset;
        long nextOffset$iv;
        if (position < 0L || position >= this.size) {
            throw new IndexOutOfBoundsException("position (" + position + ") is not within the range [0..size(" + this.size + "))");
        }
        Buffer $this$seek$iv = this;
        boolean $i$f$seek = false;
        Segment segment = $this$seek$iv.head;
        if (segment == null) {
            void offset2;
            long l = -1L;
            Object s = null;
            boolean bl = false;
            Object v1 = s;
            Intrinsics.checkNotNull(v1);
            return v1.data[(int)((long)s.pos + position - offset2)];
        }
        Segment s$iv = segment;
        if ($this$seek$iv.getSize() - position < position) {
            void offset3;
            long offset$iv;
            for (offset$iv = $this$seek$iv.getSize(); offset$iv > position; offset$iv -= (long)(s$iv.limit - s$iv.pos)) {
                Intrinsics.checkNotNull((Object)s$iv.prev);
            }
            long l = offset$iv;
            Segment s = s$iv;
            boolean bl = false;
            Segment segment2 = s;
            Intrinsics.checkNotNull((Object)segment2);
            return segment2.data[(int)((long)s.pos + position - offset3)];
        }
        long offset$iv = 0L;
        while ((nextOffset$iv = offset$iv + (long)(s$iv.limit - s$iv.pos)) <= position) {
            Intrinsics.checkNotNull((Object)s$iv.next);
            offset$iv = nextOffset$iv;
        }
        long l = offset$iv;
        Segment s = s$iv;
        boolean bl = false;
        Segment segment3 = s;
        Intrinsics.checkNotNull((Object)segment3);
        return segment3.data[(int)((long)s.pos + position - offset)];
    }

    public final void clear() {
        this.skip(this.size);
    }

    @Override
    public void skip(long byteCount) {
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        long remainingByteCount = byteCount;
        while (remainingByteCount > 0L) {
            Segment head;
            if (this.head == null) {
                throw new EOFException("Buffer exhausted before skipping " + byteCount + " bytes.");
            }
            int b$iv = head.limit - head.pos;
            boolean $i$f$minOf = false;
            int toSkip = (int)Math.min(remainingByteCount, (long)b$iv);
            this.size -= (long)toSkip;
            remainingByteCount -= (long)toSkip;
            head.pos += toSkip;
            if (head.pos != head.limit) continue;
            this.head = head.pop();
            SegmentPool.recycle(head);
        }
    }

    @Override
    public int readAtMostTo(@NotNull byte[] sink, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int size$iv = sink.length;
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment s = segment;
        int toCopy = Math.min(endIndex - startIndex, s.limit - s.pos);
        ArraysKt.copyInto((byte[])s.data, (byte[])sink, (int)startIndex, (int)s.pos, (int)(s.pos + toCopy));
        s.pos += toCopy;
        this.size -= (long)toCopy;
        if (s.pos == s.limit) {
            this.head = s.pop();
            SegmentPool.recycle(s);
        }
        return toCopy;
    }

    @Override
    public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.size == 0L) {
            return -1L;
        }
        long bytesWritten = byteCount > this.size ? this.size : byteCount;
        sink.write(this, bytesWritten);
        return bytesWritten;
    }

    @Override
    public void readTo(@NotNull RawSink sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.size < byteCount) {
            sink.write(this, this.size);
            throw new EOFException("Buffer exhausted before writing " + byteCount + " bytes. Only " + this.size + " bytes were written.");
        }
        sink.write(this, byteCount);
    }

    @Override
    public long transferTo(@NotNull RawSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long byteCount = this.size;
        if (byteCount > 0L) {
            sink.write(this, byteCount);
        }
        return byteCount;
    }

    @Override
    @NotNull
    public Source peek() {
        return CoreKt.buffered(new PeekSource(this));
    }

    @NotNull
    public final Segment writableSegment$kotlinx_io_core(int minimumCapacity) {
        Segment tail;
        if (!(minimumCapacity >= 1 && minimumCapacity <= 8192)) {
            boolean bl = false;
            String string = "unexpected capacity";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.head == null) {
            Segment result;
            this.head = result = SegmentPool.take();
            result.prev = result;
            result.next = result;
            return result;
        }
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment segment2 = tail = segment.prev;
        Intrinsics.checkNotNull((Object)segment2);
        if (segment2.limit + minimumCapacity > 8192 || !tail.owner) {
            tail = tail.push(SegmentPool.take());
        }
        return tail;
    }

    @Override
    public void write(@NotNull byte[] source, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int size$iv = source.length;
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        int currentOffset = startIndex;
        while (currentOffset < endIndex) {
            Segment tail = this.writableSegment$kotlinx_io_core(1);
            int toCopy = Math.min(endIndex - currentOffset, 8192 - tail.limit);
            ArraysKt.copyInto((byte[])source, (byte[])tail.data, (int)tail.limit, (int)currentOffset, (int)(currentOffset + toCopy));
            currentOffset += toCopy;
            tail.limit += toCopy;
        }
        this.size += (long)(endIndex - startIndex);
    }

    @Override
    public void write(@NotNull RawSource source, long byteCount) {
        long read;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= read) {
            read = source.readAtMostTo(this, remainingByteCount);
            if (read != -1L) continue;
            throw new EOFException("Source exhausted before reading " + byteCount + " bytes. Only " + (byteCount - remainingByteCount) + " were read.");
        }
    }

    @Override
    public void write(@NotNull Buffer source, long byteCount) {
        long movedByteCount;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(source != this)) {
            boolean bl = false;
            String string = "source == this";
            throw new IllegalArgumentException(string.toString());
        }
        _UtilKt.checkOffsetAndCount(source.size, 0L, byteCount);
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= movedByteCount) {
            Segment segmentToMove;
            Segment segment = source.head;
            Intrinsics.checkNotNull((Object)segment);
            int n = segment.limit;
            Segment segment2 = source.head;
            Intrinsics.checkNotNull((Object)segment2);
            if (remainingByteCount < (long)(n - segment2.pos)) {
                Segment tail;
                Segment segment3;
                if (this.head != null) {
                    Segment segment4 = this.head;
                    Intrinsics.checkNotNull((Object)segment4);
                    segment3 = segment4.prev;
                } else {
                    segment3 = tail = null;
                }
                if (tail != null && tail.owner && remainingByteCount + (long)tail.limit - (long)(tail.shared ? 0 : tail.pos) <= 8192L) {
                    Segment segment5 = source.head;
                    Intrinsics.checkNotNull((Object)segment5);
                    segment5.writeTo(tail, (int)remainingByteCount);
                    source.size -= remainingByteCount;
                    this.size += remainingByteCount;
                    return;
                }
                Segment segment6 = source.head;
                Intrinsics.checkNotNull((Object)segment6);
                source.head = segment6.split((int)remainingByteCount);
            }
            Segment segment7 = segmentToMove = source.head;
            Intrinsics.checkNotNull((Object)segment7);
            movedByteCount = segment7.limit - segmentToMove.pos;
            source.head = segmentToMove.pop();
            if (this.head == null) {
                this.head = segmentToMove;
                segmentToMove.next = segmentToMove.prev = segmentToMove;
            } else {
                Segment tail;
                Segment segment8 = this.head;
                Intrinsics.checkNotNull((Object)segment8);
                Segment segment9 = tail = segment8.prev;
                Intrinsics.checkNotNull((Object)segment9);
                tail = segment9.push(segmentToMove);
                tail.compact();
            }
            source.size -= movedByteCount;
            this.size += movedByteCount;
        }
    }

    @Override
    public long transferFrom(@NotNull RawSource source) {
        long readCount;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long totalBytesRead = 0L;
        while ((readCount = source.readAtMostTo(this, 8192L)) != -1L) {
            totalBytesRead += readCount;
        }
        return totalBytesRead;
    }

    @Override
    public void writeByte(byte by) {
        Segment tail = this.writableSegment$kotlinx_io_core(1);
        int n = tail.limit;
        tail.limit = n + 1;
        tail.data[n] = by;
        ++this.size;
    }

    @Override
    public void writeShort(short s) {
        Segment tail = this.writableSegment$kotlinx_io_core(2);
        byte[] data = tail.data;
        int limit = tail.limit;
        data[limit++] = (byte)(s >>> 8 & 0xFF);
        data[limit++] = (byte)(s & 0xFF);
        tail.limit = limit;
        this.size += 2L;
    }

    @Override
    public void writeInt(int n) {
        Segment tail = this.writableSegment$kotlinx_io_core(4);
        byte[] data = tail.data;
        int limit = tail.limit;
        data[limit++] = (byte)(n >>> 24 & 0xFF);
        data[limit++] = (byte)(n >>> 16 & 0xFF);
        data[limit++] = (byte)(n >>> 8 & 0xFF);
        data[limit++] = (byte)(n & 0xFF);
        tail.limit = limit;
        this.size += 4L;
    }

    @Override
    public void writeLong(long l) {
        Segment tail = this.writableSegment$kotlinx_io_core(8);
        byte[] data = tail.data;
        int limit = tail.limit;
        data[limit++] = (byte)(l >>> 56 & 0xFFL);
        data[limit++] = (byte)(l >>> 48 & 0xFFL);
        data[limit++] = (byte)(l >>> 40 & 0xFFL);
        data[limit++] = (byte)(l >>> 32 & 0xFFL);
        data[limit++] = (byte)(l >>> 24 & 0xFFL);
        data[limit++] = (byte)(l >>> 16 & 0xFFL);
        data[limit++] = (byte)(l >>> 8 & 0xFFL);
        data[limit++] = (byte)(l & 0xFFL);
        tail.limit = limit;
        this.size += 8L;
    }

    @NotNull
    public final Buffer copy() {
        Segment headCopy;
        Buffer result = new Buffer();
        if (this.size == 0L) {
            return result;
        }
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment head = segment;
        headCopy.next = headCopy.prev = (result.head = (headCopy = head.sharedCopy()));
        Segment s = head.next;
        while (s != head) {
            Segment segment2 = headCopy.prev;
            Intrinsics.checkNotNull((Object)segment2);
            Segment segment3 = s;
            Intrinsics.checkNotNull((Object)segment3);
            segment2.push(segment3.sharedCopy());
            s = s.next;
        }
        result.size = this.size;
        return result;
    }

    @Override
    public void close() {
    }

    @NotNull
    public String toString() {
        if (this.size == 0L) {
            return "Buffer(size=0)";
        }
        int maxPrintableBytes = 64;
        long b$iv = this.size;
        boolean $i$f$minOf = false;
        int len = (int)Math.min((long)maxPrintableBytes, b$iv);
        StringBuilder builder = new StringBuilder(len * 2 + (this.size > (long)maxPrintableBytes ? 1 : 0));
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment curr = segment;
        int pos = curr.pos;
        for (int bytesWritten = 0; bytesWritten < len; ++bytesWritten) {
            if (pos == curr.limit) {
                Intrinsics.checkNotNull((Object)curr.next);
                pos = curr.pos;
            }
            byte b = curr.data[pos++];
            builder.append(_UtilKt.getHEX_DIGIT_CHARS()[b >> 4 & 0xF]).append(_UtilKt.getHEX_DIGIT_CHARS()[b & 0xF]);
        }
        if (this.size > (long)maxPrintableBytes) {
            builder.append('\u2026');
        }
        return "Buffer(size=" + this.size + " hex=" + builder + ')';
    }
}

