/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Segment;
import kotlinx.io.SegmentPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkotlinx/io/InputStreamSource;", "Lkotlinx/io/RawSource;", "input", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "close", "", "readAtMostTo", "", "sink", "Lkotlinx/io/Buffer;", "byteCount", "toString", "", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nJvmCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCore.kt\nkotlinx/io/InputStreamSource\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n52#2:119\n53#2:121\n109#2:122\n1#3:120\n*S KotlinDebug\n*F\n+ 1 JvmCore.kt\nkotlinx/io/InputStreamSource\n*L\n83#1:119\n83#1:121\n86#1:122\n83#1:120\n*E\n"})
class InputStreamSource
implements RawSource {
    @NotNull
    private final InputStream input;

    public InputStreamSource(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
    }

    @Override
    public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (byteCount == 0L) {
            return 0L;
        }
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean $i$a$-require-_UtilKt$checkByteCount$1$iv22 = false;
            String $i$a$-require-_UtilKt$checkByteCount$1$iv22 = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException($i$a$-require-_UtilKt$checkByteCount$1$iv22.toString());
        }
        try {
            Segment tail = sink.writableSegment$kotlinx_io_core(1);
            int b$iv = 8192 - tail.limit;
            boolean $i$f$minOf = false;
            int maxToCopy = (int)Math.min(byteCount, (long)b$iv);
            int bytesRead = this.input.read(tail.data, tail.limit, maxToCopy);
            if (bytesRead == -1) {
                if (tail.pos == tail.limit) {
                    sink.head = tail.pop();
                    SegmentPool.recycle(tail);
                }
                return -1L;
            }
            tail.limit += bytesRead;
            sink.setSize$kotlinx_io_core(sink.getSize() + (long)bytesRead);
            return bytesRead;
        }
        catch (AssertionError e) {
            if (JvmCoreKt.isAndroidGetsocknameError(e)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
    }

    @Override
    public void close() {
        this.input.close();
    }

    @NotNull
    public String toString() {
        return "RawSource(" + this.input + ')';
    }
}

