/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.util.UUID;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

class UuidConverter
implements ConditionalConverter<Object, UUID> {
    UuidConverter() {
    }

    @Override
    public UUID convert(MappingContext<Object, UUID> context) {
        Object source = context.getSource();
        if (source == null) {
            return null;
        }
        Class<Object> sourceType = context.getSourceType();
        if (this.isCharArray(sourceType)) {
            return UUID.fromString(new String((char[])source));
        }
        return UUID.fromString(source.toString());
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        boolean destMatch;
        boolean bl = destMatch = destinationType == UUID.class;
        return destMatch ? (this.isCharArray(sourceType) || sourceType == String.class ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.PARTIAL) : ConditionalConverter.MatchResult.NONE;
    }

    private boolean isCharArray(Class<?> sourceType) {
        return sourceType.isArray() && (sourceType.getComponentType() == Character.TYPE || sourceType.getComponentType() == Character.class);
    }
}

