/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.commons.lang3.math.gson;

import com.google.errorprone.annotations.Immutable;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.apache.commons.lang3.math.Fraction;

@Immutable
public class FractionAdapter
extends TypeAdapter<Fraction> {
    private final Fraction zeroByZero;
    private final Fraction divideByZero;

    public FractionAdapter() {
        this(Fraction.ZERO, Fraction.ZERO);
    }

    private FractionAdapter(Fraction zeroByZero, Fraction divideByZero) {
        this.zeroByZero = zeroByZero;
        this.divideByZero = divideByZero;
    }

    public Fraction read(JsonReader reader) throws IOException {
        JsonToken next = reader.peek();
        if (next == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        if (next == JsonToken.NUMBER) {
            return Fraction.getFraction((double)reader.nextDouble());
        }
        String fraction = reader.nextString().trim();
        if (this.zeroByZero != null && "0/0".equals(fraction)) {
            return this.zeroByZero;
        }
        if (this.divideByZero != null && fraction.endsWith("/0")) {
            return this.divideByZero;
        }
        return Fraction.getFraction((String)fraction);
    }

    public void write(JsonWriter writer, Fraction value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.value(value.toProperString());
    }
}

