/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.gson;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class NamedBitsetAdapter<T>
extends TypeAdapter<T> {
    final Class<T> clazz;

    public NamedBitsetAdapter(Class<T> clazz) {
        this.clazz = (Class)Preconditions.checkNotNull(clazz);
    }

    protected Optional<Boolean> readBoolean(JsonReader reader) throws IOException {
        JsonToken next = reader.peek();
        switch (next) {
            case BOOLEAN: {
                return Optional.of((Object)reader.nextBoolean());
            }
            case NUMBER: {
                return Optional.of((Object)(reader.nextInt() != 0 ? 1 : 0));
            }
        }
        reader.skipValue();
        return Optional.absent();
    }

    protected void setField(T target, String name, boolean value) throws IllegalAccessException {
        try {
            Field f = this.clazz.getField(name);
            if (Boolean.TYPE.equals(f.getType())) {
                f.setBoolean(target, value);
            } else if (Integer.TYPE.equals(f.getType())) {
                f.setInt(target, value ? 1 : 0);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public T read(JsonReader reader) throws IOException {
        JsonToken next = reader.peek();
        if (next == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        try {
            T obj = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            reader.beginObject();
            next = reader.peek();
            while (next != JsonToken.END_OBJECT) {
                String name = reader.nextName();
                Optional<Boolean> value = this.readBoolean(reader);
                if (value.isPresent()) {
                    this.setField(obj, name, (Boolean)value.get());
                }
                next = reader.peek();
            }
            reader.endObject();
            return obj;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Reflection error", e);
        }
    }

    public void write(JsonWriter writer, T value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        assert (value.getClass().equals(this.clazz));
        writer.beginObject();
        for (Field f : this.clazz.getFields()) {
            try {
                boolean b;
                if (Boolean.TYPE.equals(f.getType())) {
                    b = f.getBoolean(value);
                } else {
                    if (!Integer.TYPE.equals(f.getType())) continue;
                    b = f.getInt(value) != 0;
                }
                writer.name(f.getName());
                writer.value(b);
            }
            catch (IllegalAccessException e) {
                throw new IOException("Reflection error", e);
            }
        }
        writer.endObject();
    }
}

