/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.progress;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import net.bramp.ffmpeg.FFmpegUtils;
import org.apache.commons.lang3.math.Fraction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Progress {
    static final Logger LOG = LoggerFactory.getLogger(Progress.class);
    public long frame = 0L;
    public Fraction fps = Fraction.ZERO;
    public long bitrate = 0L;
    public long total_size = 0L;
    public long out_time_ns = 0L;
    public long dup_frames = 0L;
    public long drop_frames = 0L;
    public float speed = 0.0f;
    public Status status = null;

    public Progress() {
    }

    public Progress(long frame, float fps, long bitrate, long total_size, long out_time_ns, long dup_frames, long drop_frames, float speed, Status status) {
        this.frame = frame;
        this.fps = Fraction.getFraction((double)fps);
        this.bitrate = bitrate;
        this.total_size = total_size;
        this.out_time_ns = out_time_ns;
        this.dup_frames = dup_frames;
        this.drop_frames = drop_frames;
        this.speed = speed;
        this.status = status;
    }

    protected boolean parseLine(String line) {
        if ((line = ((String)Preconditions.checkNotNull((Object)line)).trim()).isEmpty()) {
            return false;
        }
        String[] args = line.split("=", 2);
        if (args.length != 2) {
            return false;
        }
        String key = (String)Preconditions.checkNotNull((Object)args[0]);
        String value = (String)Preconditions.checkNotNull((Object)args[1]);
        switch (key) {
            case "frame": {
                this.frame = Long.parseLong(value);
                return false;
            }
            case "fps": {
                this.fps = Fraction.getFraction((String)value);
                return false;
            }
            case "bitrate": {
                this.bitrate = value.equals("N/A") ? -1L : FFmpegUtils.parseBitrate(value);
                return false;
            }
            case "total_size": {
                this.total_size = value.equals("N/A") ? -1L : Long.parseLong(value);
                return false;
            }
            case "out_time_ms": {
                return false;
            }
            case "out_time_us": {
                return false;
            }
            case "out_time": {
                this.out_time_ns = FFmpegUtils.fromTimecode(value);
                return false;
            }
            case "dup_frames": {
                this.dup_frames = Long.parseLong(value);
                return false;
            }
            case "drop_frames": {
                this.drop_frames = Long.parseLong(value);
                return false;
            }
            case "speed": {
                this.speed = value.equals("N/A") ? -1.0f : Float.parseFloat(value.replace("x", ""));
                return false;
            }
            case "progress": {
                this.status = Status.of(value);
                return true;
            }
        }
        if (!key.startsWith("stream_")) {
            LOG.warn("skipping unhandled key: {} = {}", (Object)key, (Object)value);
        }
        return false;
    }

    @CheckReturnValue
    public boolean isEnd() {
        return this.status == Status.END;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Progress progress1 = (Progress)o;
        return this.frame == progress1.frame && this.bitrate == progress1.bitrate && this.total_size == progress1.total_size && this.out_time_ns == progress1.out_time_ns && this.dup_frames == progress1.dup_frames && this.drop_frames == progress1.drop_frames && Float.compare(progress1.speed, this.speed) == 0 && Objects.equals(this.fps, progress1.fps) && Objects.equals((Object)this.status, (Object)progress1.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.frame, this.fps, this.bitrate, this.total_size, this.out_time_ns, this.dup_frames, this.drop_frames, Float.valueOf(this.speed), this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("frame", this.frame).add("fps", (Object)this.fps).add("bitrate", this.bitrate).add("total_size", this.total_size).add("out_time_ns", this.out_time_ns).add("dup_frames", this.dup_frames).add("drop_frames", this.drop_frames).add("speed", this.speed).add("status", (Object)this.status).toString();
    }

    public static enum Status {
        CONTINUE("continue"),
        END("end");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }

        public static Status of(String status) {
            for (Status s : Status.values()) {
                if (!status.equalsIgnoreCase(s.status)) continue;
                return s;
            }
            throw new IllegalArgumentException("invalid progress status '" + status + "'");
        }
    }
}

