/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.platform.AccessibilityController;
import androidx.compose.ui.platform.AccessibilityControllerImpl;
import androidx.compose.ui.platform.ComposeAccessible;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.TextRange;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleState;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\u0001.B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001f\u001a\u00020\tJ\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\bH\u0002J \u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001cH\u0002J\u0010\u0010)\u001a\u00020\t2\u0006\u0010$\u001a\u00020\bH\u0002J\b\u0010*\u001a\u00020\tH\u0016J\u0011\u0010+\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\tH\u0002R&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Landroidx/compose/ui/platform/AccessibilityControllerImpl;", "Landroidx/compose/ui/platform/AccessibilityController;", "owner", "Landroidx/compose/ui/semantics/SemanticsOwner;", "desktopComponent", "Landroidx/compose/ui/platform/PlatformComponent;", "onFocusReceived", "Lkotlin/Function1;", "Landroidx/compose/ui/platform/ComposeAccessible;", "", "(Landroidx/compose/ui/semantics/SemanticsOwner;Landroidx/compose/ui/platform/PlatformComponent;Lkotlin/jvm/functions/Function1;)V", "_currentNodes", "", "", "get_currentNodes", "()Ljava/util/Map;", "set_currentNodes", "(Ljava/util/Map;)V", "currentNodes", "getCurrentNodes", "currentNodesInvalidated", "", "getDesktopComponent", "()Landroidx/compose/ui/platform/PlatformComponent;", "rootAccessible", "getRootAccessible", "()Landroidx/compose/ui/platform/ComposeAccessible;", "rootSemanticNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "getRootSemanticNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "notifyIsInUse", "onLayoutChange", "layoutNode", "Landroidx/compose/ui/node/LayoutNode;", "onNodeAdded", "accessible", "onNodeChanged", "component", "previousSemanticsNode", "newSemanticsNode", "onNodeRemoved", "onSemanticsChange", "syncLoop", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "syncNodes", "SyncLoopState", "ui"})
public final class AccessibilityControllerImpl
implements AccessibilityController {
    @NotNull
    private final SemanticsOwner owner;
    @NotNull
    private final PlatformComponent desktopComponent;
    @NotNull
    private final Function1<ComposeAccessible, Unit> onFocusReceived;
    private boolean currentNodesInvalidated;
    @NotNull
    private Map<Integer, ComposeAccessible> _currentNodes;

    public AccessibilityControllerImpl(@NotNull SemanticsOwner owner2, @NotNull PlatformComponent desktopComponent, @NotNull Function1<? super ComposeAccessible, Unit> onFocusReceived) {
        Intrinsics.checkNotNullParameter((Object)owner2, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)desktopComponent, (String)"desktopComponent");
        Intrinsics.checkNotNullParameter(onFocusReceived, (String)"onFocusReceived");
        this.owner = owner2;
        this.desktopComponent = desktopComponent;
        this.onFocusReceived = onFocusReceived;
        this.currentNodesInvalidated = true;
        this._currentNodes = MapsKt.emptyMap();
    }

    @NotNull
    public final PlatformComponent getDesktopComponent() {
        return this.desktopComponent;
    }

    @NotNull
    public final Map<Integer, ComposeAccessible> get_currentNodes() {
        return this._currentNodes;
    }

    public final void set_currentNodes(@NotNull Map<Integer, ComposeAccessible> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this._currentNodes = map;
    }

    @NotNull
    public final Map<Integer, ComposeAccessible> getCurrentNodes() {
        if (this.currentNodesInvalidated) {
            this.syncNodes();
        }
        return this._currentNodes;
    }

    private final void onNodeAdded(ComposeAccessible accessible) {
    }

    private final void onNodeRemoved(ComposeAccessible accessible) {
        accessible.setRemoved(true);
    }

    private final void onNodeChanged(ComposeAccessible component2, SemanticsNode previousSemanticsNode, SemanticsNode newSemanticsNode) {
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : newSemanticsNode.getConfig()) {
            Object prev = SemanticsConfigurationKt.getOrNull(previousSemanticsNode.getConfig(), entry.getKey());
            if (Intrinsics.areEqual((Object)entry.getValue(), prev)) continue;
            SemanticsPropertyKey<?> semanticsPropertyKey = entry.getKey();
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getText())) {
                component2.getComposeAccessibleContext().firePropertyChange("AccessibleText", prev, entry.getValue());
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getEditableText())) {
                component2.getComposeAccessibleContext().firePropertyChange("AccessibleText", prev, entry.getValue());
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getTextSelectionRange())) {
                ComposeAccessible.ComposeAccessibleComponent composeAccessibleComponent = component2.getComposeAccessibleContext();
                Object object = entry.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.compose.ui.text.TextRange");
                composeAccessibleComponent.firePropertyChange("AccessibleCaret", prev, TextRange.getStart-impl((long)((TextRange)object).unbox-impl()));
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getFocused())) {
                Object object = entry.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                if (((Boolean)object).booleanValue()) {
                    component2.getComposeAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                    this.onFocusReceived.invoke((Object)component2);
                    continue;
                }
                component2.getComposeAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                continue;
            }
            if (Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getToggleableState())) {
                Object object = entry.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.compose.ui.state.ToggleableState");
                switch (WhenMappings.$EnumSwitchMapping$0[((ToggleableState)((Object)object)).ordinal()]) {
                    case 1: {
                        component2.getComposeAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                        break;
                    }
                    case 2: 
                    case 3: {
                        component2.getComposeAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                    }
                }
                continue;
            }
            if (!Intrinsics.areEqual(semanticsPropertyKey, SemanticsProperties.INSTANCE.getProgressBarRangeInfo())) continue;
            Object object = entry.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.compose.ui.semantics.ProgressBarRangeInfo");
            ProgressBarRangeInfo value = (ProgressBarRangeInfo)object;
            component2.getComposeAccessibleContext().firePropertyChange("AccessibleValue", prev, Float.valueOf(value.getCurrent()));
        }
    }

    public final void notifyIsInUse() {
        SyncLoopState.INSTANCE.setLastAccessTimeMillis(System.currentTimeMillis());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object syncLoop(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof syncLoop.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AccessibilityControllerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.syncLoop((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl13:
                // 2 sources

                while (true) {
                    if (this.currentNodesInvalidated && SyncLoopState.INSTANCE.getShouldSync()) {
                        this.syncNodes();
                    }
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)100L, (Continuation)$continuation);
                    if (v0 != var4_4) continue;
                    return var4_4;
                }
            }
            case 1: {
                this = (AccessibilityControllerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** continue;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void syncNodes() {
        if (!this.getRootSemanticNode().getLayoutNode$ui().isPlaced()) {
            return;
        }
        Map<Integer, ComposeAccessible> previous = this._currentNodes;
        Map nodes = new LinkedHashMap();
        AccessibilityControllerImpl.syncNodes$findAllSemanticNodesRecursive(nodes, previous, this, this.getRootSemanticNode());
        for (Map.Entry<Integer, ComposeAccessible> entry : previous.entrySet()) {
            int id = ((Number)entry.getKey()).intValue();
            ComposeAccessible prevNode = entry.getValue();
            if (nodes.get(id) != null) continue;
            this.onNodeRemoved(prevNode);
        }
        this._currentNodes = nodes;
        this.currentNodesInvalidated = false;
    }

    @Override
    public void onLayoutChange(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this.currentNodesInvalidated = true;
    }

    @Override
    public void onSemanticsChange() {
        this.currentNodesInvalidated = true;
    }

    @NotNull
    public final SemanticsNode getRootSemanticNode() {
        return this.owner.getRootSemanticsNode();
    }

    @NotNull
    public final ComposeAccessible getRootAccessible() {
        ComposeAccessible composeAccessible = this.getCurrentNodes().get(this.getRootSemanticNode().getId());
        Intrinsics.checkNotNull((Object)composeAccessible);
        return composeAccessible;
    }

    private static final void syncNodes$findAllSemanticNodesRecursive(Map<Integer, ComposeAccessible> nodes, Map<Integer, ComposeAccessible> previous, AccessibilityControllerImpl this$0, SemanticsNode currentNode) {
        ComposeAccessible composeAccessible;
        ComposeAccessible it;
        Map<Integer, ComposeAccessible> map = nodes;
        Integer n = currentNode.getId();
        ComposeAccessible composeAccessible2 = previous.get(currentNode.getId());
        if (composeAccessible2 != null) {
            it = composeAccessible2;
            boolean bl = false;
            SemanticsNode prevSemanticsNode = it.getSemanticsNode();
            it.setSemanticsNode(currentNode);
            this$0.onNodeChanged(it, prevSemanticsNode, currentNode);
            composeAccessible = it;
        } else {
            ComposeAccessible composeAccessible3;
            it = composeAccessible3 = new ComposeAccessible(currentNode, this$0);
            boolean bl = false;
            this$0.onNodeAdded(it);
            composeAccessible = composeAccessible3;
        }
        ComposeAccessible composeAccessible4 = composeAccessible;
        map.put(n, composeAccessible4);
        List<SemanticsNode> children = currentNode.getReplacedChildren$ui();
        for (int i = children.size() - 1; -1 < i; --i) {
            AccessibilityControllerImpl.syncNodes$findAllSemanticNodesRecursive(nodes, previous, this$0, children.get(i));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Landroidx/compose/ui/platform/AccessibilityControllerImpl$SyncLoopState;", "", "()V", "lastAccessTimeMillis", "", "getLastAccessTimeMillis", "()J", "setLastAccessTimeMillis", "(J)V", "maxIdleTimeMillis", "", "getMaxIdleTimeMillis", "()I", "shouldSync", "", "getShouldSync", "()Z", "ui"})
    private static final class SyncLoopState {
        @NotNull
        public static final SyncLoopState INSTANCE = new SyncLoopState();
        private static final int maxIdleTimeMillis = 300000;
        private static long lastAccessTimeMillis;

        private SyncLoopState() {
        }

        public final int getMaxIdleTimeMillis() {
            return maxIdleTimeMillis;
        }

        public final long getLastAccessTimeMillis() {
            return lastAccessTimeMillis;
        }

        public final void setLastAccessTimeMillis(long l) {
            lastAccessTimeMillis = l;
        }

        public final boolean getShouldSync() {
            return System.currentTimeMillis() - lastAccessTimeMillis < (long)maxIdleTimeMillis;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToggleableState.values().length];
            try {
                nArray[ToggleableState.On.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToggleableState.Off.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToggleableState.Indeterminate.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

