/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.impl.AbstractConfigNode;
import com.typesafe.config.impl.AbstractConfigNodeValue;
import com.typesafe.config.impl.ConfigNodeField;
import com.typesafe.config.impl.ConfigNodeSingleToken;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokens;
import java.util.ArrayList;
import java.util.Collection;

abstract class ConfigNodeComplexValue
extends AbstractConfigNodeValue {
    protected final ArrayList<AbstractConfigNode> children;

    ConfigNodeComplexValue(Collection<AbstractConfigNode> children2) {
        this.children = new ArrayList<AbstractConfigNode>(children2);
    }

    public final Collection<AbstractConfigNode> children() {
        return this.children;
    }

    @Override
    protected Collection<Token> tokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (AbstractConfigNode child2 : this.children) {
            tokens.addAll(child2.tokens());
        }
        return tokens;
    }

    protected ConfigNodeComplexValue indentText(AbstractConfigNode indentation) {
        ArrayList<AbstractConfigNode> childrenCopy = new ArrayList<AbstractConfigNode>(this.children);
        for (int i2 = 0; i2 < childrenCopy.size(); ++i2) {
            AbstractConfigNode child2 = childrenCopy.get(i2);
            if (child2 instanceof ConfigNodeSingleToken && Tokens.isNewline(((ConfigNodeSingleToken)child2).token())) {
                childrenCopy.add(i2 + 1, indentation);
                ++i2;
                continue;
            }
            if (child2 instanceof ConfigNodeField) {
                AbstractConfigNodeValue value = ((ConfigNodeField)child2).value();
                if (!(value instanceof ConfigNodeComplexValue)) continue;
                childrenCopy.set(i2, ((ConfigNodeField)child2).replaceValue(((ConfigNodeComplexValue)value).indentText(indentation)));
                continue;
            }
            if (!(child2 instanceof ConfigNodeComplexValue)) continue;
            childrenCopy.set(i2, ((ConfigNodeComplexValue)child2).indentText(indentation));
        }
        return this.newNode(childrenCopy);
    }

    abstract ConfigNodeComplexValue newNode(Collection<AbstractConfigNode> var1);
}

