/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.sessions.SessionTransportTransformer;
import io.ktor.util.CryptoKt;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lio/ktor/server/sessions/SessionTransportTransformerMessageAuthentication;", "Lio/ktor/server/sessions/SessionTransportTransformer;", "key", "", "algorithm", "", "([BLjava/lang/String;)V", "keySpec", "Ljavax/crypto/spec/SecretKeySpec;", "(Ljavax/crypto/spec/SecretKeySpec;Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "getKeySpec", "()Ljavax/crypto/spec/SecretKeySpec;", "mac", "value", "transformRead", "transportValue", "transformWrite", "ktor-server-sessions"})
public final class SessionTransportTransformerMessageAuthentication
implements SessionTransportTransformer {
    @NotNull
    private final SecretKeySpec keySpec;
    @NotNull
    private final String algorithm;

    public SessionTransportTransformerMessageAuthentication(@NotNull SecretKeySpec keySpec, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter(keySpec, "keySpec");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        this.keySpec = keySpec;
        this.algorithm = algorithm;
    }

    public /* synthetic */ SessionTransportTransformerMessageAuthentication(SecretKeySpec secretKeySpec, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "HmacSHA256";
        }
        this(secretKeySpec, string);
    }

    @NotNull
    public final SecretKeySpec getKeySpec() {
        return this.keySpec;
    }

    @NotNull
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public SessionTransportTransformerMessageAuthentication(@NotNull byte[] key2, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        this(new SecretKeySpec(key2, algorithm), algorithm);
    }

    public /* synthetic */ SessionTransportTransformerMessageAuthentication(byte[] byArray, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "HmacSHA256";
        }
        this(byArray, string);
    }

    @Override
    @Nullable
    public String transformRead(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter(transportValue, "transportValue");
        String expectedSignature = StringsKt.substringAfterLast(transportValue, '/', "");
        String value = StringsKt.substringBeforeLast$default(transportValue, '/', null, 2, null);
        String string = this.mac(value);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        string = expectedSignature;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray2, "this as java.lang.String).getBytes(charset)");
        if (MessageDigest.isEqual(byArray, byArray2)) {
            return value;
        }
        return null;
    }

    @Override
    @NotNull
    public String transformWrite(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter(transportValue, "transportValue");
        return transportValue + '/' + this.mac(transportValue);
    }

    private final String mac(String value) {
        Mac mac = Mac.getInstance(this.algorithm);
        mac.init(this.keySpec);
        String string = value;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = mac.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue(byArray2, "doFinal(...)");
        return CryptoKt.hex(byArray2);
    }
}

