/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed.http;

import com.ustadmobile.ihttp.headers.IHttpHeaders;
import com.ustadmobile.ihttp.request.IHttpRequest;
import com.ustadmobile.ihttp.response.IHttpResponse;
import com.ustadmobile.ihttp.response.StringResponse;
import com.ustadmobile.libcache.UstadCache;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/libcache/distributed/http/DistributedCacheHttpEndpoint;", "", "cache", "Lcom/ustadmobile/libcache/UstadCache;", "(Lcom/ustadmobile/libcache/UstadCache;)V", "invoke", "Lcom/ustadmobile/ihttp/response/IHttpResponse;", "request", "Lcom/ustadmobile/ihttp/request/IHttpRequest;", "DCacheRequest", "lib-cache"})
public final class DistributedCacheHttpEndpoint {
    @NotNull
    private final UstadCache cache;

    public DistributedCacheHttpEndpoint(@NotNull UstadCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
    }

    @NotNull
    public final IHttpResponse invoke(@NotNull IHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.getMethod() != IHttpRequest.Companion.Method.GET) {
            return (IHttpResponse)new StringResponse(request, "text/plain", null, 405, "Method not allowed", 4, null);
        }
        IHttpResponse iHttpResponse = this.cache.retrieve(new DCacheRequest(request));
        if (iHttpResponse == null) {
            iHttpResponse = (IHttpResponse)new StringResponse(request, "text/plain", null, 404, "not found", 4, null);
        }
        return iHttpResponse;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/ustadmobile/libcache/distributed/http/DistributedCacheHttpEndpoint$DCacheRequest;", "Lcom/ustadmobile/ihttp/request/IHttpRequest;", "originalRequest", "(Lcom/ustadmobile/ihttp/request/IHttpRequest;)V", "headers", "Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "getHeaders", "()Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "method", "Lcom/ustadmobile/ihttp/request/IHttpRequest$Companion$Method;", "getMethod", "()Lcom/ustadmobile/ihttp/request/IHttpRequest$Companion$Method;", "getOriginalRequest", "()Lcom/ustadmobile/ihttp/request/IHttpRequest;", "queryParamMap", "", "", "getQueryParamMap", "()Ljava/util/Map;", "queryParamMap$delegate", "Lkotlin/Lazy;", "url", "getUrl", "()Ljava/lang/String;", "queryParam", "name", "lib-cache"})
    public static final class DCacheRequest
    implements IHttpRequest {
        @NotNull
        private final IHttpRequest originalRequest;
        @NotNull
        private final Lazy queryParamMap$delegate;

        public DCacheRequest(@NotNull IHttpRequest originalRequest) {
            Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
            this.originalRequest = originalRequest;
            this.queryParamMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends String>>(this){
                final /* synthetic */ DCacheRequest this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Map<String, String> invoke() {
                    void $this$mapTo$iv$iv;
                    String[] stringArray = new String[]{"&"};
                    Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.substringAfter((String)this.this$0.getUrl(), (String)"?", (String)""), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        String string;
                        void it;
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String[] stringArray2 = new String[]{"="};
                        List split = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray2, (boolean)false, (int)2, (int)2, null);
                        String paramName = URLDecoder.decode((String)CollectionsKt.first((List)split), "UTF-8");
                        if ((String)CollectionsKt.getOrNull((List)split, (int)1) != null) {
                            String it2;
                            boolean bl2 = false;
                            string = URLDecoder.decode(it2, "UTF-8");
                        } else {
                            string = null;
                        }
                        String string3 = string;
                        String paramVal = string3 == null ? "" : string3;
                        collection.add(new Pair((Object)paramName, (Object)paramVal));
                    }
                    return MapsKt.toMap((Iterable)((List)destination$iv$iv));
                }
            }));
        }

        @NotNull
        public final IHttpRequest getOriginalRequest() {
            return this.originalRequest;
        }

        @NotNull
        public IHttpHeaders getHeaders() {
            return this.originalRequest.getHeaders();
        }

        @NotNull
        public String getUrl() {
            String string = this.originalRequest.queryParam("url");
            if (string == null) {
                throw new IllegalArgumentException("DCache request has no url parameter");
            }
            return string;
        }

        @NotNull
        public IHttpRequest.Companion.Method getMethod() {
            return this.originalRequest.getMethod();
        }

        private final Map<String, String> getQueryParamMap() {
            Lazy lazy = this.queryParamMap$delegate;
            return (Map)lazy.getValue();
        }

        @Nullable
        public String queryParam(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getQueryParamMap().get(name);
        }
    }
}

