/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed.model;

import com.ustadmobile.libcache.distributed.model.DistributedCachePacket;
import com.ustadmobile.libcache.distributed.model.DistributedHashCacheEntry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedHashEntries;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket;", "version", "", "httpPort", "", "entries", "", "Lcom/ustadmobile/libcache/distributed/model/DistributedHashCacheEntry;", "(BILjava/util/List;)V", "getEntries", "()Ljava/util/List;", "getHttpPort", "()I", "size", "getSize", "getVersion", "()B", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toBytes", "", "toString", "", "Companion", "lib-cache"})
@SourceDebugExtension(value={"SMAP\nDistributedHashEntries.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributedHashEntries.kt\ncom/ustadmobile/libcache/distributed/model/DistributedHashEntries\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1855#2,2:54\n*S KotlinDebug\n*F\n+ 1 DistributedHashEntries.kt\ncom/ustadmobile/libcache/distributed/model/DistributedHashEntries\n*L\n29#1:54,2\n*E\n"})
public final class DistributedHashEntries
extends DistributedCachePacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final byte version;
    private final int httpPort;
    @NotNull
    private final List<DistributedHashCacheEntry> entries;
    public static final int OVERHEAD_SIZE = 10;

    public DistributedHashEntries(byte version, int httpPort, @NotNull List<DistributedHashCacheEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        super(null);
        this.version = version;
        this.httpPort = httpPort;
        this.entries = entries;
    }

    public /* synthetic */ DistributedHashEntries(byte by, int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            by = 1;
        }
        this(by, n, list);
    }

    public final byte getVersion() {
        return this.version;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @NotNull
    public final List<DistributedHashCacheEntry> getEntries() {
        return this.entries;
    }

    public final int getSize() {
        return 10 + this.entries.size() * 24;
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize());
        buffer.put((byte)1);
        buffer.putInt(this.getHttpPort());
        buffer.put(this.version);
        buffer.putInt(this.entries.size());
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DistributedHashCacheEntry it = (DistributedHashCacheEntry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)buffer);
            it.writeBytes(buffer);
        }
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    public final byte component1() {
        return this.version;
    }

    public final int component2() {
        return this.httpPort;
    }

    @NotNull
    public final List<DistributedHashCacheEntry> component3() {
        return this.entries;
    }

    @NotNull
    public final DistributedHashEntries copy(byte version, int httpPort, @NotNull List<DistributedHashCacheEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        return new DistributedHashEntries(version, httpPort, entries);
    }

    public static /* synthetic */ DistributedHashEntries copy$default(DistributedHashEntries distributedHashEntries, byte by, int n, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            by = distributedHashEntries.version;
        }
        if ((n2 & 2) != 0) {
            n = distributedHashEntries.httpPort;
        }
        if ((n2 & 4) != 0) {
            list = distributedHashEntries.entries;
        }
        return distributedHashEntries.copy(by, n, list);
    }

    @NotNull
    public String toString() {
        return "DistributedHashEntries(version=" + this.version + ", httpPort=" + this.httpPort + ", entries=" + this.entries + ")";
    }

    public int hashCode() {
        int result = Byte.hashCode(this.version);
        result = result * 31 + Integer.hashCode(this.httpPort);
        result = result * 31 + ((Object)this.entries).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DistributedHashEntries)) {
            return false;
        }
        DistributedHashEntries distributedHashEntries = (DistributedHashEntries)other;
        if (this.version != distributedHashEntries.version) {
            return false;
        }
        if (this.httpPort != distributedHashEntries.httpPort) {
            return false;
        }
        return Intrinsics.areEqual(this.entries, distributedHashEntries.entries);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0012\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedHashEntries$Companion;", "", "()V", "OVERHEAD_SIZE", "", "numEntriesFor", "mtu", "readDistributedHashEntries", "Lcom/ustadmobile/libcache/distributed/model/DistributedHashEntries;", "Ljava/nio/ByteBuffer;", "httpPort", "lib-cache"})
    public static final class Companion {
        private Companion() {
        }

        public final int numEntriesFor(int mtu) {
            return (mtu - 10) / 24;
        }

        @NotNull
        public final DistributedHashEntries readDistributedHashEntries(@NotNull ByteBuffer $this$readDistributedHashEntries, int httpPort) {
            Intrinsics.checkNotNullParameter((Object)$this$readDistributedHashEntries, (String)"<this>");
            byte version = $this$readDistributedHashEntries.get();
            int numEntries = $this$readDistributedHashEntries.getInt();
            List entriesList = new ArrayList();
            for (int i = 0; i < numEntries; ++i) {
                entriesList.add(DistributedHashCacheEntry.Companion.readBytes($this$readDistributedHashEntries));
            }
            return new DistributedHashEntries(version, httpPort, entriesList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

