/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.okhttp;

import com.ustadmobile.door.util.SystemTimeKt;
import com.ustadmobile.ihttp.headers.IHeadersBuilder;
import com.ustadmobile.ihttp.headers.IHeadersBuilderKt;
import com.ustadmobile.ihttp.headers.IHttpHeaders;
import com.ustadmobile.ihttp.okhttp.headers.OkHttpHeadersAdapterKt;
import com.ustadmobile.ihttp.okhttp.request.OkHttpRequestAdapterKt;
import com.ustadmobile.ihttp.okhttp.response.IHttpResponseOkHttpAdapterKt;
import com.ustadmobile.ihttp.request.IHttpRequest;
import com.ustadmobile.ihttp.response.IHttpResponse;
import com.ustadmobile.libcache.CacheEntryToStore;
import com.ustadmobile.libcache.CompressionType;
import com.ustadmobile.libcache.UstadCache;
import com.ustadmobile.libcache.ValidatedEntry;
import com.ustadmobile.libcache.cachecontrol.CacheControlFreshnessChecker;
import com.ustadmobile.libcache.cachecontrol.CacheControlFreshnessCheckerImpl;
import com.ustadmobile.libcache.cachecontrol.RequestCacheControlHeader;
import com.ustadmobile.libcache.cachecontrol.ResponseCacheabilityChecker;
import com.ustadmobile.libcache.cachecontrol.ResponseCacheabilityCheckerImpl;
import com.ustadmobile.libcache.integrity.Sha256IntegrityKt;
import com.ustadmobile.libcache.logging.UstadCacheLogger;
import com.ustadmobile.libcache.okhttp.RequestExtKt;
import com.ustadmobile.libcache.okhttp.ResponseCacheabilityCheckerExtKt;
import com.ustadmobile.libcache.okhttp.UstadCacheInterceptor$PartialFileMetadata$;
import com.ustadmobile.libcache.response.HttpPathResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002#$BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u0016*\u00020\u0018H\u0002J\f\u0010 \u001a\u00020!*\u00020!H\u0002J\f\u0010 \u001a\u00020\"*\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ustadmobile/libcache/okhttp/UstadCacheInterceptor;", "Lokhttp3/Interceptor;", "cache", "Lcom/ustadmobile/libcache/UstadCache;", "tmpDirProvider", "Lkotlin/Function0;", "Ljava/io/File;", "logger", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "cacheControlFreshnessChecker", "Lcom/ustadmobile/libcache/cachecontrol/CacheControlFreshnessChecker;", "responseCacheabilityChecker", "Lcom/ustadmobile/libcache/cachecontrol/ResponseCacheabilityChecker;", "fileSystem", "Lkotlinx/io/files/FileSystem;", "json", "Lkotlinx/serialization/json/Json;", "(Lcom/ustadmobile/libcache/UstadCache;Lkotlin/jvm/functions/Function0;Lcom/ustadmobile/libcache/logging/UstadCacheLogger;Lcom/ustadmobile/libcache/cachecontrol/CacheControlFreshnessChecker;Lcom/ustadmobile/libcache/cachecontrol/ResponseCacheabilityChecker;Lkotlinx/io/files/FileSystem;Lkotlinx/serialization/json/Json;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "logPrefix", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "newCacheAndStoreResponse", "response", "call", "Lokhttp3/Call;", "logSummary", "removeXInterceptHeaders", "Lokhttp3/Request;", "Lokhttp3/Request$Builder;", "PartialFileMetadata", "ReadAndCacheRunnable", "lib-cache"})
public final class UstadCacheInterceptor
implements Interceptor {
    @NotNull
    private final UstadCache cache;
    @NotNull
    private final Function0<File> tmpDirProvider;
    @Nullable
    private final UstadCacheLogger logger;
    @NotNull
    private final CacheControlFreshnessChecker cacheControlFreshnessChecker;
    @NotNull
    private final ResponseCacheabilityChecker responseCacheabilityChecker;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Json json;
    private final ExecutorService executor;
    @NotNull
    private final String logPrefix;

    public UstadCacheInterceptor(@NotNull UstadCache cache, @NotNull Function0<? extends File> tmpDirProvider, @Nullable UstadCacheLogger logger, @NotNull CacheControlFreshnessChecker cacheControlFreshnessChecker, @NotNull ResponseCacheabilityChecker responseCacheabilityChecker, @NotNull FileSystem fileSystem, @NotNull Json json) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter(tmpDirProvider, (String)"tmpDirProvider");
        Intrinsics.checkNotNullParameter((Object)cacheControlFreshnessChecker, (String)"cacheControlFreshnessChecker");
        Intrinsics.checkNotNullParameter((Object)responseCacheabilityChecker, (String)"responseCacheabilityChecker");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.cache = cache;
        this.tmpDirProvider = tmpDirProvider;
        this.logger = logger;
        this.cacheControlFreshnessChecker = cacheControlFreshnessChecker;
        this.responseCacheabilityChecker = responseCacheabilityChecker;
        this.fileSystem = fileSystem;
        this.json = json;
        this.executor = Executors.newCachedThreadPool();
        this.logPrefix = "OKHttp-CacheInterceptor: ";
    }

    public /* synthetic */ UstadCacheInterceptor(UstadCache ustadCache, Function0 function0, UstadCacheLogger ustadCacheLogger, CacheControlFreshnessChecker cacheControlFreshnessChecker, ResponseCacheabilityChecker responseCacheabilityChecker, FileSystem fileSystem, Json json, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ustadCacheLogger = null;
        }
        if ((n & 8) != 0) {
            cacheControlFreshnessChecker = new CacheControlFreshnessCheckerImpl();
        }
        if ((n & 0x10) != 0) {
            responseCacheabilityChecker = new ResponseCacheabilityCheckerImpl();
        }
        if ((n & 0x20) != 0) {
            fileSystem = FileSystemJvmKt.SystemFileSystem;
        }
        this(ustadCache, (Function0<? extends File>)function0, ustadCacheLogger, cacheControlFreshnessChecker, responseCacheabilityChecker, fileSystem, json);
    }

    private final String logSummary(Response $this$logSummary) {
        return $this$logSummary.code() + " " + $this$logSummary.message() + " (contentType=" + $this$logSummary.headers().get("content-type") + ", content-encoding=" + $this$logSummary.headers().get("content-encoding") + " content-length=" + Util.headersContentLength((Response)$this$logSummary) + ")";
    }

    private final Response newCacheAndStoreResponse(Response response, Call call) {
        UstadCacheLogger ustadCacheLogger = this.logger;
        if (ustadCacheLogger != null) {
            UstadCacheLogger.DefaultImpls.d$default(ustadCacheLogger, "UstadCache", this.logPrefix + " newCacheAndStoreResponse: " + response.request().method() + " " + response.request().url() + " " + response.code() + " (" + response.message() + ")", null, 4, null);
        }
        PipedInputStream pipeInStream = new PipedInputStream();
        PipedOutputStream pipeOutStream = new PipedOutputStream(pipeInStream);
        Response.Builder builder = response.newBuilder();
        BufferedSource bufferedSource = Okio.buffer((Source)Okio.source((InputStream)pipeInStream));
        String string = Response.header$default((Response)response, (String)"content-type", null, (int)2, null);
        if (string == null) {
            string = "application/octet-stream";
        }
        Response returnResponse = builder.body(ResponseBody.Companion.create(bufferedSource, MediaType.Companion.get(string), Util.headersContentLength((Response)response))).build();
        this.executor.submit(new ReadAndCacheRunnable(call, response, pipeOutStream));
        return returnResponse;
    }

    private final Request removeXInterceptHeaders(Request $this$removeXInterceptHeaders) {
        return $this$removeXInterceptHeaders.header("X-Interceptor-Partial-File") != null ? $this$removeXInterceptHeaders : this.removeXInterceptHeaders($this$removeXInterceptHeaders.newBuilder()).build();
    }

    private final Request.Builder removeXInterceptHeaders(Request.Builder $this$removeXInterceptHeaders) {
        return $this$removeXInterceptHeaders.removeHeader("X-Interceptor-Partial-File");
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        block29: {
            block31: {
                block30: {
                    block27: {
                        block28: {
                            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                            request = chain.request();
                            url = request.url().toString();
                            call = chain.call();
                            v0 = this.logger;
                            if (v0 != null) {
                                UstadCacheLogger.DefaultImpls.v$default(v0, "UstadCache", this.logPrefix + " intercept: " + request.method() + " " + url, null, 4, null);
                            }
                            requestHeaders = OkHttpHeadersAdapterKt.asIHttpHeaders((Headers)request.headers());
                            v1 = requestHeaders.get("cache-control");
                            if (v1 != null) {
                                it = v1;
                                $i$a$-let-UstadCacheInterceptor$intercept$requestCacheControlHeader$1 = false;
                                v2 = RequestCacheControlHeader.Companion.parse(it);
                            } else {
                                v2 = requestCacheControlHeader = null;
                            }
                            if (!RequestExtKt.mightBeCacheable(request, requestCacheControlHeader)) {
                                return chain.proceed(this.removeXInterceptHeaders(request));
                            }
                            v3 = request.headers().get("X-Interceptor-Partial-File");
                            if (v3 != null) {
                                it = v3;
                                $i$a$-let-UstadCacheInterceptor$intercept$partialFile$1 = false;
                                v4 = new File(it);
                            } else {
                                v4 = null;
                            }
                            partialFile = v4;
                            cacheRequest = OkHttpRequestAdapterKt.asIHttpRequest((Request)request);
                            v5 = cacheResponse = this.cache.retrieve(cacheRequest);
                            if (v5 != null) {
                                it = v5;
                                $i$a$-let-UstadCacheInterceptor$intercept$cachedResponseStatus$1 = false;
                                v6 = cacheResponse.getHeaders().get("UCache-First-Stored");
                                v7 = cacheResponse.getHeaders().get("UCache-Last-Validated");
                                v8 = CacheControlFreshnessChecker.DefaultImpls.invoke$default(this.cacheControlFreshnessChecker, (IHttpHeaders)OkHttpHeadersAdapterKt.asIHttpHeaders((Headers)request.headers()), requestCacheControlHeader, cacheResponse.getHeaders(), null, v6 != null ? Long.parseLong(v6) : SystemTimeKt.systemTimeInMillis(), v7 != null ? Long.parseLong(v7) : SystemTimeKt.systemTimeInMillis(), 8, null);
                            } else {
                                v8 = null;
                            }
                            cachedResponseStatus = v8;
                            if (cacheResponse == null) break block27;
                            v9 = cachedResponseStatus;
                            if (v9 != null ? v9.isFresh() : false) break block28;
                            v10 = requestCacheControlHeader;
                            v11 = v10 != null ? v10.getOnlyIfCached() : false;
                            if (!v11) break block27;
                        }
                        $i$a$-let-UstadCacheInterceptor$intercept$partialFile$1 = IHttpResponseOkHttpAdapterKt.asOkHttpResponse((IHttpResponse)cacheResponse);
                        it = $i$a$-let-UstadCacheInterceptor$intercept$partialFile$1;
                        $i$a$-also-UstadCacheInterceptor$intercept$1 = false;
                        v12 = this.logger;
                        if (v12 != null) {
                            UstadCacheLogger.DefaultImpls.d$default(v12, "UstadCache", this.logPrefix + " HIT(valid) " + url + " " + this.logSummary((Response)it), null, 4, null);
                        }
                        v13 = $i$a$-let-UstadCacheInterceptor$intercept$partialFile$1;
                        break block29;
                    }
                    v14 = requestCacheControlHeader;
                    v15 = v14 != null ? v14.getOnlyIfCached() : false;
                    if (!v15) break block30;
                    v13 = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).message("Gateway Timeout").code(504).body(ResponseBody.Companion.create$default((ResponseBody.Companion)ResponseBody.Companion, (String)"Gateway Timeout: only-if-cached if true, but not available in cache", null, (int)1, null)).build();
                    break block29;
                }
                if (cachedResponseStatus == null || !cachedResponseStatus.getCanBeValidated()) break block31;
                validateRequestBuilder = this.removeXInterceptHeaders(request.newBuilder());
                v16 = cachedResponseStatus.getIfNoneMatch();
                if (v16 != null) {
                    it = $i$a$-also-UstadCacheInterceptor$intercept$1 = v16;
                    $i$a$-also-UstadCacheInterceptor$intercept$2 = false;
                    validateRequestBuilder.addHeader("if-none-match", it);
                }
                v17 = cachedResponseStatus.getIfNotModifiedSince();
                if (v17 != null) {
                    it = $i$a$-also-UstadCacheInterceptor$intercept$1 = v17;
                    $i$a$-also-UstadCacheInterceptor$intercept$3 = false;
                    validateRequestBuilder.addHeader("if-modified-since", it);
                }
                validationResponse = chain.proceed(validateRequestBuilder.build());
                if (validationResponse.code() == 304) {
                    validationResponse.close();
                    this.cache.updateLastValidated(new ValidatedEntry(url, (IHttpHeaders)OkHttpHeadersAdapterKt.asIHttpHeaders((Headers)validationResponse.headers())));
                    $i$a$-also-UstadCacheInterceptor$intercept$1 = IHttpResponseOkHttpAdapterKt.asOkHttpResponse((IHttpResponse)cacheResponse);
                    it = $i$a$-also-UstadCacheInterceptor$intercept$1;
                    $i$a$-also-UstadCacheInterceptor$intercept$4 = false;
                    v18 = this.logger;
                    if (v18 != null) {
                        UstadCacheLogger.DefaultImpls.d$default(v18, "UstadCache", this.logPrefix + " HIT(validated) " + url + " " + this.logSummary((Response)it), null, 4, null);
                    }
                    v13 = $i$a$-also-UstadCacheInterceptor$intercept$1;
                } else {
                    v19 = this.logger;
                    if (v19 != null) {
                        UstadCacheLogger.DefaultImpls.d$default(v19, "UstadCache", this.logPrefix + " MISS(invalid) " + url, null, 4, null);
                    }
                    if (ResponseCacheabilityCheckerExtKt.canStore$default(this.responseCacheabilityChecker, validationResponse, false, 2, null)) {
                        $i$a$-also-UstadCacheInterceptor$intercept$1 = this.newCacheAndStoreResponse(validationResponse, call);
                        it = $i$a$-also-UstadCacheInterceptor$intercept$1;
                        $i$a$-also-UstadCacheInterceptor$intercept$5 = false;
                        v20 = this.logger;
                        if (v20 != null) {
                            UstadCacheLogger.DefaultImpls.v$default(v20, "UstadCache", this.logPrefix + " " + url + " MISS(invalid) can store/update " + this.logSummary((Response)it), null, 4, null);
                        }
                        v13 = $i$a$-also-UstadCacheInterceptor$intercept$1;
                    } else {
                        $i$a$-also-UstadCacheInterceptor$intercept$1 = validationResponse;
                        it = $i$a$-also-UstadCacheInterceptor$intercept$1;
                        $i$a$-also-UstadCacheInterceptor$intercept$6 = false;
                        v21 = this.logger;
                        if (v21 != null) {
                            UstadCacheLogger.DefaultImpls.v$default(v21, "UstadCache", this.logPrefix + " " + url + " cannot store - returning response as-is " + this.logSummary((Response)it), null, 4, null);
                        }
                        v13 = $i$a$-also-UstadCacheInterceptor$intercept$1;
                    }
                }
                break block29;
            }
            v22 = partialFile;
            if (v22 != null) {
                it = v22;
                $i$a$-let-UstadCacheInterceptor$intercept$partialFileMetaDataFile$1 = false;
                v23 = new File(it.getParentFile(), it.getName() + ".json");
            } else {
                v23 = partialFileMetaDataFile = null;
            }
            if (partialFileMetaDataFile == null) ** GOTO lbl-1000
            it = $i$a$-let-UstadCacheInterceptor$intercept$partialFileMetaDataFile$1 = partialFileMetaDataFile;
            $i$a$-takeIf-UstadCacheInterceptor$intercept$partialFileMetadata$1 = false;
            v24 = it = (it.exists() != false && partialFile.exists() != false) != false ? $i$a$-let-UstadCacheInterceptor$intercept$partialFileMetaDataFile$1 : null;
            if (it != null) {
                it = it;
                $i$a$-let-UstadCacheInterceptor$intercept$partialFileMetadata$2 = false;
                v25 = (PartialFileMetadata)this.json.decodeFromString((DeserializationStrategy)PartialFileMetadata.Companion.serializer(), FilesKt.readText$default((File)it, null, (int)1, null));
            } else lbl-1000:
            // 2 sources

            {
                v25 = null;
            }
            v26 = partialFileMetadata = v25;
            partialEtag = v26 != null ? v26.getEtag() : null;
            networkRequest = partialEtag != null ? this.removeXInterceptHeaders(request.newBuilder()).addHeader("If-Range", partialEtag).addHeader("Range", "bytes=" + partialFile.length() + "-").build() : this.removeXInterceptHeaders(request);
            response = chain.proceed(networkRequest);
            if (ResponseCacheabilityCheckerExtKt.canStore(this.responseCacheabilityChecker, response, partialEtag != null)) {
                it = var16_34 = this.newCacheAndStoreResponse(response, call);
                $i$a$-also-UstadCacheInterceptor$intercept$7 = false;
                v27 = this.logger;
                if (v27 != null) {
                    UstadCacheLogger.DefaultImpls.d$default(v27, "UstadCache", this.logPrefix + " MISS " + url + " " + this.logSummary(it), null, 4, null);
                }
                v13 = var16_34;
            } else {
                it = var16_35 = response;
                $i$a$-also-UstadCacheInterceptor$intercept$8 = false;
                v28 = this.logger;
                if (v28 != null) {
                    UstadCacheLogger.DefaultImpls.d$default(v28, "UstadCache", this.logPrefix + " NOSTORE " + url + " " + this.logSummary(it), null, 4, null);
                }
                v13 = var16_35;
            }
        }
        return v13;
    }

    @Serializable
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB-\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u00c1\u0001\u00a2\u0006\u0002\b\u001dR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006 "}, d2={"Lcom/ustadmobile/libcache/okhttp/UstadCacheInterceptor$PartialFileMetadata;", "", "seen1", "", "etag", "", "lastModified", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getEtag", "()Ljava/lang/String;", "getLastModified", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$lib_cache", "$serializer", "Companion", "lib-cache"})
    public static final class PartialFileMetadata {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String etag;
        @Nullable
        private final String lastModified;

        public PartialFileMetadata(@Nullable String etag, @Nullable String lastModified) {
            this.etag = etag;
            this.lastModified = lastModified;
        }

        @Nullable
        public final String getEtag() {
            return this.etag;
        }

        @Nullable
        public final String getLastModified() {
            return this.lastModified;
        }

        @Nullable
        public final String component1() {
            return this.etag;
        }

        @Nullable
        public final String component2() {
            return this.lastModified;
        }

        @NotNull
        public final PartialFileMetadata copy(@Nullable String etag, @Nullable String lastModified) {
            return new PartialFileMetadata(etag, lastModified);
        }

        public static /* synthetic */ PartialFileMetadata copy$default(PartialFileMetadata partialFileMetadata, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = partialFileMetadata.etag;
            }
            if ((n & 2) != 0) {
                string2 = partialFileMetadata.lastModified;
            }
            return partialFileMetadata.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "PartialFileMetadata(etag=" + this.etag + ", lastModified=" + this.lastModified + ")";
        }

        public int hashCode() {
            int result = this.etag == null ? 0 : this.etag.hashCode();
            result = result * 31 + (this.lastModified == null ? 0 : this.lastModified.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PartialFileMetadata)) {
                return false;
            }
            PartialFileMetadata partialFileMetadata = (PartialFileMetadata)other;
            if (!Intrinsics.areEqual((Object)this.etag, (Object)partialFileMetadata.etag)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lastModified, (Object)partialFileMetadata.lastModified);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$lib_cache(PartialFileMetadata self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.etag);
            output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.lastModified);
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ PartialFileMetadata(int seen1, String etag, String lastModified, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)3, (SerialDescriptor)PartialFileMetadata$$serializer.INSTANCE.getDescriptor());
            }
            this.etag = etag;
            this.lastModified = lastModified;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/ustadmobile/libcache/okhttp/UstadCacheInterceptor$PartialFileMetadata$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/ustadmobile/libcache/okhttp/UstadCacheInterceptor$PartialFileMetadata;", "lib-cache"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<PartialFileMetadata> serializer() {
                return (KSerializer)PartialFileMetadata$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/libcache/okhttp/UstadCacheInterceptor$ReadAndCacheRunnable;", "Ljava/lang/Runnable;", "call", "Lokhttp3/Call;", "response", "Lokhttp3/Response;", "pipeOut", "Ljava/io/PipedOutputStream;", "(Lcom/ustadmobile/libcache/okhttp/UstadCacheInterceptor;Lokhttp3/Call;Lokhttp3/Response;Ljava/io/PipedOutputStream;)V", "run", "", "lib-cache"})
    @SourceDebugExtension(value={"SMAP\nUstadCacheInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UstadCacheInterceptor.kt\ncom/ustadmobile/libcache/okhttp/UstadCacheInterceptor$ReadAndCacheRunnable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n1#2:400\n*E\n"})
    public final class ReadAndCacheRunnable
    implements Runnable {
        @NotNull
        private final Call call;
        @NotNull
        private final Response response;
        @NotNull
        private final PipedOutputStream pipeOut;

        public ReadAndCacheRunnable(@NotNull Call call, @NotNull Response response, PipedOutputStream pipeOut) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)pipeOut, (String)"pipeOut");
            this.call = call;
            this.response = response;
            this.pipeOut = pipeOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File file;
            File file2;
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String partialFile = this.call.request().headers().get("X-Interceptor-Partial-File");
            File tmpDir = (File)UstadCacheInterceptor.this.tmpDirProvider.invoke();
            String string = partialFile;
            if (string != null) {
                String it = string;
                boolean bl = false;
                file2 = new File(it);
            } else {
                file2 = new File(tmpDir, UUID.randomUUID().toString());
            }
            File responseBodyFile = file2;
            File partialFileMetadataFile = partialFile != null ? new File(responseBodyFile.getParentFile(), responseBodyFile.getName() + ".json") : null;
            try {
                Object object;
                CompressionType responseCompression = CompressionType.Companion.byHeaderVal(Response.header$default((Response)this.response, (String)"content-encoding", null, (int)2, null));
                File file3 = partialFileMetadataFile;
                if (file3 != null) {
                    FilesKt.writeText$default((File)file3, (String)UstadCacheInterceptor.this.json.encodeToString((SerializationStrategy)PartialFileMetadata.Companion.serializer(), (Object)new PartialFileMetadata(Response.header$default((Response)this.response, (String)"etag", null, (int)2, null), Response.header$default((Response)this.response, (String)"last-modified", null, (int)2, null))), null, (int)2, null);
                }
                Object bl = this.response.body();
                if (bl == null || (object = bl.byteStream()) == null) {
                    throw new IllegalStateException();
                }
                InputStream it = object;
                boolean bl22 = false;
                DigestInputStream responseInStream = new DigestInputStream(it, digest);
                bl = responseInStream;
                object = UstadCacheInterceptor.this;
                Throwable throwable = null;
                try {
                    DigestInputStream responseIn = (DigestInputStream)bl;
                    boolean bl3 = false;
                    File bl22 = responseBodyFile.getParentFile();
                    File file4 = bl22;
                    if (file4 != null) {
                        File file5;
                        Intrinsics.checkNotNull((Object)file4);
                        File it2 = file5 = bl22;
                        boolean bl4 = false;
                        file4 = !it2.exists() ? file5 : null;
                        if (file4 != null) {
                            file4.mkdirs();
                        }
                    }
                    FileOutputStream fileOutStream = new FileOutputStream(responseBodyFile, this.response.code() == 206);
                    while (!this.call.isCanceled()) {
                        int n;
                        int it3 = n = responseIn.read(buffer);
                        boolean bl5 = false;
                        bytesRead = it3;
                        if (n == -1) break;
                        fileOutStream.write(buffer, 0, bytesRead);
                        this.pipeOut.write(buffer, 0, bytesRead);
                    }
                    fileOutStream.flush();
                    fileOutStream.close();
                    IHttpRequest cacheRequest = OkHttpRequestAdapterKt.asIHttpRequest((Request)this.call.request());
                    if (!this.call.isCanceled()) {
                        UstadCache ustadCache = ((UstadCacheInterceptor)object).cache;
                        String string2 = responseBodyFile.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                        Path path = PathsJvmKt.Path((String)string2);
                        FileSystem fileSystem = ((UstadCacheInterceptor)object).fileSystem;
                        String string3 = Response.header$default((Response)this.response, (String)"content-type", null, (int)2, null);
                        if (string3 == null) {
                            string3 = "application/octet-stream";
                        }
                        IHttpResponse iHttpResponse = new HttpPathResponse(path, fileSystem, string3, cacheRequest, null, IHeadersBuilderKt.iHeadersBuilder((Function1)((Function1)new Function1<IHeadersBuilder, Unit>(this, responseCompression, digest){
                            final /* synthetic */ ReadAndCacheRunnable this$0;
                            final /* synthetic */ CompressionType $responseCompression;
                            final /* synthetic */ MessageDigest $digest;
                            {
                                this.this$0 = $receiver;
                                this.$responseCompression = $responseCompression;
                                this.$digest = $digest;
                                super(1);
                            }

                            public final void invoke(@NotNull IHeadersBuilder $this$iHeadersBuilder) {
                                Intrinsics.checkNotNullParameter((Object)$this$iHeadersBuilder, (String)"$this$iHeadersBuilder");
                                $this$iHeadersBuilder.takeFrom((IHttpHeaders)OkHttpHeadersAdapterKt.asIHttpHeaders((Headers)ReadAndCacheRunnable.access$getResponse$p(this.this$0).headers().newBuilder().removeAll("range").build()));
                                Object object = Response.header$default((Response)ReadAndCacheRunnable.access$getResponse$p(this.this$0), (String)"X-Etag-Is-Integrity", null, (int)2, null);
                                boolean etagIsIntegrity = object != null && (object = StringsKt.toBooleanStrictOrNull((String)object)) != null ? (Boolean)object : false;
                                if (this.$responseCompression == CompressionType.NONE && etagIsIntegrity) {
                                    byte[] byArray = this.$digest.digest();
                                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                                    $this$iHeadersBuilder.header("etag", Sha256IntegrityKt.sha256Integrity(byArray));
                                } else if (etagIsIntegrity) {
                                    $this$iHeadersBuilder.removeHeader("etag");
                                    $this$iHeadersBuilder.removeHeader("X-Etag-Is-Integrity");
                                } else if (this.$responseCompression == CompressionType.NONE) {
                                    byte[] byArray = this.$digest.digest();
                                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                                    $this$iHeadersBuilder.header("X-Integrity", Sha256IntegrityKt.sha256Integrity(byArray));
                                } else {
                                    $this$iHeadersBuilder.removeHeader("X-Integrity");
                                }
                            }
                        })), 16, null);
                        String string4 = responseBodyFile.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
                        UstadCache.DefaultImpls.store$default(ustadCache, CollectionsKt.listOf((Object)new CacheEntryToStore(cacheRequest, iHttpResponse, PathsJvmKt.Path((String)string4), true, false, 16, null)), null, 2, null);
                        File file6 = partialFileMetadataFile;
                        if (file6 != null) {
                            File file7;
                            File it4 = file7 = file6;
                            boolean bl6 = false;
                            file6 = it4.exists() ? file7 : null;
                            if (file6 != null) {
                                file6.delete();
                            }
                        }
                    }
                    this.pipeOut.flush();
                    this.pipeOut.close();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)bl, (Throwable)throwable);
                }
            }
            catch (Throwable e) {
                try {
                    UstadCacheLogger ustadCacheLogger = UstadCacheInterceptor.this.logger;
                    if (ustadCacheLogger != null) {
                        ustadCacheLogger.e("UstadCache", UstadCacheInterceptor.this.logPrefix + " ReadAndCacheRunnable: exception handling " + this.call.request().method() + " " + this.call.request().url(), e);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    File file8;
                    this.response.close();
                    File it = file8 = responseBodyFile;
                    boolean bl = false;
                    File file9 = it.exists() ? file8 : null;
                    if (file9 != null) {
                        file9.delete();
                    }
                    throw throwable;
                }
            }
            this.response.close();
            File it = file = responseBodyFile;
            boolean bl = false;
            File file10 = it.exists() ? file : null;
            if (file10 != null) {
                file10.delete();
            }
        }

        public static final /* synthetic */ Response access$getResponse$p(ReadAndCacheRunnable $this) {
            return $this.response;
        }
    }
}

