/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.ihttp.okhttp.request;

import com.ustadmobile.ihttp.headers.IHttpHeaders;
import com.ustadmobile.ihttp.okhttp.headers.OkHttpHeadersAdapterKt;
import com.ustadmobile.ihttp.request.IHttpRequest;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/ustadmobile/ihttp/okhttp/request/OkHttpRequestAdapter;", "Lcom/ustadmobile/ihttp/request/IHttpRequest;", "request", "Lokhttp3/Request;", "(Lokhttp3/Request;)V", "headers", "Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "getHeaders", "()Lcom/ustadmobile/ihttp/headers/IHttpHeaders;", "method", "Lcom/ustadmobile/ihttp/request/IHttpRequest$Companion$Method;", "getMethod", "()Lcom/ustadmobile/ihttp/request/IHttpRequest$Companion$Method;", "getRequest$lib_ihttp_okhttp", "()Lokhttp3/Request;", "url", "", "getUrl", "()Ljava/lang/String;", "queryParam", "name", "lib-ihttp-okhttp"})
public final class OkHttpRequestAdapter
implements IHttpRequest {
    @NotNull
    private final Request request;
    @NotNull
    private final IHttpHeaders headers;
    @NotNull
    private final String url;
    @NotNull
    private final IHttpRequest.Companion.Method method;

    public OkHttpRequestAdapter(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.headers = OkHttpHeadersAdapterKt.asIHttpHeaders(this.request.headers());
        this.url = this.request.url().toString();
        this.method = IHttpRequest.Companion.Method.Companion.forName(this.request.method());
    }

    @NotNull
    public final Request getRequest$lib_ihttp_okhttp() {
        return this.request;
    }

    @NotNull
    public IHttpHeaders getHeaders() {
        return this.headers;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public IHttpRequest.Companion.Method getMethod() {
        return this.method;
    }

    @Nullable
    public String queryParam(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (String)CollectionsKt.firstOrNull((List)this.request.url().queryParameterValues(name));
    }
}

