/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.embeddedhttp;

import com.ustadmobile.core.account.LearningSpace;
import com.ustadmobile.core.domain.contententry.server.ContentEntryVersionServerUseCase;
import com.ustadmobile.core.domain.interop.HttpApiException;
import com.ustadmobile.core.domain.xapi.http.XapiHttpServerUseCase;
import com.ustadmobile.core.embeddedhttp.ResponseExtKt;
import com.ustadmobile.ihttp.nanohttpd.NanoHttpdRequestAdapterKt;
import com.ustadmobile.ihttp.nanohttpd.NanoHttpdResponseAdapterKt;
import com.ustadmobile.ihttp.request.IHttpRequest;
import com.ustadmobile.ihttp.request.RequestBuilder;
import com.ustadmobile.ihttp.request.RequestBuilderKt;
import com.ustadmobile.ihttp.response.IHttpResponse;
import com.ustadmobile.libcache.distributed.http.DistributedCacheHttpEndpoint;
import com.ustadmobile.libcache.headers.MimeTypeHelper;
import fi.iki.elonen.NanoHTTPD;
import io.github.aakira.napier.Napier;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.thauvin.erik.urlencoder.UrlEncoderUtil;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0016H\u0014J\"\u0010\u001f\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00120\u001b2\u0006\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/ustadmobile/core/embeddedhttp/EmbeddedHttpServer;", "Lfi/iki/elonen/NanoHTTPD;", "port", "", "contentEntryVersionServerUseCase", "Lkotlin/Function1;", "Lcom/ustadmobile/core/account/LearningSpace;", "Lcom/ustadmobile/core/domain/contententry/server/ContentEntryVersionServerUseCase;", "xapiServerUseCase", "Lcom/ustadmobile/core/domain/xapi/http/XapiHttpServerUseCase;", "staticUmAppFilesDir", "Ljava/io/File;", "mimeTypeHelper", "Lcom/ustadmobile/libcache/headers/MimeTypeHelper;", "distributedCacheHttpEndpoint", "Lcom/ustadmobile/libcache/distributed/http/DistributedCacheHttpEndpoint;", "(ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljava/io/File;Lcom/ustadmobile/libcache/headers/MimeTypeHelper;Lcom/ustadmobile/libcache/distributed/http/DistributedCacheHttpEndpoint;)V", "learningSpaceUrl", "", "learningSpace", "path", "serve", "Lfi/iki/elonen/NanoHTTPD$Response;", "session", "Lfi/iki/elonen/NanoHTTPD$IHTTPSession;", "serveApiEndpoint", "pathSegments", "", "useGzipWhenAccepted", "", "r", "joinPathSegments", "start", "end", "Companion", "core"})
public final class EmbeddedHttpServer
extends NanoHTTPD {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<LearningSpace, ContentEntryVersionServerUseCase> contentEntryVersionServerUseCase;
    @NotNull
    private final Function1<LearningSpace, XapiHttpServerUseCase> xapiServerUseCase;
    @Nullable
    private final File staticUmAppFilesDir;
    @NotNull
    private final MimeTypeHelper mimeTypeHelper;
    @Nullable
    private final DistributedCacheHttpEndpoint distributedCacheHttpEndpoint;
    @NotNull
    public static final String PATH_ENDPOINT_API = "/e/";
    @NotNull
    public static final String PATH_DCACHE = "/dcache";

    public EmbeddedHttpServer(int port, @NotNull Function1<? super LearningSpace, ContentEntryVersionServerUseCase> contentEntryVersionServerUseCase, @NotNull Function1<? super LearningSpace, XapiHttpServerUseCase> xapiServerUseCase, @Nullable File staticUmAppFilesDir, @NotNull MimeTypeHelper mimeTypeHelper, @Nullable DistributedCacheHttpEndpoint distributedCacheHttpEndpoint) {
        Intrinsics.checkNotNullParameter(contentEntryVersionServerUseCase, (String)"contentEntryVersionServerUseCase");
        Intrinsics.checkNotNullParameter(xapiServerUseCase, (String)"xapiServerUseCase");
        Intrinsics.checkNotNullParameter((Object)mimeTypeHelper, (String)"mimeTypeHelper");
        super(port);
        this.contentEntryVersionServerUseCase = contentEntryVersionServerUseCase;
        this.xapiServerUseCase = xapiServerUseCase;
        this.staticUmAppFilesDir = staticUmAppFilesDir;
        this.mimeTypeHelper = mimeTypeHelper;
        this.distributedCacheHttpEndpoint = distributedCacheHttpEndpoint;
    }

    @NotNull
    public final String joinPathSegments(@NotNull List<String> $this$joinPathSegments, int start, int end) {
        Intrinsics.checkNotNullParameter($this$joinPathSegments, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$joinPathSegments.subList(start, end), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String joinPathSegments$default(EmbeddedHttpServer embeddedHttpServer, List list, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = list.size();
        }
        return embeddedHttpServer.joinPathSegments(list, n, n2);
    }

    protected boolean useGzipWhenAccepted(@NotNull NanoHTTPD.Response r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return false;
    }

    @NotNull
    public final String learningSpaceUrl(@NotNull LearningSpace learningSpace, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)learningSpace, (String)"learningSpace");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String endpointEncoded = UrlEncoderUtil.encode$default((String)UrlEncoderUtil.encode$default((String)learningSpace.getUrl(), null, (boolean)false, (int)6, null), null, (boolean)false, (int)6, null);
        return "http://127.0.0.1:" + this.getListeningPort() + PATH_ENDPOINT_API + endpointEncoded + "/" + StringsKt.removePrefix((String)path, (CharSequence)"/");
    }

    @NotNull
    public NanoHTTPD.Response serve(@NotNull NanoHTTPD.IHTTPSession session) {
        NanoHTTPD.Response response;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String uri = session.getUri();
        Intrinsics.checkNotNull((Object)uri);
        String string = uri.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String[] stringArray = new String[]{"/"};
        List pathSegments = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        DistributedCacheHttpEndpoint dCacheEndpointVal = this.distributedCacheHttpEndpoint;
        if (StringsKt.startsWith$default((String)uri, (String)PATH_ENDPOINT_API, (boolean)false, (int)2, null)) {
            response = this.serveApiEndpoint(session, pathSegments);
        } else if (dCacheEndpointVal != null && StringsKt.startsWith$default((String)uri, (String)PATH_DCACHE, (boolean)false, (int)2, null)) {
            response = NanoHttpdResponseAdapterKt.toNanoHttpdResponse((IHttpResponse)dCacheEndpointVal.invoke(NanoHttpdRequestAdapterKt.asIHttpRequest((NanoHTTPD.IHTTPSession)session, (NanoHTTPD)this)));
        } else {
            NanoHTTPD.Response response2 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND), (String)"text/plain", (String)("not found: " + uri));
            Intrinsics.checkNotNull((Object)response2);
            response = response2;
        }
        return response;
    }

    private final NanoHTTPD.Response serveApiEndpoint(NanoHTTPD.IHTTPSession session, List<String> pathSegments) {
        NanoHTTPD.Response response;
        session.getParameters();
        String learningSpaceUrl = UrlEncoderUtil.decode$default((String)pathSegments.get(1), (boolean)false, (int)2, null);
        LearningSpace learningSpace = new LearningSpace(learningSpaceUrl);
        try {
            NanoHTTPD.Response response2;
            String string = (String)CollectionsKt.getOrNull(pathSegments, (int)2);
            if (Intrinsics.areEqual((Object)string, (Object)"api")) {
                String string2 = (String)CollectionsKt.getOrNull(pathSegments, (int)3);
                if (Intrinsics.areEqual((Object)string2, (Object)"content")) {
                    long contentEntryVersionUid = Long.parseLong(pathSegments.get(4));
                    List<String> pathInContentSegments = pathSegments.subList(5, pathSegments.size());
                    String pathInContent = CollectionsKt.joinToString$default((Iterable)pathInContentSegments, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                    String originalUrl = learningSpaceUrl + "api/content/" + contentEntryVersionUid + "/" + CollectionsKt.joinToString$default((Iterable)pathInContentSegments, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                    IHttpRequest request2 = RequestBuilderKt.iRequestBuilder((String)originalUrl, (Function1)((Function1)new Function1<RequestBuilder, Unit>(session){
                        final /* synthetic */ NanoHTTPD.IHTTPSession $session;
                        {
                            this.$session = $session;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull RequestBuilder $this$iRequestBuilder) {
                            boolean bl;
                            block5: {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$iRequestBuilder, (String)"$this$iRequestBuilder");
                                Map map2 = this.$session.getHeaders();
                                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getHeaders(...)");
                                Map map3 = map2;
                                NanoHTTPD.IHTTPSession iHTTPSession = this.$session;
                                boolean $i$f$forEach = false;
                                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    Map.Entry<K, V> element$iv;
                                    Map.Entry<K, V> it = element$iv = iterator.next();
                                    boolean bl2 = false;
                                    K k = it.getKey();
                                    Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                                    String string = (String)k;
                                    V v = it.getValue();
                                    Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                                    $this$iRequestBuilder.header(string, (String)v);
                                    $this$iRequestBuilder.setMethod(IHttpRequest.Companion.Method.valueOf((String)iHTTPSession.getMethod().name()));
                                }
                                Map map4 = this.$session.getHeaders();
                                Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"getHeaders(...)");
                                Map $this$any$iv = map4;
                                boolean $i$f$any = false;
                                if ($this$any$iv.isEmpty()) {
                                    bl = false;
                                } else {
                                    Iterator<Map.Entry<K, V>> iterator2 = $this$any$iv.entrySet().iterator();
                                    while (iterator2.hasNext()) {
                                        Map.Entry<K, V> element$iv;
                                        Map.Entry<K, V> it = element$iv = iterator2.next();
                                        boolean bl3 = false;
                                        if (!((String)it.getKey()).equals("accept-encoding")) continue;
                                        bl = true;
                                        break block5;
                                    }
                                    bl = false;
                                }
                            }
                            if (!bl) {
                                $this$iRequestBuilder.header("accept-encoding", "gzip");
                            }
                        }
                    }));
                    Napier.v$default((Napier)Napier.INSTANCE, null, null, (Function0)((Function0)new Function0<String>(learningSpaceUrl, contentEntryVersionUid, pathInContent){
                        final /* synthetic */ String $learningSpaceUrl;
                        final /* synthetic */ long $contentEntryVersionUid;
                        final /* synthetic */ String $pathInContent;
                        {
                            this.$learningSpaceUrl = $learningSpaceUrl;
                            this.$contentEntryVersionUid = $contentEntryVersionUid;
                            this.$pathInContent = $pathInContent;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "EmbeddedHttpServer: content: endpoint=" + this.$learningSpaceUrl + " versionUid=" + this.$contentEntryVersionUid + " path=" + this.$pathInContent;
                        }
                    }), (int)3, null);
                    Response okHttpResponse = ((ContentEntryVersionServerUseCase)this.contentEntryVersionServerUseCase.invoke((Object)learningSpace)).invoke(request2, contentEntryVersionUid, pathInContent);
                    response2 = ResponseExtKt.toHttpdResponse(okHttpResponse);
                } else if (Intrinsics.areEqual((Object)string2, (Object)"xapi")) {
                    NanoHTTPD.Response response3;
                    XapiHttpServerUseCase xapiHttpForLearningSpace = (XapiHttpServerUseCase)this.xapiServerUseCase.invoke((Object)learningSpace);
                    try {
                        response3 = (NanoHTTPD.Response)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super NanoHTTPD.Response>, Object>(xapiHttpForLearningSpace, pathSegments, session, this, null){
                            int label;
                            final /* synthetic */ XapiHttpServerUseCase $xapiHttpForLearningSpace;
                            final /* synthetic */ List<String> $pathSegments;
                            final /* synthetic */ NanoHTTPD.IHTTPSession $session;
                            final /* synthetic */ EmbeddedHttpServer this$0;
                            {
                                this.$xapiHttpForLearningSpace = $xapiHttpForLearningSpace;
                                this.$pathSegments = $pathSegments;
                                this.$session = $session;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$xapiHttpForLearningSpace.invoke(this.$pathSegments.subList(4, this.$pathSegments.size()), NanoHttpdRequestAdapterKt.asIHttpRequest((NanoHTTPD.IHTTPSession)this.$session, (NanoHTTPD)this.this$0), (Continuation<? super IHttpResponse>)((Continuation)this));
                                        if (object3 != object2) return NanoHttpdResponseAdapterKt.toNanoHttpdResponse((IHttpResponse)((IHttpResponse)object3));
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return NanoHttpdResponseAdapterKt.toNanoHttpdResponse((IHttpResponse)((IHttpResponse)object3));
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super NanoHTTPD.Response> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                    }
                    catch (HttpApiException e) {
                        NanoHTTPD.Response.IStatus iStatus = (NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.lookup((int)e.getStatusCode());
                        String string3 = e.getMessage();
                        if (string3 == null) {
                            string3 = e.toString();
                        }
                        response3 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)iStatus, (String)"text/plain", (String)string3);
                    }
                    response2 = response3;
                } else {
                    response2 = Companion.newNotFoundResponse(session);
                }
            } else {
                if (Intrinsics.areEqual((Object)string, (Object)"umapp")) {
                    if (this.staticUmAppFilesDir == null) {
                        return Companion.newNotFoundResponse("Static umapp files not enabled");
                    }
                    File it = new File(this.staticUmAppFilesDir, EmbeddedHttpServer.joinPathSegments$default(this, pathSegments, 3, 0, 2, null));
                    boolean bl = false;
                    File responseFile2 = ((CharSequence)CollectionsKt.last(pathSegments)).length() == 0 ? new File(it, "index.html") : it;
                    String string4 = this.mimeTypeHelper.guessByExtension(FilesKt.getExtension((File)responseFile2));
                    if (string4 == null) {
                        string4 = "application/octet-stream";
                    }
                    return ResponseExtKt.toHttpdResponse(responseFile2, session, string4);
                }
                response2 = Companion.newNotFoundResponse(session);
            }
            response = response2;
            Intrinsics.checkNotNull((Object)response);
        }
        catch (HttpApiException e) {
            NanoHTTPD.Response.IStatus iStatus = (NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.lookup((int)e.getStatusCode());
            String string = e.getMessage();
            if (string == null) {
                string = e.toString();
            }
            NanoHTTPD.Response response4 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)iStatus, (String)"text/plain", (String)string);
            Intrinsics.checkNotNull((Object)response4);
            response = response4;
        }
        catch (Throwable t) {
            NanoHTTPD.Response.IStatus iStatus = (NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR;
            String string = t.getMessage();
            if (string == null) {
                string = t.toString();
            }
            NanoHTTPD.Response response5 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)iStatus, (String)"text/plain", (String)string);
            Intrinsics.checkNotNull((Object)response5);
            response = response5;
        }
        return response;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/core/embeddedhttp/EmbeddedHttpServer$Companion;", "", "()V", "PATH_DCACHE", "", "PATH_ENDPOINT_API", "newNotFoundResponse", "Lfi/iki/elonen/NanoHTTPD$Response;", "session", "Lfi/iki/elonen/NanoHTTPD$IHTTPSession;", "message", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NanoHTTPD.Response newNotFoundResponse(@NotNull NanoHTTPD.IHTTPSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            return this.newNotFoundResponse("not found: " + session.getUri());
        }

        @NotNull
        public final NanoHTTPD.Response newNotFoundResponse(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND), (String)"text/plain", (String)message);
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"newFixedLengthResponse(...)");
            return response;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

