package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.entities.NewCacheEntry;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class NewCacheEntryDao_Impl extends NewCacheEntryDao {
  private final RoomDatabase __db;

  private final SharedSQLiteStatement __preparedStmtOfClearAll;

  public NewCacheEntryDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__preparedStmtOfClearAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM NewCacheEntry";
        return _query;
      }
    };
  }

  @Override
  public void clearAll() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfClearAll.acquire();
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfClearAll.release(_stmt);
    }
  }

  @Override
  public List<NewCacheEntry> findAllNewEntries() {
    final String _sql = "\n"
            + "        SELECT NewCacheEntry.*\n"
            + "          FROM NewCacheEntry\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCacheEntryKey = CursorUtil.getColumnIndexOrThrow(_cursor, "cacheEntryKey");
      final int _cursorIndexOfNceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "nceUrl");
      final List<NewCacheEntry> _result = new ArrayList<NewCacheEntry>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final NewCacheEntry _item;
        final String _tmpCacheEntryKey;
        _tmpCacheEntryKey = _cursor.getString(_cursorIndexOfCacheEntryKey);
        final String _tmpNceUrl;
        _tmpNceUrl = _cursor.getString(_cursorIndexOfNceUrl);
        _item = new NewCacheEntry(_tmpCacheEntryKey,_tmpNceUrl);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
