package com.ustadmobile.libcache.db

import androidx.room.Database
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.libcache.db.dao.CacheEntryDao
import com.ustadmobile.libcache.db.dao.NeighborCacheDao
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao
import com.ustadmobile.libcache.db.dao.NewCacheEntryDao
import com.ustadmobile.libcache.db.dao.RequestedEntryDao
import com.ustadmobile.libcache.db.dao.RetentionLockDao
import com.ustadmobile.libcache.db.entities.CacheEntry
import com.ustadmobile.libcache.db.entities.NeighborCache
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry
import com.ustadmobile.libcache.db.entities.NewCacheEntry
import com.ustadmobile.libcache.db.entities.RequestedEntry
import com.ustadmobile.libcache.db.entities.RetentionLock

@Database(
  version = 15,
  entities = arrayOf(CacheEntry::class, RequestedEntry::class, RetentionLock::class,
          NeighborCache::class, NeighborCacheEntry::class, NewCacheEntry::class),
  views = arrayOf(),
  exportSchema = true,
)
public actual abstract class UstadCacheDb : RoomDatabase() {
  public actual abstract val cacheEntryDao: CacheEntryDao

  public actual abstract val requestedEntryDao: RequestedEntryDao

  public actual abstract val retentionLockDao: RetentionLockDao

  public actual abstract val neighborCacheDao: NeighborCacheDao

  public actual abstract val neighborCacheEntryDao: NeighborCacheEntryDao

  public actual abstract val newCacheEntryDao: NewCacheEntryDao
}
