package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.entities.NeighborCache;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class NeighborCacheDao_Impl extends NeighborCacheDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<NeighborCache> __insertionAdapterOfNeighborCache;

  private final EntityInsertionAdapter<NeighborCache> __insertionAdapterOfNeighborCache_1;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAsync;

  private final SharedSQLiteStatement __preparedStmtOfUpdateHttpPort;

  private final SharedSQLiteStatement __preparedStmtOfUpdatePingTime;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStatuses;

  private final SharedSQLiteStatement __preparedStmtOfUpdateDeviceName;

  public NeighborCacheDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfNeighborCache = new EntityInsertionAdapter<NeighborCache>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `NeighborCache` (`neighborUid`,`neighborDeviceName`,`neighborIp`,`neighborUdpPort`,`neighborHttpPort`,`neighborDiscovered`,`neighborPingTime`,`neighborLastSeen`,`neighborStatus`) VALUES (?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final NeighborCache entity) {
        statement.bindLong(1, entity.getNeighborUid());
        statement.bindString(2, entity.getNeighborDeviceName());
        statement.bindString(3, entity.getNeighborIp());
        statement.bindLong(4, entity.getNeighborUdpPort());
        statement.bindLong(5, entity.getNeighborHttpPort());
        statement.bindLong(6, entity.getNeighborDiscovered());
        statement.bindLong(7, entity.getNeighborPingTime());
        statement.bindLong(8, entity.getNeighborLastSeen());
        statement.bindLong(9, entity.getNeighborStatus());
      }
    };
    this.__insertionAdapterOfNeighborCache_1 = new EntityInsertionAdapter<NeighborCache>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `NeighborCache` (`neighborUid`,`neighborDeviceName`,`neighborIp`,`neighborUdpPort`,`neighborHttpPort`,`neighborDiscovered`,`neighborPingTime`,`neighborLastSeen`,`neighborStatus`) VALUES (?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final NeighborCache entity) {
        statement.bindLong(1, entity.getNeighborUid());
        statement.bindString(2, entity.getNeighborDeviceName());
        statement.bindString(3, entity.getNeighborIp());
        statement.bindLong(4, entity.getNeighborUdpPort());
        statement.bindLong(5, entity.getNeighborHttpPort());
        statement.bindLong(6, entity.getNeighborDiscovered());
        statement.bindLong(7, entity.getNeighborPingTime());
        statement.bindLong(8, entity.getNeighborLastSeen());
        statement.bindLong(9, entity.getNeighborStatus());
      }
    };
    this.__preparedStmtOfDeleteAsync = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        DELETE FROM NeighborCache\n"
                + "         WHERE neighborUid = ?\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateHttpPort = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE NeighborCache\n"
                + "           SET neighborHttpPort = ?\n"
                + "         WHERE neighborUid = ?\n"
                + "           AND neighborHttpPort != ?\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdatePingTime = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE NeighborCache\n"
                + "           SET neighborPingTime = ?,\n"
                + "               neighborLastSeen = ?\n"
                + "         WHERE neighborUid = ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateStatuses = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE NeighborCache\n"
                + "           SET neighborStatus = CAST(((? - NeighborCache.neighborLastSeen) < ?) AS INTEGER)\n"
                + "         WHERE neighborStatus != CAST(((? - NeighborCache.neighborLastSeen) < ?) AS INTEGER)   \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateDeviceName = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE NeighborCache\n"
                + "           SET neighborDeviceName = ?\n"
                + "        WHERE neighborUid = ?\n"
                + "          AND neighborDeviceName != ?   \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object upsertAsync(final NeighborCache neighborCache,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfNeighborCache.insert(neighborCache);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void upsert(final NeighborCache neighborCache) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfNeighborCache.insert(neighborCache);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void insertOrIgnore(final NeighborCache neighborCache) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfNeighborCache_1.insert(neighborCache);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object deleteAsync(final long neighborUid, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, neighborUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAsync.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public void updateHttpPort(final long neighborUid, final int httpPort) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateHttpPort.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, httpPort);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, neighborUid);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, httpPort);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateHttpPort.release(_stmt);
    }
  }

  @Override
  public int updatePingTime(final long neighborUid, final int pingTime, final long timeNow) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdatePingTime.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, pingTime);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, timeNow);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, neighborUid);
    try {
      __db.beginTransaction();
      try {
        final int _result = _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdatePingTime.release(_stmt);
    }
  }

  @Override
  public void updateStatuses(final long timeNow, final long lostThreshold) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStatuses.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, timeNow);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, lostThreshold);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, timeNow);
    _argIndex = 4;
    _stmt.bindLong(_argIndex, lostThreshold);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateStatuses.release(_stmt);
    }
  }

  @Override
  public void updateDeviceName(final long neighborUid, final String deviceName) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateDeviceName.acquire();
    int _argIndex = 1;
    _stmt.bindString(_argIndex, deviceName);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, neighborUid);
    _argIndex = 3;
    _stmt.bindString(_argIndex, deviceName);
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateDeviceName.release(_stmt);
    }
  }

  @Override
  public Flow<List<NeighborCache>> allNeighborsAsFlow() {
    final String _sql = "\n"
            + "        SELECT NeighborCache.*\n"
            + "          FROM NeighborCache\n"
            + "         WHERE NeighborCache.neighborStatus = 1 \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"NeighborCache"}, new Callable<List<NeighborCache>>() {
      @Override
      @NonNull
      public List<NeighborCache> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfNeighborUid = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborUid");
          final int _cursorIndexOfNeighborDeviceName = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborDeviceName");
          final int _cursorIndexOfNeighborIp = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborIp");
          final int _cursorIndexOfNeighborUdpPort = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborUdpPort");
          final int _cursorIndexOfNeighborHttpPort = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborHttpPort");
          final int _cursorIndexOfNeighborDiscovered = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborDiscovered");
          final int _cursorIndexOfNeighborPingTime = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborPingTime");
          final int _cursorIndexOfNeighborLastSeen = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborLastSeen");
          final int _cursorIndexOfNeighborStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborStatus");
          final List<NeighborCache> _result = new ArrayList<NeighborCache>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final NeighborCache _item;
            final long _tmpNeighborUid;
            _tmpNeighborUid = _cursor.getLong(_cursorIndexOfNeighborUid);
            final String _tmpNeighborDeviceName;
            _tmpNeighborDeviceName = _cursor.getString(_cursorIndexOfNeighborDeviceName);
            final String _tmpNeighborIp;
            _tmpNeighborIp = _cursor.getString(_cursorIndexOfNeighborIp);
            final int _tmpNeighborUdpPort;
            _tmpNeighborUdpPort = _cursor.getInt(_cursorIndexOfNeighborUdpPort);
            final int _tmpNeighborHttpPort;
            _tmpNeighborHttpPort = _cursor.getInt(_cursorIndexOfNeighborHttpPort);
            final long _tmpNeighborDiscovered;
            _tmpNeighborDiscovered = _cursor.getLong(_cursorIndexOfNeighborDiscovered);
            final int _tmpNeighborPingTime;
            _tmpNeighborPingTime = _cursor.getInt(_cursorIndexOfNeighborPingTime);
            final long _tmpNeighborLastSeen;
            _tmpNeighborLastSeen = _cursor.getLong(_cursorIndexOfNeighborLastSeen);
            final int _tmpNeighborStatus;
            _tmpNeighborStatus = _cursor.getInt(_cursorIndexOfNeighborStatus);
            _item = new NeighborCache(_tmpNeighborUid,_tmpNeighborDeviceName,_tmpNeighborIp,_tmpNeighborUdpPort,_tmpNeighborHttpPort,_tmpNeighborDiscovered,_tmpNeighborPingTime,_tmpNeighborLastSeen,_tmpNeighborStatus);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<NeighborCache> allNeighbors() {
    final String _sql = "\n"
            + "        SELECT NeighborCache.*\n"
            + "          FROM NeighborCache\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfNeighborUid = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborUid");
      final int _cursorIndexOfNeighborDeviceName = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborDeviceName");
      final int _cursorIndexOfNeighborIp = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborIp");
      final int _cursorIndexOfNeighborUdpPort = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborUdpPort");
      final int _cursorIndexOfNeighborHttpPort = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborHttpPort");
      final int _cursorIndexOfNeighborDiscovered = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborDiscovered");
      final int _cursorIndexOfNeighborPingTime = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborPingTime");
      final int _cursorIndexOfNeighborLastSeen = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborLastSeen");
      final int _cursorIndexOfNeighborStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborStatus");
      final List<NeighborCache> _result = new ArrayList<NeighborCache>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final NeighborCache _item;
        final long _tmpNeighborUid;
        _tmpNeighborUid = _cursor.getLong(_cursorIndexOfNeighborUid);
        final String _tmpNeighborDeviceName;
        _tmpNeighborDeviceName = _cursor.getString(_cursorIndexOfNeighborDeviceName);
        final String _tmpNeighborIp;
        _tmpNeighborIp = _cursor.getString(_cursorIndexOfNeighborIp);
        final int _tmpNeighborUdpPort;
        _tmpNeighborUdpPort = _cursor.getInt(_cursorIndexOfNeighborUdpPort);
        final int _tmpNeighborHttpPort;
        _tmpNeighborHttpPort = _cursor.getInt(_cursorIndexOfNeighborHttpPort);
        final long _tmpNeighborDiscovered;
        _tmpNeighborDiscovered = _cursor.getLong(_cursorIndexOfNeighborDiscovered);
        final int _tmpNeighborPingTime;
        _tmpNeighborPingTime = _cursor.getInt(_cursorIndexOfNeighborPingTime);
        final long _tmpNeighborLastSeen;
        _tmpNeighborLastSeen = _cursor.getLong(_cursorIndexOfNeighborLastSeen);
        final int _tmpNeighborStatus;
        _tmpNeighborStatus = _cursor.getInt(_cursorIndexOfNeighborStatus);
        _item = new NeighborCache(_tmpNeighborUid,_tmpNeighborDeviceName,_tmpNeighborIp,_tmpNeighborUdpPort,_tmpNeighborHttpPort,_tmpNeighborDiscovered,_tmpNeighborPingTime,_tmpNeighborLastSeen,_tmpNeighborStatus);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
