package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache;
import com.ustadmobile.libcache.db.entities.NeighborCache;
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class NeighborCacheEntryDao_Impl extends NeighborCacheEntryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<NeighborCacheEntry> __insertionAdapterOfNeighborCacheEntry;

  public NeighborCacheEntryDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfNeighborCacheEntry = new EntityInsertionAdapter<NeighborCacheEntry>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `NeighborCacheEntry` (`nceNeighborUid`,`nceUrlHash`) VALUES (?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final NeighborCacheEntry entity) {
        statement.bindLong(1, entity.getNceNeighborUid());
        statement.bindLong(2, entity.getNceUrlHash());
      }
    };
  }

  @Override
  public void upsertList(final List<NeighborCacheEntry> neighborCacheEntryList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfNeighborCacheEntry.insert(neighborCacheEntryList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Flow<List<NeighborCacheEntry>> allEntriesAsFlow() {
    final String _sql = "\n"
            + "        SELECT NeighborCacheEntry.* \n"
            + "          FROM NeighborCacheEntry\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"NeighborCacheEntry"}, new Callable<List<NeighborCacheEntry>>() {
      @Override
      @NonNull
      public List<NeighborCacheEntry> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfNceNeighborUid = CursorUtil.getColumnIndexOrThrow(_cursor, "nceNeighborUid");
          final int _cursorIndexOfNceUrlHash = CursorUtil.getColumnIndexOrThrow(_cursor, "nceUrlHash");
          final List<NeighborCacheEntry> _result = new ArrayList<NeighborCacheEntry>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final NeighborCacheEntry _item;
            final long _tmpNceNeighborUid;
            _tmpNceNeighborUid = _cursor.getLong(_cursorIndexOfNceNeighborUid);
            final long _tmpNceUrlHash;
            _tmpNceUrlHash = _cursor.getLong(_cursorIndexOfNceUrlHash);
            _item = new NeighborCacheEntry(_tmpNceNeighborUid,_tmpNceUrlHash);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<Long> findAvailableEntries(final List<Long> urlHashes) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT NeighborCacheEntry.nceUrlHash");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM NeighborCacheEntry");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE NeighborCacheEntry.nceUrlHash IN (");
    final int _inputSize = urlHashes.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(") ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : urlHashes) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Long _item_1;
        _item_1 = _cursor.getLong(0);
        _result.add(_item_1);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<NeighborCacheEntryAndNeighborCache> findAvailableNeighborsByUrlHash(
      final long urlHash) {
    final String _sql = "\n"
            + "        SELECT NeighborCacheEntry.*,\n"
            + "               NeighborCache.*\n"
            + "          FROM NeighborCacheEntry\n"
            + "               JOIN NeighborCache\n"
            + "                    ON NeighborCache.neighborUid = NeighborCacheEntry.nceNeighborUid\n"
            + "         WHERE NeighborCacheEntry.nceUrlHash = ?\n"
            + "           AND NeighborCache.neighborStatus = 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, urlHash);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfNceNeighborUid = CursorUtil.getColumnIndexOrThrow(_cursor, "nceNeighborUid");
      final int _cursorIndexOfNceUrlHash = CursorUtil.getColumnIndexOrThrow(_cursor, "nceUrlHash");
      final int _cursorIndexOfNeighborUid = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborUid");
      final int _cursorIndexOfNeighborDeviceName = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborDeviceName");
      final int _cursorIndexOfNeighborIp = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborIp");
      final int _cursorIndexOfNeighborUdpPort = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborUdpPort");
      final int _cursorIndexOfNeighborHttpPort = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborHttpPort");
      final int _cursorIndexOfNeighborDiscovered = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborDiscovered");
      final int _cursorIndexOfNeighborPingTime = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborPingTime");
      final int _cursorIndexOfNeighborLastSeen = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborLastSeen");
      final int _cursorIndexOfNeighborStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "neighborStatus");
      final List<NeighborCacheEntryAndNeighborCache> _result = new ArrayList<NeighborCacheEntryAndNeighborCache>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final NeighborCacheEntryAndNeighborCache _item;
        final NeighborCacheEntry _tmpNeighborCacheEntry;
        final long _tmpNceNeighborUid;
        _tmpNceNeighborUid = _cursor.getLong(_cursorIndexOfNceNeighborUid);
        final long _tmpNceUrlHash;
        _tmpNceUrlHash = _cursor.getLong(_cursorIndexOfNceUrlHash);
        _tmpNeighborCacheEntry = new NeighborCacheEntry(_tmpNceNeighborUid,_tmpNceUrlHash);
        final NeighborCache _tmpNeighborCache;
        final long _tmpNeighborUid;
        _tmpNeighborUid = _cursor.getLong(_cursorIndexOfNeighborUid);
        final String _tmpNeighborDeviceName;
        _tmpNeighborDeviceName = _cursor.getString(_cursorIndexOfNeighborDeviceName);
        final String _tmpNeighborIp;
        _tmpNeighborIp = _cursor.getString(_cursorIndexOfNeighborIp);
        final int _tmpNeighborUdpPort;
        _tmpNeighborUdpPort = _cursor.getInt(_cursorIndexOfNeighborUdpPort);
        final int _tmpNeighborHttpPort;
        _tmpNeighborHttpPort = _cursor.getInt(_cursorIndexOfNeighborHttpPort);
        final long _tmpNeighborDiscovered;
        _tmpNeighborDiscovered = _cursor.getLong(_cursorIndexOfNeighborDiscovered);
        final int _tmpNeighborPingTime;
        _tmpNeighborPingTime = _cursor.getInt(_cursorIndexOfNeighborPingTime);
        final long _tmpNeighborLastSeen;
        _tmpNeighborLastSeen = _cursor.getLong(_cursorIndexOfNeighborLastSeen);
        final int _tmpNeighborStatus;
        _tmpNeighborStatus = _cursor.getInt(_cursorIndexOfNeighborStatus);
        _tmpNeighborCache = new NeighborCache(_tmpNeighborUid,_tmpNeighborDeviceName,_tmpNeighborIp,_tmpNeighborUdpPort,_tmpNeighborHttpPort,_tmpNeighborDiscovered,_tmpNeighborPingTime,_tmpNeighborLastSeen,_tmpNeighborStatus);
        _item = new NeighborCacheEntryAndNeighborCache(_tmpNeighborCache,_tmpNeighborCacheEntry);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
