package com.ustadmobile.libcache.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry
import kotlin.Any
import kotlin.Long
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

@Dao
public actual abstract class NeighborCacheEntryDao {
  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract fun upsertList(neighborCacheEntryList: List<NeighborCacheEntry>)

  @Query(`value` =
      "\n        SELECT NeighborCacheEntry.* \n          FROM NeighborCacheEntry\n    ")
  public actual abstract fun allEntriesAsFlow(): Flow<List<NeighborCacheEntry>>

  @Query(`value` =
      "\n        SELECT NeighborCacheEntry.nceUrlHash\n          FROM NeighborCacheEntry\n         WHERE NeighborCacheEntry.nceUrlHash IN (:urlHashes) \n    ")
  public actual abstract fun findAvailableEntries(urlHashes: List<Long>): List<Long>

  @Query(`value` =
      "\n        SELECT NeighborCacheEntry.*,\n               NeighborCache.*\n          FROM NeighborCacheEntry\n               JOIN NeighborCache\n                    ON NeighborCache.neighborUid = NeighborCacheEntry.nceNeighborUid\n         WHERE NeighborCacheEntry.nceUrlHash = :urlHash\n           AND NeighborCache.neighborStatus = 1\n    ")
  public actual abstract fun findAvailableNeighborsByUrlHash(urlHash: Long):
      List<NeighborCacheEntryAndNeighborCache>
}
