package com.ustadmobile.libcache.db.dao

import com.ustadmobile.door.DoorDbType
import com.ustadmobile.door.EntityInsertionAdapter
import com.ustadmobile.door.PreparedStatementConfig
import com.ustadmobile.door.ext.prepareAndUseStatement
import com.ustadmobile.door.ext.prepareAndUseStatementAsync
import com.ustadmobile.door.flow.doorFlow
import com.ustadmobile.door.jdbc.PreparedStatement
import com.ustadmobile.door.jdbc.ext.executeQueryAsyncKmp
import com.ustadmobile.door.jdbc.ext.executeUpdateAsyncKmp
import com.ustadmobile.door.jdbc.ext.getStringNonNull
import com.ustadmobile.door.jdbc.ext.mapRows
import com.ustadmobile.door.jdbc.ext.useResults
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.libcache.db.entities.NeighborCache
import kotlin.Boolean
import kotlin.IllegalArgumentException
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public class NeighborCacheDao_JdbcImpl(
  public val _db: RoomDatabase,
) : NeighborCacheDao() {
  public val _insertAdapterNeighborCache_upsert: EntityInsertionAdapter<NeighborCache> = object :
      EntityInsertionAdapter<NeighborCache>(_db) {
    override fun makeSql(returnsId: Boolean): String = when(dbType) {
      DoorDbType.SQLITE -> {
        "INSERT OR REPLACE INTO NeighborCache (neighborUid, neighborDeviceName, neighborIp, neighborUdpPort, neighborHttpPort, neighborDiscovered, neighborPingTime, neighborLastSeen, neighborStatus) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"
      }
      DoorDbType.POSTGRES ->  {
        "INSERT INTO NeighborCache (neighborUid, neighborDeviceName, neighborIp, neighborUdpPort, neighborHttpPort, neighborDiscovered, neighborPingTime, neighborLastSeen, neighborStatus) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT (neighborUid) DO UPDATE SET neighborDeviceName = excluded.neighborDeviceName,neighborIp = excluded.neighborIp,neighborUdpPort = excluded.neighborUdpPort,neighborHttpPort = excluded.neighborHttpPort,neighborDiscovered = excluded.neighborDiscovered,neighborPingTime = excluded.neighborPingTime,neighborLastSeen = excluded.neighborLastSeen,neighborStatus = excluded.neighborStatus" + if(returnsId) { " RETURNING neighborUid" } else "" 
      }
      else -> {
        throw IllegalArgumentException("Unsupported db type")
      }
    }

    override fun bindPreparedStmtToEntity(stmt: PreparedStatement, entity: NeighborCache) {
      stmt.setLong(1, entity.neighborUid)
      stmt.setString(2, entity.neighborDeviceName)
      stmt.setString(3, entity.neighborIp)
      stmt.setInt(4, entity.neighborUdpPort)
      stmt.setInt(5, entity.neighborHttpPort)
      stmt.setLong(6, entity.neighborDiscovered)
      stmt.setInt(7, entity.neighborPingTime)
      stmt.setLong(8, entity.neighborLastSeen)
      stmt.setInt(9, entity.neighborStatus)
    }
  }

  public val _insertAdapterNeighborCache_ignore: EntityInsertionAdapter<NeighborCache> = object :
      EntityInsertionAdapter<NeighborCache>(_db) {
    override fun makeSql(returnsId: Boolean): String = when(dbType) {
      DoorDbType.SQLITE -> {
        "INSERT  OR IGNORE INTO NeighborCache (neighborUid, neighborDeviceName, neighborIp, neighborUdpPort, neighborHttpPort, neighborDiscovered, neighborPingTime, neighborLastSeen, neighborStatus) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"
      }
      DoorDbType.POSTGRES ->  {
        "INSERT INTO NeighborCache (neighborUid, neighborDeviceName, neighborIp, neighborUdpPort, neighborHttpPort, neighborDiscovered, neighborPingTime, neighborLastSeen, neighborStatus) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT (neighborUid) DO NOTHING" + if(returnsId) { " RETURNING neighborUid" } else "" 
      }
      else -> {
        throw IllegalArgumentException("Unsupported db type")
      }
    }

    override fun bindPreparedStmtToEntity(stmt: PreparedStatement, entity: NeighborCache) {
      stmt.setLong(1, entity.neighborUid)
      stmt.setString(2, entity.neighborDeviceName)
      stmt.setString(3, entity.neighborIp)
      stmt.setInt(4, entity.neighborUdpPort)
      stmt.setInt(5, entity.neighborHttpPort)
      stmt.setLong(6, entity.neighborDiscovered)
      stmt.setInt(7, entity.neighborPingTime)
      stmt.setLong(8, entity.neighborLastSeen)
      stmt.setInt(9, entity.neighborStatus)
    }
  }

  override suspend fun upsertAsync(neighborCache: NeighborCache) {
    _insertAdapterNeighborCache_upsert.insertAsync(neighborCache)
  }

  override fun upsert(neighborCache: NeighborCache) {
    _insertAdapterNeighborCache_upsert.insert(neighborCache)
  }

  override fun insertOrIgnore(neighborCache: NeighborCache) {
    _insertAdapterNeighborCache_ignore.insert(neighborCache)
  }

  override suspend fun deleteAsync(neighborUid: Long) {
    _db.prepareAndUseStatementAsync(PreparedStatementConfig(
      sql = """
      |
      |        DELETE FROM NeighborCache
      |         WHERE neighborUid = ?
      |    
      """.trimMargin(),
      readOnly = false,)
    ) { _stmt -> 
      _stmt.setLong(1,neighborUid)
      _stmt.executeUpdateAsyncKmp()
    }
  }

  override fun allNeighborsAsFlow(): Flow<List<NeighborCache>> =
      _db.doorFlow(arrayOf("NeighborCache")) {
    _db.prepareAndUseStatementAsync(PreparedStatementConfig(
      sql = """
      |
      |        SELECT NeighborCache.*
      |          FROM NeighborCache
      |         WHERE NeighborCache.neighborStatus = 1 
      |    
      """.trimMargin(),
      readOnly = true,)
    ) { _stmt -> 
      _stmt.executeQueryAsyncKmp().useResults{ _result -> 
        _result.mapRows {
          val _tmp_neighborUid = _result.getLong("neighborUid")
          val _tmp_neighborDeviceName = _result.getStringNonNull("neighborDeviceName")
          val _tmp_neighborIp = _result.getStringNonNull("neighborIp")
          val _tmp_neighborUdpPort = _result.getInt("neighborUdpPort")
          val _tmp_neighborHttpPort = _result.getInt("neighborHttpPort")
          val _tmp_neighborDiscovered = _result.getLong("neighborDiscovered")
          val _tmp_neighborPingTime = _result.getInt("neighborPingTime")
          val _tmp_neighborLastSeen = _result.getLong("neighborLastSeen")
          val _tmp_neighborStatus = _result.getInt("neighborStatus")
          NeighborCache().apply {
            this.neighborUid = _tmp_neighborUid
            this.neighborDeviceName = _tmp_neighborDeviceName
            this.neighborIp = _tmp_neighborIp
            this.neighborUdpPort = _tmp_neighborUdpPort
            this.neighborHttpPort = _tmp_neighborHttpPort
            this.neighborDiscovered = _tmp_neighborDiscovered
            this.neighborPingTime = _tmp_neighborPingTime
            this.neighborLastSeen = _tmp_neighborLastSeen
            this.neighborStatus = _tmp_neighborStatus
          }
        }
      }
    }
  }

  override fun allNeighbors(): List<NeighborCache> =
      _db.prepareAndUseStatement(PreparedStatementConfig(
    sql = """
    |
    |        SELECT NeighborCache.*
    |          FROM NeighborCache
    |    
    """.trimMargin(),
    readOnly = true,)
  ) { _stmt -> 
    _stmt.executeQuery().useResults{ _result -> 
      _result.mapRows {
        val _tmp_neighborUid = _result.getLong("neighborUid")
        val _tmp_neighborDeviceName = _result.getStringNonNull("neighborDeviceName")
        val _tmp_neighborIp = _result.getStringNonNull("neighborIp")
        val _tmp_neighborUdpPort = _result.getInt("neighborUdpPort")
        val _tmp_neighborHttpPort = _result.getInt("neighborHttpPort")
        val _tmp_neighborDiscovered = _result.getLong("neighborDiscovered")
        val _tmp_neighborPingTime = _result.getInt("neighborPingTime")
        val _tmp_neighborLastSeen = _result.getLong("neighborLastSeen")
        val _tmp_neighborStatus = _result.getInt("neighborStatus")
        NeighborCache().apply {
          this.neighborUid = _tmp_neighborUid
          this.neighborDeviceName = _tmp_neighborDeviceName
          this.neighborIp = _tmp_neighborIp
          this.neighborUdpPort = _tmp_neighborUdpPort
          this.neighborHttpPort = _tmp_neighborHttpPort
          this.neighborDiscovered = _tmp_neighborDiscovered
          this.neighborPingTime = _tmp_neighborPingTime
          this.neighborLastSeen = _tmp_neighborLastSeen
          this.neighborStatus = _tmp_neighborStatus
        }
      }
    }
  }

  override fun updateHttpPort(neighborUid: Long, httpPort: Int) {
    _db.prepareAndUseStatement(PreparedStatementConfig(
      sql = """
      |
      |        UPDATE NeighborCache
      |           SET neighborHttpPort = ?
      |         WHERE neighborUid = ?
      |           AND neighborHttpPort != ?
      |    
      """.trimMargin(),
      readOnly = false,)
    ) { _stmt -> 
      _stmt.setInt(1,httpPort)
      _stmt.setLong(2,neighborUid)
      _stmt.setInt(3,httpPort)
      _stmt.executeUpdate()
    }
  }

  override fun updatePingTime(
    neighborUid: Long,
    pingTime: Int,
    timeNow: Long,
  ): Int = _db.prepareAndUseStatement(PreparedStatementConfig(
    sql = """
    |
    |        UPDATE NeighborCache
    |           SET neighborPingTime = ?,
    |               neighborLastSeen = ?
    |         WHERE neighborUid = ?  
    |    
    """.trimMargin(),
    readOnly = false,)
  ) { _stmt -> 
    _stmt.setInt(1,pingTime)
    _stmt.setLong(2,timeNow)
    _stmt.setLong(3,neighborUid)
    _stmt.executeUpdate()
  }

  override fun updateStatuses(timeNow: Long, lostThreshold: Long) {
    _db.prepareAndUseStatement(PreparedStatementConfig(
      sql = """
      |
      |        UPDATE NeighborCache
      |           SET neighborStatus = CAST(((? - NeighborCache.neighborLastSeen) < ?) AS INTEGER)
      |         WHERE neighborStatus != CAST(((? - NeighborCache.neighborLastSeen) < ?) AS INTEGER)   
      |    
      """.trimMargin(),
      readOnly = false,)
    ) { _stmt -> 
      _stmt.setLong(1,timeNow)
      _stmt.setLong(2,lostThreshold)
      _stmt.setLong(3,timeNow)
      _stmt.setLong(4,lostThreshold)
      _stmt.executeUpdate()
    }
  }

  override fun updateDeviceName(neighborUid: Long, deviceName: String) {
    _db.prepareAndUseStatement(PreparedStatementConfig(
      sql = """
      |
      |        UPDATE NeighborCache
      |           SET neighborDeviceName = ?
      |        WHERE neighborUid = ?
      |          AND neighborDeviceName != ?   
      |    
      """.trimMargin(),
      readOnly = false,)
    ) { _stmt -> 
      _stmt.setString(1,deviceName)
      _stmt.setLong(2,neighborUid)
      _stmt.setString(3,deviceName)
      _stmt.executeUpdate()
    }
  }
}
