package com.ustadmobile.libcache.db.dao

import com.ustadmobile.door.DoorDbType
import com.ustadmobile.door.PreparedStatementConfig
import com.ustadmobile.door.ext.prepareAndUseStatement
import com.ustadmobile.door.jdbc.ext.getStringNonNull
import com.ustadmobile.door.jdbc.ext.mapRows
import com.ustadmobile.door.jdbc.ext.useResults
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.libcache.db.entities.NewCacheEntry
import kotlin.collections.List

public class NewCacheEntryDao_JdbcImpl(
  public val _db: RoomDatabase,
) : NewCacheEntryDao() {
  override fun findAllNewEntries(): List<NewCacheEntry> =
      _db.prepareAndUseStatement(PreparedStatementConfig(
    sql = """
    |
    |        SELECT NewCacheEntry.*
    |          FROM NewCacheEntry
    |    
    """.trimMargin(),
    readOnly = true,)
  ) { _stmt -> 
    _stmt.executeQuery().useResults{ _result -> 
      _result.mapRows {
        val _tmp_cacheEntryKey = _result.getStringNonNull("cacheEntryKey")
        val _tmp_nceUrl = _result.getStringNonNull("nceUrl")
        NewCacheEntry().apply {
          this.cacheEntryKey = _tmp_cacheEntryKey
          this.nceUrl = _tmp_nceUrl
        }
      }
    }
  }

  override fun clearAll() {
    _db.prepareAndUseStatement(PreparedStatementConfig(
      sql = "DELETE FROM NewCacheEntry",
      readOnly = false,)
    ) { _stmt -> 
      _stmt.executeUpdate()
    }
  }
}
