/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.libcache.db.composites.NeighborCacheEntryAndNeighborCache;
import com.ustadmobile.libcache.db.entities.NeighborCacheEntry;
import java.util.List;
import kotlin.Metadata;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004H'J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H'J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\f\u001a\u00020\bH'J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H'\u00a8\u0006\u0010"}, d2={"Lcom/ustadmobile/libcache/db/dao/NeighborCacheEntryDao;", "", "()V", "allEntriesAsFlow", "Lkotlinx/coroutines/flow/Flow;", "", "Lcom/ustadmobile/libcache/db/entities/NeighborCacheEntry;", "findAvailableEntries", "", "urlHashes", "findAvailableNeighborsByUrlHash", "Lcom/ustadmobile/libcache/db/composites/NeighborCacheEntryAndNeighborCache;", "urlHash", "upsertList", "", "neighborCacheEntryList", "lib-cache_debug"})
@Dao
public abstract class NeighborCacheEntryDao {
    @Insert(entity=Object.class, onConflict=1)
    public abstract void upsertList(@NotNull List<NeighborCacheEntry> var1);

    @Query(value="\n        SELECT NeighborCacheEntry.* \n          FROM NeighborCacheEntry\n    ")
    @NotNull
    public abstract Flow<List<NeighborCacheEntry>> allEntriesAsFlow();

    @Query(value="\n        SELECT NeighborCacheEntry.nceUrlHash\n          FROM NeighborCacheEntry\n         WHERE NeighborCacheEntry.nceUrlHash IN (:urlHashes) \n    ")
    @NotNull
    public abstract List<Long> findAvailableEntries(@NotNull List<Long> var1);

    @Query(value="\n        SELECT NeighborCacheEntry.*,\n               NeighborCache.*\n          FROM NeighborCacheEntry\n               JOIN NeighborCache\n                    ON NeighborCache.neighborUid = NeighborCacheEntry.nceNeighborUid\n         WHERE NeighborCacheEntry.nceUrlHash = :urlHash\n           AND NeighborCache.neighborStatus = 1\n    ")
    @NotNull
    public abstract List<NeighborCacheEntryAndNeighborCache> findAvailableNeighborsByUrlHash(long var1);
}

