/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed.model;

import com.ustadmobile.libcache.distributed.model.DistributedCachePacket;
import com.ustadmobile.libcache.distributed.model.DistributedCacheWhatWithIdAndPayload;
import com.ustadmobile.libcache.util.ByteBufferExtKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u0007H\u0016R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePong;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCacheWhatWithIdAndPayload;", "id", "", "httpPort", "payload", "", "(II[B)V", "getHttpPort", "()I", "getId", "getPayload", "()[B", "toBytes", "Companion", "lib-cache_debug"})
public final class DistributedCachePong
extends DistributedCachePacket
implements DistributedCacheWhatWithIdAndPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    private final int httpPort;
    @NotNull
    private final byte[] payload;
    public static final int OVERHEAD_SIZE = 11;

    public DistributedCachePong(int id, int httpPort, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        super(null);
        this.id = id;
        this.httpPort = httpPort;
        this.payload = payload;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    @NotNull
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        ByteBuffer byteBuf = ByteBuffer.allocate(11 + this.getPayload().length);
        byteBuf.put((byte)3);
        byteBuf.putInt(this.getHttpPort());
        byteBuf.putInt(this.getId());
        Intrinsics.checkNotNull((Object)byteBuf);
        ByteBufferExtKt.writePayload(byteBuf, this.getPayload());
        byte[] byArray = byteBuf.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePong$Companion;", "", "()V", "OVERHEAD_SIZE", "", "readDistributedCachePong", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePong;", "Ljava/nio/ByteBuffer;", "httpPort", "lib-cache_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DistributedCachePong readDistributedCachePong(@NotNull ByteBuffer $this$readDistributedCachePong, int httpPort) {
            Intrinsics.checkNotNullParameter((Object)$this$readDistributedCachePong, (String)"<this>");
            int id = $this$readDistributedCachePong.getInt();
            byte[] payload = ByteBufferExtKt.readPayload($this$readDistributedCachePong);
            return new DistributedCachePong(id, httpPort, payload);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

