package com.ustadmobile.centralappconfigdb.db

import app.cash.sqldelight.Query
import app.cash.sqldelight.TransacterImpl
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlCursor
import app.cash.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Long
import kotlin.String

public class SystemConfigAuthQueries(
  driver: SqlDriver,
) : TransacterImpl(driver) {
  public fun <T : Any> selectByAuthId(scaAuthId: String, mapper: (
    scaUid: Long,
    scaAuthType: Long,
    scaAuthId: String,
    scaAuthCredential: String,
    scaAuthSalt: String,
  ) -> T): Query<T> = SelectByAuthIdQuery(scaAuthId) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3)!!,
      cursor.getString(4)!!
    )
  }

  public fun selectByAuthId(scaAuthId: String): Query<SystemConfigAuth> =
      selectByAuthId(scaAuthId) { scaUid, scaAuthType, scaAuthId_, scaAuthCredential, scaAuthSalt ->
    SystemConfigAuth(
      scaUid,
      scaAuthType,
      scaAuthId_,
      scaAuthCredential,
      scaAuthSalt
    )
  }

  public fun insert(SystemConfigAuth: SystemConfigAuth) {
    driver.execute(1_209_378_298, """
        |INSERT INTO SystemConfigAuth(scaUid, scaAuthType, scaAuthId , scaAuthCredential, scaAuthSalt)
        |VALUES (?, ?, ?, ?, ?)
        """.trimMargin(), 5) {
          bindLong(0, SystemConfigAuth.scaUid)
          bindLong(1, SystemConfigAuth.scaAuthType)
          bindString(2, SystemConfigAuth.scaAuthId)
          bindString(3, SystemConfigAuth.scaAuthCredential)
          bindString(4, SystemConfigAuth.scaAuthSalt)
        }
    notifyQueries(1_209_378_298) { emit ->
      emit("SystemConfigAuth")
    }
  }

  private inner class SelectByAuthIdQuery<out T : Any>(
    public val scaAuthId: String,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("SystemConfigAuth", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("SystemConfigAuth", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> =
        driver.executeQuery(1_909_204_855, """
    |SELECT SystemConfigAuth.scaUid, SystemConfigAuth.scaAuthType, SystemConfigAuth.scaAuthId, SystemConfigAuth.scaAuthCredential, SystemConfigAuth.scaAuthSalt
    |FROM SystemConfigAuth
    |WHERE scaAuthId = ?
    """.trimMargin(), mapper, 1) {
      bindString(0, scaAuthId)
    }

    override fun toString(): String = "SystemConfigAuth.sq:selectByAuthId"
  }
}
