package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.Clazz
import com.ustadmobile.lib.db.entities.ClazzInvite
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.coroutines.flow.first
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzInviteDao.findInviteAsync_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _result_findInviteAsync = findInviteAsync(
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findInviteAsync.map {
        _row ->
        DoorReplicationEntity(tableId = 521,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzInvite.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzInviteDao.findClazzInviteEntityForInviteToken_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_inviteTokenUid : String = request.queryParam("inviteTokenUid")?.let {
    json.decodeFromString(String.serializer(), it)
  } ?: ""
  val _result_findClazzInviteEntityForInviteToken = findClazzInviteEntityForInviteToken(
    inviteTokenUid = _arg_inviteTokenUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findClazzInviteEntityForInviteToken?.clazzInvite?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 521,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzInvite.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun ClazzInviteDao.findClazzInviteEntityForInviteTokenAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_inviteTokenUid : String = request.queryParam("inviteTokenUid")?.let {
    json.decodeFromString(String.serializer(), it)
  } ?: ""
  val _result_findClazzInviteEntityForInviteTokenAsFlow = findClazzInviteEntityForInviteTokenAsFlow(
    inviteTokenUid = _arg_inviteTokenUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findClazzInviteEntityForInviteTokenAsFlow?.clazzInvite?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 521,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzInvite.serializer(), _row).jsonObject,
        )
      )
    }
    _result_findClazzInviteEntityForInviteTokenAsFlow?.clazz?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 6,
          orUid = 0,
          entity = json.encodeToJsonElement(Clazz.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend fun ClazzInviteDao.updateInviteStatus_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_status : Int = request.queryParam("status")?.let {
    json.decodeFromString(Int.serializer(), it)
  } ?: 0
  val _arg_ciUid : Long = request.queryParam("ciUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_updateTime : Long = request.queryParam("updateTime")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_updateInviteStatus = updateInviteStatus(
    status = _arg_status,
    ciUid = _arg_ciUid,
    updateTime = _arg_updateTime,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
