package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.ClazzEnrolment
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmission
import com.ustadmobile.lib.db.entities.CourseGroupMember
import com.ustadmobile.lib.db.entities.PeerReviewerAllocation
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.coroutines.flow.first
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseAssignmentSubmissionDao.getAllSubmissionsFromSubmitterAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_submitterUid : Long = request.queryParam("submitterUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_getAllSubmissionsFromSubmitterAsFlow = getAllSubmissionsFromSubmitterAsFlow(
    submitterUid = _arg_submitterUid,
    assignmentUid = _arg_assignmentUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_getAllSubmissionsFromSubmitterAsFlow.map {
        _row ->
        DoorReplicationEntity(tableId = 522,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseAssignmentSubmission.serializer(),
              _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseAssignmentSubmissionDao.getLatestSubmissionForUserAsync_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_getLatestSubmissionForUserAsync = getLatestSubmissionForUserAsync(
    accountPersonUid = _arg_accountPersonUid,
    assignmentUid = _arg_assignmentUid,
  )
  val _result_findEnrolmentsByPersonUidAndAssignmentUid =
      request.db.doorWrapper.getDaoByClass(ClazzAssignmentDao::class).findEnrolmentsByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findCourseGroupMembersByPersonUidAndAssignmentUid =
      request.db.doorWrapper.getDaoByClass(ClazzAssignmentDao::class).findCourseGroupMembersByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findPeerReviewerAllocationsByPersonUidAndAssignmentUid =
      request.db.doorWrapper.getDaoByClass(ClazzAssignmentDao::class).findPeerReviewerAllocationsByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_getLatestSubmissionForUserAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 522,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseAssignmentSubmission.serializer(),
              _row).jsonObject,
        )
      )
    }
    addAll(
      _result_findEnrolmentsByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 65,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_findCourseGroupMembersByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 243,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseGroupMember.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_findPeerReviewerAllocationsByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 140,
          orUid = 0,
          entity = json.encodeToJsonElement(PeerReviewerAllocation.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseAssignmentSubmissionDao.findByUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_submissionUid : Long = request.queryParam("submissionUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAsFlow = findByUidAsFlow(
    submissionUid = _arg_submissionUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAsFlow?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 522,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseAssignmentSubmission.serializer(),
              _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseAssignmentSubmissionDao.findByAssignmentUidAndAccountPersonUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByAssignmentUidAndAccountPersonUid = findByAssignmentUidAndAccountPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    assignmentUid = _arg_assignmentUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findByAssignmentUidAndAccountPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 522,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseAssignmentSubmission.serializer(),
              _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
