package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLangName
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLanguage
import kotlin.IllegalStateException
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class ContentEntryRelatedEntryJoinDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: ContentEntryRelatedEntryJoinDao,
) : ContentEntryRelatedEntryJoinDao() {
  override fun publicContentEntryRelatedEntryJoins(): List<ContentEntryRelatedEntryJoin> = throw
      IllegalStateException("publicContentEntryRelatedEntryJoins: synchronous db access is NOT possible on Javascript!")

  override fun findPrimaryByTranslation(contentEntryUid: Long): ContentEntryRelatedEntryJoin? =
      throw
      IllegalStateException("findPrimaryByTranslation: synchronous db access is NOT possible on Javascript!")

  override suspend fun findAllTranslationsForContentEntryAsync(contentEntryUid: Long):
      List<ContentEntryRelatedEntryJoinWithLangName> =
      _dao.findAllTranslationsForContentEntryAsync(contentEntryUid)

  override fun findAllTranslationsWithContentEntryUid(contentEntryUid: Long):
      PagingSource<Int, ContentEntryRelatedEntryJoinWithLanguage> =
      _dao.findAllTranslationsWithContentEntryUid(contentEntryUid)

  override fun update(entity: ContentEntryRelatedEntryJoin): Unit = throw
      IllegalStateException("update: synchronous db access is NOT possible on Javascript!")

  public override fun insert(entity: ContentEntryRelatedEntryJoin): Long = throw
      IllegalStateException("insert: synchronous db access is NOT possible on Javascript!")

  public override suspend fun insertAsync(entity: ContentEntryRelatedEntryJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.cerejUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(8)
      entity.cerejUid = _newPk
    }
    entity.cerejLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.cerejUid
  }

  public override fun insertList(entityList: List<ContentEntryRelatedEntryJoin>): Unit = throw
      IllegalStateException("insertList: synchronous db access is NOT possible on Javascript!")
}
