package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.CourseTerminology
import kotlin.IllegalStateException
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class CourseTerminologyDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: CourseTerminologyDao,
) : CourseTerminologyDao() {
  override fun findAllCourseTerminologyPagingSource(): PagingSource<Int, CourseTerminology> =
      _dao.findAllCourseTerminologyPagingSource()

  override fun findAllCourseTerminologyList(): List<CourseTerminology> = throw
      IllegalStateException("findAllCourseTerminologyList: synchronous db access is NOT possible on Javascript!")

  override suspend fun getTerminologyForClazz(clazzUid: Long): CourseTerminology? =
      _dao.getTerminologyForClazz(clazzUid)

  override suspend fun getTerminologyForAssignment(assignmentUid: Long): CourseTerminology? =
      _dao.getTerminologyForAssignment(assignmentUid)

  override suspend fun findByUidAsync(uid: Long): CourseTerminology? = _dao.findByUidAsync(uid)

  override suspend fun updateAsync(entity: CourseTerminology): Int {
    entity.ctLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    return _dao.updateAsync(entity)
  }

  override suspend fun upsertAsync(entity: CourseTerminology): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ctUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(450)
      entity.ctUid = _newPk
    }
    entity.ctLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.upsertAsync(entity)
    return entity.ctUid
  }

  public override fun insert(entity: CourseTerminology): Long = throw
      IllegalStateException("insert: synchronous db access is NOT possible on Javascript!")

  public override suspend fun insertAsync(entity: CourseTerminology): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ctUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(450)
      entity.ctUid = _newPk
    }
    entity.ctLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.ctUid
  }

  public override fun insertList(entityList: List<CourseTerminology>): Unit = throw
      IllegalStateException("insertList: synchronous db access is NOT possible on Javascript!")

  public override fun update(entity: CourseTerminology): Unit = throw
      IllegalStateException("update: synchronous db access is NOT possible on Javascript!")
}
