/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/runtime/lint/ComposableNamingDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UMethod;", "Companion", "runtime-lint"})
public final class ComposableNamingDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ComposableNaming = Issue.Companion.create("ComposableNaming", "Incorrect naming for @Composable functions", "@Composable functions without a return type should use similar naming to classes, starting with an uppercase letter and ending with a noun. @Composable functions with a return type should be treated as normal Kotlin functions, starting with a lowercase letter.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ComposableNamingDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<UMethod>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UMethod.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            /*
             * WARNING - void declaration
             */
            public void visitMethod(@NotNull UMethod node) {
                if (!ComposableUtilsKt.isComposable((PsiMethod)node)) {
                    return;
                }
                if (this.$context.getEvaluator().isOperator((PsiModifierListOwner)node)) {
                    return;
                }
                if (!(node.findSuperMethods().length == 0)) {
                    return;
                }
                String name = node.getName();
                boolean capitalizedFunctionName = Character.isUpperCase(StringsKt.first((CharSequence)name));
                if (PsiUtilsKt.getReturnsUnit((PsiMethod)node)) {
                    if (!capitalizedFunctionName) {
                        String string;
                        String string2 = name;
                        if (((CharSequence)string2).length() > 0) {
                            void it22;
                            char c = string2.charAt(0);
                            StringBuilder stringBuilder = new StringBuilder();
                            int n = 0;
                            StringBuilder stringBuilder2 = stringBuilder.append((Object)(Character.isLowerCase((char)it22) ? CharsKt.titlecase((char)it22, (Locale)Locale.getDefault()) : String.valueOf((char)it22)));
                            String it22 = string2;
                            n = 1;
                            String string3 = it22.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                            string = stringBuilder2.append(string3).toString();
                        } else {
                            string = string2;
                        }
                        String capitalizedName = string;
                        this.$context.report(ComposableNamingDetector.Companion.getComposableNaming(), node, this.$context.getNameLocation(node), "Composable functions that return Unit should start with an uppercase letter", LintFix.Companion.create().replace().name("Change to " + capitalizedName).text(name).with(capitalizedName).autoFix().build());
                    }
                } else if (capitalizedFunctionName) {
                    String string;
                    String string4 = name;
                    if (((CharSequence)string4).length() > 0) {
                        char it22 = string4.charAt(0);
                        StringBuilder stringBuilder = new StringBuilder();
                        boolean bl = false;
                        StringBuilder stringBuilder3 = stringBuilder.append((Object)CharsKt.lowercase((char)it22, (Locale)Locale.getDefault()));
                        String string5 = string4;
                        int n = 1;
                        String string6 = string5.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        string = stringBuilder3.append(string6).toString();
                    } else {
                        string = string4;
                    }
                    String lowercaseName = string;
                    this.$context.report(ComposableNamingDetector.Companion.getComposableNaming(), node, this.$context.getNameLocation(node), "Composable functions with a return type should start with a lowercase letter", LintFix.Companion.create().replace().name("Change to " + lowercaseName).text(name).with(lowercaseName).autoFix().build());
                }
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/runtime/lint/ComposableNamingDetector$Companion;", "", "()V", "ComposableNaming", "Lcom/android/tools/lint/detector/api/Issue;", "getComposableNaming", "()Lcom/android/tools/lint/detector/api/Issue;", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getComposableNaming() {
            return ComposableNaming;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

