/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.runtime.lint.MutableCollectionMutableStateDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeProjection;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/runtime/lint/MutableCollectionMutableStateDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "runtime-lint"})
@SourceDebugExtension(value={"SMAP\nMutableCollectionMutableStateDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableCollectionMutableStateDetector.kt\nandroidx/compose/runtime/lint/MutableCollectionMutableStateDetector\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n*L\n1#1,152:1\n26#2,2:153\n56#3:155\n70#3,8:156\n*S KotlinDebug\n*F\n+ 1 MutableCollectionMutableStateDetector.kt\nandroidx/compose/runtime/lint/MutableCollectionMutableStateDetector\n*L\n61#1:153,2\n61#1:155\n61#1:156,8\n*E\n"})
public final class MutableCollectionMutableStateDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue MutableCollectionMutableState = Issue.Companion.create("MutableCollectionMutableState", "Creating a MutableState object with a mutable collection type", "Writes to mutable collections inside a MutableState will not cause a recomposition - only writes to the MutableState itself will. In most cases you should either use a read-only collection (such as List or Map) and assign a new instance to the MutableState when your data changes, or you can use an snapshot-backed collection such as SnapshotStateList or SnapshotStateMap which will correctly cause a recomposition when their contents are modified.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(MutableCollectionMutableStateDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)Names.Runtime.INSTANCE.getMutableStateOf().getShortName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        if (!PsiUtilsKt.isInPackageName(method, Names.Runtime.INSTANCE.getPackageName())) {
            return;
        }
        PsiElement psiElement = node.getSourcePsi();
        KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
        if (ktExpression == null) {
            return;
        }
        KtExpression expression = ktExpression;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)expression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        psiElement = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyse = false;
        void var8_8 = this_$iv$iv;
        KaSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv$iv, (KtElement)expression);
        try {
            KaClassType kaClassType;
            KaSession $this$visitMethodCall_u24lambda_u240 = analysisSession$iv$iv$iv;
            boolean bl = false;
            KaType kaType = $this$visitMethodCall_u24lambda_u240.getKtType(expression);
            if ((kaType instanceof KaClassType ? (KaClassType)kaType : null) == null) {
                return;
            }
            KaClassType expressionType = kaClassType;
            KaTypeProjection kaTypeProjection = (KaTypeProjection)CollectionsKt.firstOrNull((List)expressionType.getOwnTypeArguments());
            if (kaTypeProjection == null || (kaTypeProjection = kaTypeProjection.getType()) == null) {
                return;
            }
            KaTypeProjection type = kaTypeProjection;
            if (MutableCollectionMutableStateDetectorKt.access$isMutableCollection($this$visitMethodCall_u24lambda_u240, (KaType)type)) {
                JavaContext.report$default((JavaContext)context, (Issue)MutableCollectionMutableState, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)"Creating a MutableState object with a mutable collection type", null, (int)16, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv$iv, (KtElement)expression);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/runtime/lint/MutableCollectionMutableStateDetector$Companion;", "", "()V", "MutableCollectionMutableState", "Lcom/android/tools/lint/detector/api/Issue;", "getMutableCollectionMutableState", "()Lcom/android/tools/lint/detector/api/Issue;", "runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getMutableCollectionMutableState() {
            return MutableCollectionMutableState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

