/*
 * Decompiled with CFR 0.152.
 */
package dev.icerock.moko.resources;

import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import dev.icerock.moko.resources.ClassLoaderExtKt;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J5\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Ldev/icerock/moko/resources/PluralsResource;", "", "resourcesClassLoader", "Ljava/lang/ClassLoader;", "bundleName", "", "key", "(Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/lang/String;)V", "getBundleName", "()Ljava/lang/String;", "getKey", "getResourcesClassLoader", "()Ljava/lang/ClassLoader;", "getPluralMessage", "locale", "Ljava/util/Locale;", "quantity", "", "localized", "args", "", "(Ljava/util/Locale;I[Ljava/lang/Object;)Ljava/lang/String;", "resources"})
public final class PluralsResource {
    @NotNull
    private final ClassLoader resourcesClassLoader;
    @NotNull
    private final String bundleName;
    @NotNull
    private final String key;

    public PluralsResource(@NotNull ClassLoader resourcesClassLoader, @NotNull String bundleName, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)resourcesClassLoader, (String)"resourcesClassLoader");
        Intrinsics.checkNotNullParameter((Object)bundleName, (String)"bundleName");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.resourcesClassLoader = resourcesClassLoader;
        this.bundleName = bundleName;
        this.key = key;
    }

    @NotNull
    public final ClassLoader getResourcesClassLoader() {
        return this.resourcesClassLoader;
    }

    @NotNull
    public final String getBundleName() {
        return this.bundleName;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    private final String getPluralMessage(Locale locale, int quantity) {
        ResourceBundle resourceBundle = ClassLoaderExtKt.getResourceBundle(this.resourcesClassLoader, this.bundleName, locale);
        PluralRules pluralRules = PluralRules.forLocale((ULocale)ULocale.forLocale((Locale)locale));
        String selectedVariant = pluralRules.select((double)quantity);
        String keyWithQuantity = this.key + "." + selectedVariant;
        String string = resourceBundle.getString(keyWithQuantity);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resourceBundle.getString(keyWithQuantity)");
        return string;
    }

    @NotNull
    public final String localized(@NotNull Locale locale, int quantity) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.getPluralMessage(locale, quantity);
    }

    public static /* synthetic */ String localized$default(PluralsResource pluralsResource, Locale locale, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return pluralsResource.localized(locale, n);
    }

    @NotNull
    public final String localized(@NotNull Locale locale, int quantity, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = this.getPluralMessage(locale, quantity);
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        return string2;
    }

    public static /* synthetic */ String localized$default(PluralsResource pluralsResource, Locale locale, int n, Object[] objectArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return pluralsResource.localized(locale, n, objectArray);
    }
}

