/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentPool;
import kotlinx.io._UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a&\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u001c\u0010\u000e\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\b\u001a\u0012\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0010\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\r\u001a\u001a\u0010\u0014\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\b\u001a$\u0010\u0014\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"asByteChannel", "Ljava/nio/channels/ByteChannel;", "Lkotlinx/io/Buffer;", "copyTo", "", "out", "Ljava/io/OutputStream;", "startIndex", "", "endIndex", "readAtMostTo", "", "sink", "Ljava/nio/ByteBuffer;", "readTo", "byteCount", "transferFrom", "input", "Ljava/io/InputStream;", "source", "write", "forever", "", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nBuffersJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuffersJvm.kt\nkotlinx/io/BuffersJvmKt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n52#2:219\n53#2:221\n109#2:222\n109#2:223\n112#2:224\n1#3:220\n*S KotlinDebug\n*F\n+ 1 BuffersJvm.kt\nkotlinx/io/BuffersJvmKt\n*L\n55#1:219\n55#1:221\n64#1:222\n97#1:223\n147#1:224\n55#1:220\n*E\n"})
public final class BuffersJvmKt {
    @NotNull
    public static final Buffer transferFrom(@NotNull Buffer $this$transferFrom, @NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)$this$transferFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        BuffersJvmKt.write($this$transferFrom, input, Long.MAX_VALUE, true);
        return $this$transferFrom;
    }

    @NotNull
    public static final Buffer write(@NotNull Buffer $this$write, @NotNull InputStream input, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        BuffersJvmKt.write($this$write, input, byteCount, false);
        return $this$write;
    }

    private static final void write(Buffer $this$write, InputStream input, long byteCount, boolean forever) {
        int bytesRead;
        for (long remainingByteCount = byteCount; remainingByteCount > 0L || forever; remainingByteCount -= (long)bytesRead) {
            Segment tail = $this$write.writableSegment$kotlinx_io_core(1);
            int b$iv = 8192 - tail.limit;
            boolean $i$f$minOf = false;
            int maxToCopy = (int)Math.min(remainingByteCount, (long)b$iv);
            bytesRead = input.read(tail.data, tail.limit, maxToCopy);
            if (bytesRead == -1) {
                if (tail.pos == tail.limit) {
                    $this$write.head = tail.pop();
                    SegmentPool.recycle(tail);
                }
                if (forever) {
                    return;
                }
                throw new EOFException("Stream exhausted before " + byteCount + " bytes were read.");
            }
            tail.limit += bytesRead;
            $this$write.setSize$kotlinx_io_core($this$write.getSize() + (long)bytesRead);
        }
    }

    public static final void readTo(@NotNull Buffer $this$readTo, @NotNull OutputStream out, long byteCount) {
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)$this$readTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        _UtilKt.checkOffsetAndCount($this$readTo.getSize(), 0L, byteCount);
        Segment s = $this$readTo.head;
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= (long)toCopy) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            int b$iv22 = segment.limit - s.pos;
            boolean $i$f$minOf = false;
            toCopy = (int)Math.min(remainingByteCount, (long)b$iv22);
            out.write(s.data, s.pos, toCopy);
            Segment b$iv22 = s;
            b$iv22.pos += toCopy;
            $this$readTo.setSize$kotlinx_io_core($this$readTo.getSize() - (long)toCopy);
            if (s.pos != s.limit) continue;
            Segment toRecycle = s;
            $this$readTo.head = s = toRecycle.pop();
            SegmentPool.recycle(toRecycle);
        }
    }

    public static /* synthetic */ void readTo$default(Buffer buffer, OutputStream outputStream, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = buffer.getSize();
        }
        BuffersJvmKt.readTo(buffer, outputStream, l);
    }

    public static final void copyTo(@NotNull Buffer $this$copyTo, @NotNull OutputStream out, long startIndex, long endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        _UtilKt.checkBounds($this$copyTo.getSize(), startIndex, endIndex);
        if (startIndex == endIndex) {
            return;
        }
        long currentOffset = startIndex;
        long remainingByteCount = endIndex - startIndex;
        Segment s = $this$copyTo.head;
        while (true) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            if (currentOffset < (long)(segment.limit - s.pos)) break;
            currentOffset -= (long)(s.limit - s.pos);
            s = s.next;
        }
        while (remainingByteCount > 0L) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            int pos = (int)((long)segment.pos + currentOffset);
            int a$iv = s.limit - pos;
            boolean $i$f$minOf = false;
            int toCopy = (int)Math.min((long)a$iv, remainingByteCount);
            out.write(s.data, pos, toCopy);
            remainingByteCount -= (long)toCopy;
            currentOffset = 0L;
            s = s.next;
        }
    }

    public static /* synthetic */ void copyTo$default(Buffer buffer, OutputStream outputStream, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = buffer.getSize();
        }
        BuffersJvmKt.copyTo(buffer, outputStream, l, l2);
    }

    public static final int readAtMostTo(@NotNull Buffer $this$readAtMostTo, @NotNull ByteBuffer sink) {
        Intrinsics.checkNotNullParameter((Object)$this$readAtMostTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Segment segment = $this$readAtMostTo.head;
        if (segment == null) {
            return -1;
        }
        Segment s = segment;
        int toCopy = Math.min(sink.remaining(), s.limit - s.pos);
        sink.put(s.data, s.pos, toCopy);
        s.pos += toCopy;
        $this$readAtMostTo.setSize$kotlinx_io_core($this$readAtMostTo.getSize() - (long)toCopy);
        if (s.pos == s.limit) {
            $this$readAtMostTo.head = s.pop();
            SegmentPool.recycle(s);
        }
        return toCopy;
    }

    @NotNull
    public static final Buffer transferFrom(@NotNull Buffer $this$transferFrom, @NotNull ByteBuffer source) {
        int byteCount;
        Intrinsics.checkNotNullParameter((Object)$this$transferFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int remaining = byteCount = source.remaining();
        while (remaining > 0) {
            Segment tail = $this$transferFrom.writableSegment$kotlinx_io_core(1);
            int toCopy = Math.min(remaining, 8192 - tail.limit);
            source.get(tail.data, tail.limit, toCopy);
            remaining -= toCopy;
            tail.limit += toCopy;
        }
        $this$transferFrom.setSize$kotlinx_io_core($this$transferFrom.getSize() + (long)byteCount);
        return $this$transferFrom;
    }

    @NotNull
    public static final ByteChannel asByteChannel(@NotNull Buffer $this$asByteChannel) {
        Intrinsics.checkNotNullParameter((Object)$this$asByteChannel, (String)"<this>");
        return new ByteChannel($this$asByteChannel){
            final /* synthetic */ Buffer $this_asByteChannel;
            {
                this.$this_asByteChannel = $receiver;
            }

            public int read(@NotNull ByteBuffer sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                return BuffersJvmKt.readAtMostTo(this.$this_asByteChannel, sink);
            }

            public int write(@NotNull ByteBuffer source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                long sizeBefore = this.$this_asByteChannel.getSize();
                BuffersJvmKt.transferFrom(this.$this_asByteChannel, source);
                return (int)(this.$this_asByteChannel.getSize() - sizeBefore);
            }

            public void close() {
            }

            public boolean isOpen() {
                return true;
            }
        };
    }
}

