/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.bramp.ffmpeg.ProcessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunProcessFunction
implements ProcessFunction {
    static final Logger LOG = LoggerFactory.getLogger(RunProcessFunction.class);
    File workingDirectory;

    @Override
    public Process run(List<String> args) throws IOException {
        Preconditions.checkNotNull(args, (Object)"Arguments must not be null");
        Preconditions.checkArgument((!args.isEmpty() ? 1 : 0) != 0, (Object)"No arguments specified");
        if (LOG.isInfoEnabled()) {
            LOG.info("{}", (Object)Joiner.on((String)" ").join(args));
        }
        ProcessBuilder builder = new ProcessBuilder(args);
        if (this.workingDirectory != null) {
            builder.directory(this.workingDirectory);
        }
        builder.redirectErrorStream(true);
        return builder.start();
    }

    public RunProcessFunction setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = new File(workingDirectory);
        return this;
    }

    public RunProcessFunction setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }
}

