package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.CourseAssignmentMarkAndMarkerName;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.AverageCourseAssignmentMark;
import com.ustadmobile.lib.db.entities.CourseAssignmentMark;
import com.ustadmobile.lib.db.entities.CourseAssignmentMarkWithPersonMarker;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseAssignmentMarkDao_Impl extends CourseAssignmentMarkDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseAssignmentMark> __insertionAdapterOfCourseAssignmentMark;

  private final EntityDeletionOrUpdateAdapter<CourseAssignmentMark> __updateAdapterOfCourseAssignmentMark;

  public CourseAssignmentMarkDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseAssignmentMark = new EntityInsertionAdapter<CourseAssignmentMark>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `CourseAssignmentMark` (`camUid`,`camAssignmentUid`,`camSubmitterUid`,`camMarkerSubmitterUid`,`camMarkerPersonUid`,`camMarkerComment`,`camMark`,`camMaxMark`,`camPenalty`,`camLct`,`camClazzUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseAssignmentMark entity) {
        statement.bindLong(1, entity.getCamUid());
        statement.bindLong(2, entity.getCamAssignmentUid());
        statement.bindLong(3, entity.getCamSubmitterUid());
        statement.bindLong(4, entity.getCamMarkerSubmitterUid());
        statement.bindLong(5, entity.getCamMarkerPersonUid());
        if (entity.getCamMarkerComment() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCamMarkerComment());
        }
        statement.bindDouble(7, entity.getCamMark());
        statement.bindDouble(8, entity.getCamMaxMark());
        statement.bindDouble(9, entity.getCamPenalty());
        statement.bindLong(10, entity.getCamLct());
        statement.bindLong(11, entity.getCamClazzUid());
      }
    };
    this.__updateAdapterOfCourseAssignmentMark = new EntityDeletionOrUpdateAdapter<CourseAssignmentMark>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `CourseAssignmentMark` SET `camUid` = ?,`camAssignmentUid` = ?,`camSubmitterUid` = ?,`camMarkerSubmitterUid` = ?,`camMarkerPersonUid` = ?,`camMarkerComment` = ?,`camMark` = ?,`camMaxMark` = ?,`camPenalty` = ?,`camLct` = ?,`camClazzUid` = ? WHERE `camUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseAssignmentMark entity) {
        statement.bindLong(1, entity.getCamUid());
        statement.bindLong(2, entity.getCamAssignmentUid());
        statement.bindLong(3, entity.getCamSubmitterUid());
        statement.bindLong(4, entity.getCamMarkerSubmitterUid());
        statement.bindLong(5, entity.getCamMarkerPersonUid());
        if (entity.getCamMarkerComment() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getCamMarkerComment());
        }
        statement.bindDouble(7, entity.getCamMark());
        statement.bindDouble(8, entity.getCamMaxMark());
        statement.bindDouble(9, entity.getCamPenalty());
        statement.bindLong(10, entity.getCamLct());
        statement.bindLong(11, entity.getCamClazzUid());
        statement.bindLong(12, entity.getCamUid());
      }
    };
  }

  @Override
  public long insert(final CourseAssignmentMark entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfCourseAssignmentMark.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseAssignmentMark entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfCourseAssignmentMark.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends CourseAssignmentMark> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseAssignmentMark.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final CourseAssignmentMark entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseAssignmentMark.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Flow<Boolean> checkNoSubmissionsMarked(final long assignmentUid) {
    final String _sql = "\n"
            + "        SELECT NOT EXISTS(SELECT 1\n"
            + "                        FROM CourseAssignmentMark\n"
            + "                       WHERE CourseAssignmentMark.camAssignmentUid = ?\n"
            + "                       LIMIT 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentMark"}, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<AverageCourseAssignmentMark> getMarkOfAssignmentForSubmitterLiveData(
      final long assignmentUid, final long submitterUid) {
    final String _sql = "\n"
            + "         WITH ScoreByMarker (averageScore, averagePenalty) AS (\n"
            + "                 SELECT AVG(camMark), AVG(camPenalty)\n"
            + "                   FROM courseAssignmentMark\n"
            + "                        JOIN ClazzAssignment\n"
            + "                        ON caUid = courseAssignmentMark.camAssignmentUid         \n"
            + "                    AND camAssignmentUid = ?\n"
            + "                    AND camSubmitterUid = ?\n"
            + "                  WHERE camLct = (SELECT MAX(mark.camLct) \n"
            + "                                    FROM CourseAssignmentMark As mark\n"
            + "                                    WHERE mark.camAssignmentUid = ?\n"
            + "                                     AND mark.camSubmitterUid = ?\n"
            + "                                     AND (caMarkingType = 1\n"
            + "                                       OR mark.camMarkerSubmitterUid = courseAssignmentMark.camMarkerSubmitterUid))\n"
            + "                )                       \n"
            + "\n"
            + "         SELECT COALESCE(averageScore, -1) AS averageScore, COALESCE(averagePenalty, -1) AS averagePenalty\n"
            + "           FROM ScoreByMarker\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, submitterUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"courseAssignmentMark",
        "ClazzAssignment", "CourseAssignmentMark"}, new Callable<AverageCourseAssignmentMark>() {
      @Override
      @Nullable
      public AverageCourseAssignmentMark call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfAverageScore = 0;
          final int _cursorIndexOfAveragePenalty = 1;
          final AverageCourseAssignmentMark _result;
          if (_cursor.moveToFirst()) {
            _result = new AverageCourseAssignmentMark();
            final float _tmpAverageScore;
            _tmpAverageScore = _cursor.getFloat(_cursorIndexOfAverageScore);
            _result.setAverageScore(_tmpAverageScore);
            final int _tmpAveragePenalty;
            _tmpAveragePenalty = _cursor.getInt(_cursorIndexOfAveragePenalty);
            _result.setAveragePenalty(_tmpAveragePenalty);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<CourseAssignmentMarkAndMarkerName>> getAllMarksForUserAsFlow(
      final long accountPersonUid, final long assignmentUid) {
    final String _sql = "\n"
            + "        SELECT CourseAssignmentMark.*,\n"
            + "               Person.firstNames AS markerFirstNames,\n"
            + "               Person.lastName AS markerLastName,\n"
            + "               PersonPicture.personPictureThumbnailUri AS markerPictureUri\n"
            + "          FROM CourseAssignmentMark\n"
            + "               LEFT JOIN Person\n"
            + "                         ON Person.personUid = CourseAssignmentMark.camMarkerPersonUid\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = CourseAssignmentMark.camMarkerPersonUid\n"
            + "         WHERE (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    ) > 0\n"
            + "           AND CourseAssignmentMark.camAssignmentUid = ?\n"
            + "           AND CourseAssignmentMark.camSubmitterUid = (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    )\n"
            + "      ORDER BY CourseAssignmentMark.camLct DESC    \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 21);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 19;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 21;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentMark", "Person",
        "PersonPicture", "ClazzAssignment", "ClazzEnrolment",
        "CourseGroupMember"}, new Callable<List<CourseAssignmentMarkAndMarkerName>>() {
      @Override
      @NonNull
      public List<CourseAssignmentMarkAndMarkerName> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camUid");
          final int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camAssignmentUid");
          final int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camSubmitterUid");
          final int _cursorIndexOfCamMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerSubmitterUid");
          final int _cursorIndexOfCamMarkerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerPersonUid");
          final int _cursorIndexOfCamMarkerComment = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerComment");
          final int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow(_cursor, "camMark");
          final int _cursorIndexOfCamMaxMark = CursorUtil.getColumnIndexOrThrow(_cursor, "camMaxMark");
          final int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "camPenalty");
          final int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow(_cursor, "camLct");
          final int _cursorIndexOfCamClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camClazzUid");
          final int _cursorIndexOfMarkerFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "markerFirstNames");
          final int _cursorIndexOfMarkerLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "markerLastName");
          final int _cursorIndexOfMarkerPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "markerPictureUri");
          final List<CourseAssignmentMarkAndMarkerName> _result = new ArrayList<CourseAssignmentMarkAndMarkerName>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseAssignmentMarkAndMarkerName _item;
            final String _tmpMarkerFirstNames;
            if (_cursor.isNull(_cursorIndexOfMarkerFirstNames)) {
              _tmpMarkerFirstNames = null;
            } else {
              _tmpMarkerFirstNames = _cursor.getString(_cursorIndexOfMarkerFirstNames);
            }
            final String _tmpMarkerLastName;
            if (_cursor.isNull(_cursorIndexOfMarkerLastName)) {
              _tmpMarkerLastName = null;
            } else {
              _tmpMarkerLastName = _cursor.getString(_cursorIndexOfMarkerLastName);
            }
            final String _tmpMarkerPictureUri;
            if (_cursor.isNull(_cursorIndexOfMarkerPictureUri)) {
              _tmpMarkerPictureUri = null;
            } else {
              _tmpMarkerPictureUri = _cursor.getString(_cursorIndexOfMarkerPictureUri);
            }
            final CourseAssignmentMark _tmpCourseAssignmentMark;
            if (!(_cursor.isNull(_cursorIndexOfCamUid) && _cursor.isNull(_cursorIndexOfCamAssignmentUid) && _cursor.isNull(_cursorIndexOfCamSubmitterUid) && _cursor.isNull(_cursorIndexOfCamMarkerSubmitterUid) && _cursor.isNull(_cursorIndexOfCamMarkerPersonUid) && _cursor.isNull(_cursorIndexOfCamMarkerComment) && _cursor.isNull(_cursorIndexOfCamMark) && _cursor.isNull(_cursorIndexOfCamMaxMark) && _cursor.isNull(_cursorIndexOfCamPenalty) && _cursor.isNull(_cursorIndexOfCamLct) && _cursor.isNull(_cursorIndexOfCamClazzUid))) {
              _tmpCourseAssignmentMark = new CourseAssignmentMark();
              final long _tmpCamUid;
              _tmpCamUid = _cursor.getLong(_cursorIndexOfCamUid);
              _tmpCourseAssignmentMark.setCamUid(_tmpCamUid);
              final long _tmpCamAssignmentUid;
              _tmpCamAssignmentUid = _cursor.getLong(_cursorIndexOfCamAssignmentUid);
              _tmpCourseAssignmentMark.setCamAssignmentUid(_tmpCamAssignmentUid);
              final long _tmpCamSubmitterUid;
              _tmpCamSubmitterUid = _cursor.getLong(_cursorIndexOfCamSubmitterUid);
              _tmpCourseAssignmentMark.setCamSubmitterUid(_tmpCamSubmitterUid);
              final long _tmpCamMarkerSubmitterUid;
              _tmpCamMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfCamMarkerSubmitterUid);
              _tmpCourseAssignmentMark.setCamMarkerSubmitterUid(_tmpCamMarkerSubmitterUid);
              final long _tmpCamMarkerPersonUid;
              _tmpCamMarkerPersonUid = _cursor.getLong(_cursorIndexOfCamMarkerPersonUid);
              _tmpCourseAssignmentMark.setCamMarkerPersonUid(_tmpCamMarkerPersonUid);
              final String _tmpCamMarkerComment;
              if (_cursor.isNull(_cursorIndexOfCamMarkerComment)) {
                _tmpCamMarkerComment = null;
              } else {
                _tmpCamMarkerComment = _cursor.getString(_cursorIndexOfCamMarkerComment);
              }
              _tmpCourseAssignmentMark.setCamMarkerComment(_tmpCamMarkerComment);
              final float _tmpCamMark;
              _tmpCamMark = _cursor.getFloat(_cursorIndexOfCamMark);
              _tmpCourseAssignmentMark.setCamMark(_tmpCamMark);
              final float _tmpCamMaxMark;
              _tmpCamMaxMark = _cursor.getFloat(_cursorIndexOfCamMaxMark);
              _tmpCourseAssignmentMark.setCamMaxMark(_tmpCamMaxMark);
              final float _tmpCamPenalty;
              _tmpCamPenalty = _cursor.getFloat(_cursorIndexOfCamPenalty);
              _tmpCourseAssignmentMark.setCamPenalty(_tmpCamPenalty);
              final long _tmpCamLct;
              _tmpCamLct = _cursor.getLong(_cursorIndexOfCamLct);
              _tmpCourseAssignmentMark.setCamLct(_tmpCamLct);
              final long _tmpCamClazzUid;
              _tmpCamClazzUid = _cursor.getLong(_cursorIndexOfCamClazzUid);
              _tmpCourseAssignmentMark.setCamClazzUid(_tmpCamClazzUid);
            } else {
              _tmpCourseAssignmentMark = null;
            }
            _item = new CourseAssignmentMarkAndMarkerName(_tmpCourseAssignmentMark,_tmpMarkerFirstNames,_tmpMarkerLastName,_tmpMarkerPictureUri);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<CourseAssignmentMarkAndMarkerName>> getAllMarksForSubmitterAsFlow(
      final long submitterUid, final long assignmentUid) {
    final String _sql = "\n"
            + "        SELECT CourseAssignmentMark.*,\n"
            + "               Person.firstNames AS markerFirstNames,\n"
            + "               Person.lastName AS markerLastName,\n"
            + "               PersonPicture.personPictureThumbnailUri AS markerPictureUri\n"
            + "          FROM CourseAssignmentMark\n"
            + "               LEFT JOIN Person\n"
            + "                         ON Person.personUid = CourseAssignmentMark.camMarkerPersonUid\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = CourseAssignmentMark.camMarkerPersonUid\n"
            + "         WHERE CourseAssignmentMark.camAssignmentUid = ?\n"
            + "           AND CourseAssignmentMark.camSubmitterUid = ?\n"
            + "      ORDER BY CourseAssignmentMark.camLct DESC                             \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"CourseAssignmentMark", "Person",
        "PersonPicture"}, new Callable<List<CourseAssignmentMarkAndMarkerName>>() {
      @Override
      @NonNull
      public List<CourseAssignmentMarkAndMarkerName> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camUid");
          final int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camAssignmentUid");
          final int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camSubmitterUid");
          final int _cursorIndexOfCamMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerSubmitterUid");
          final int _cursorIndexOfCamMarkerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerPersonUid");
          final int _cursorIndexOfCamMarkerComment = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerComment");
          final int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow(_cursor, "camMark");
          final int _cursorIndexOfCamMaxMark = CursorUtil.getColumnIndexOrThrow(_cursor, "camMaxMark");
          final int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "camPenalty");
          final int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow(_cursor, "camLct");
          final int _cursorIndexOfCamClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camClazzUid");
          final int _cursorIndexOfMarkerFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "markerFirstNames");
          final int _cursorIndexOfMarkerLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "markerLastName");
          final int _cursorIndexOfMarkerPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "markerPictureUri");
          final List<CourseAssignmentMarkAndMarkerName> _result = new ArrayList<CourseAssignmentMarkAndMarkerName>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CourseAssignmentMarkAndMarkerName _item;
            final String _tmpMarkerFirstNames;
            if (_cursor.isNull(_cursorIndexOfMarkerFirstNames)) {
              _tmpMarkerFirstNames = null;
            } else {
              _tmpMarkerFirstNames = _cursor.getString(_cursorIndexOfMarkerFirstNames);
            }
            final String _tmpMarkerLastName;
            if (_cursor.isNull(_cursorIndexOfMarkerLastName)) {
              _tmpMarkerLastName = null;
            } else {
              _tmpMarkerLastName = _cursor.getString(_cursorIndexOfMarkerLastName);
            }
            final String _tmpMarkerPictureUri;
            if (_cursor.isNull(_cursorIndexOfMarkerPictureUri)) {
              _tmpMarkerPictureUri = null;
            } else {
              _tmpMarkerPictureUri = _cursor.getString(_cursorIndexOfMarkerPictureUri);
            }
            final CourseAssignmentMark _tmpCourseAssignmentMark;
            if (!(_cursor.isNull(_cursorIndexOfCamUid) && _cursor.isNull(_cursorIndexOfCamAssignmentUid) && _cursor.isNull(_cursorIndexOfCamSubmitterUid) && _cursor.isNull(_cursorIndexOfCamMarkerSubmitterUid) && _cursor.isNull(_cursorIndexOfCamMarkerPersonUid) && _cursor.isNull(_cursorIndexOfCamMarkerComment) && _cursor.isNull(_cursorIndexOfCamMark) && _cursor.isNull(_cursorIndexOfCamMaxMark) && _cursor.isNull(_cursorIndexOfCamPenalty) && _cursor.isNull(_cursorIndexOfCamLct) && _cursor.isNull(_cursorIndexOfCamClazzUid))) {
              _tmpCourseAssignmentMark = new CourseAssignmentMark();
              final long _tmpCamUid;
              _tmpCamUid = _cursor.getLong(_cursorIndexOfCamUid);
              _tmpCourseAssignmentMark.setCamUid(_tmpCamUid);
              final long _tmpCamAssignmentUid;
              _tmpCamAssignmentUid = _cursor.getLong(_cursorIndexOfCamAssignmentUid);
              _tmpCourseAssignmentMark.setCamAssignmentUid(_tmpCamAssignmentUid);
              final long _tmpCamSubmitterUid;
              _tmpCamSubmitterUid = _cursor.getLong(_cursorIndexOfCamSubmitterUid);
              _tmpCourseAssignmentMark.setCamSubmitterUid(_tmpCamSubmitterUid);
              final long _tmpCamMarkerSubmitterUid;
              _tmpCamMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfCamMarkerSubmitterUid);
              _tmpCourseAssignmentMark.setCamMarkerSubmitterUid(_tmpCamMarkerSubmitterUid);
              final long _tmpCamMarkerPersonUid;
              _tmpCamMarkerPersonUid = _cursor.getLong(_cursorIndexOfCamMarkerPersonUid);
              _tmpCourseAssignmentMark.setCamMarkerPersonUid(_tmpCamMarkerPersonUid);
              final String _tmpCamMarkerComment;
              if (_cursor.isNull(_cursorIndexOfCamMarkerComment)) {
                _tmpCamMarkerComment = null;
              } else {
                _tmpCamMarkerComment = _cursor.getString(_cursorIndexOfCamMarkerComment);
              }
              _tmpCourseAssignmentMark.setCamMarkerComment(_tmpCamMarkerComment);
              final float _tmpCamMark;
              _tmpCamMark = _cursor.getFloat(_cursorIndexOfCamMark);
              _tmpCourseAssignmentMark.setCamMark(_tmpCamMark);
              final float _tmpCamMaxMark;
              _tmpCamMaxMark = _cursor.getFloat(_cursorIndexOfCamMaxMark);
              _tmpCourseAssignmentMark.setCamMaxMark(_tmpCamMaxMark);
              final float _tmpCamPenalty;
              _tmpCamPenalty = _cursor.getFloat(_cursorIndexOfCamPenalty);
              _tmpCourseAssignmentMark.setCamPenalty(_tmpCamPenalty);
              final long _tmpCamLct;
              _tmpCamLct = _cursor.getLong(_cursorIndexOfCamLct);
              _tmpCourseAssignmentMark.setCamLct(_tmpCamLct);
              final long _tmpCamClazzUid;
              _tmpCamClazzUid = _cursor.getLong(_cursorIndexOfCamClazzUid);
              _tmpCourseAssignmentMark.setCamClazzUid(_tmpCamClazzUid);
            } else {
              _tmpCourseAssignmentMark = null;
            }
            _item = new CourseAssignmentMarkAndMarkerName(_tmpCourseAssignmentMark,_tmpMarkerFirstNames,_tmpMarkerLastName,_tmpMarkerPictureUri);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getAllMarksForSubmitterAsFlowMarkerPersons(final long submitterUid,
      final long assignmentUid, final Continuation<? super List<PersonAndPicture>> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE PersonUid IN\n"
            + "               (SELECT CourseAssignmentMark.camMarkerPersonUid\n"
            + "                  FROM CourseAssignmentMark\n"
            + "                 WHERE CourseAssignmentMark.camAssignmentUid = ?\n"
            + "                   AND CourseAssignmentMark.camSubmitterUid = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonAndPicture>>() {
      @Override
      @NonNull
      public List<PersonAndPicture> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final List<PersonAndPicture> _result = new ArrayList<PersonAndPicture>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PersonAndPicture _item;
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonPicture _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_2 != 0;
              _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPicture = null;
            }
            _item = new PersonAndPicture(_tmpPerson,_tmpPicture);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, CourseAssignmentMarkWithPersonMarker> getAllMarksOfAssignmentForSubmitter(
      final long assignmentUid, final long submitterUid, final int filter) {
    final String _sql = "\n"
            + "          WITH ScoreByMarker AS (\n"
            + "                 SELECT *\n"
            + "                   FROM courseAssignmentMark    \n"
            + "                  WHERE camAssignmentUid = ?\n"
            + "                    AND camSubmitterUid = ?\n"
            + "                    AND (? = 0 OR camLct = (SELECT MAX(mark.camLct) \n"
            + "                                    FROM CourseAssignmentMark As mark\n"
            + "                                    WHERE mark.camAssignmentUid = ?\n"
            + "                                      AND mark.camSubmitterUid = ?\n"
            + "                                      AND mark.camMarkerSubmitterUid = courseAssignmentMark.camMarkerSubmitterUid\n"
            + "                                      ))                 \n"
            + "                ORDER BY camLct DESC)    \n"
            + "                \n"
            + "          SELECT marker.*, ScoreByMarker.*, (ClazzAssignment.caGroupUid != 0) AS isGroup\n"
            + "            FROM ScoreByMarker\n"
            + "                 JOIN Person As marker\n"
            + "                 ON Marker.personUid = ScoreByMarker.camMarkerPersonUid\n"
            + "                 JOIN ClazzAssignment\n"
            + "                 ON ClazzAssignment.caUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    return new LimitOffsetPagingSource<CourseAssignmentMarkWithPersonMarker>(_statement, __db, "courseAssignmentMark", "CourseAssignmentMark", "Person", "ClazzAssignment") {
      @Override
      @NonNull
      protected List<CourseAssignmentMarkWithPersonMarker> convertRows(
          @NonNull final Cursor cursor) {
        final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
        final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
        final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
        final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
        final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
        final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
        final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
        final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
        final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
        final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
        final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
        final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
        final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
        final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
        final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
        final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
        final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
        final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
        final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
        final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
        final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
        final int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow(cursor, "camUid");
        final int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow(cursor, "camAssignmentUid");
        final int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "camSubmitterUid");
        final int _cursorIndexOfCamMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "camMarkerSubmitterUid");
        final int _cursorIndexOfCamMarkerPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "camMarkerPersonUid");
        final int _cursorIndexOfCamMarkerComment = CursorUtil.getColumnIndexOrThrow(cursor, "camMarkerComment");
        final int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow(cursor, "camMark");
        final int _cursorIndexOfCamMaxMark = CursorUtil.getColumnIndexOrThrow(cursor, "camMaxMark");
        final int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow(cursor, "camPenalty");
        final int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow(cursor, "camLct");
        final int _cursorIndexOfCamClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "camClazzUid");
        final int _cursorIndexOfIsGroup = CursorUtil.getColumnIndexOrThrow(cursor, "isGroup");
        final List<CourseAssignmentMarkWithPersonMarker> _result = new ArrayList<CourseAssignmentMarkWithPersonMarker>(cursor.getCount());
        while (cursor.moveToNext()) {
          final CourseAssignmentMarkWithPersonMarker _item;
          final Person _tmpMarker;
          if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
            final long _tmpPersonUid;
            _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_1 != 0;
            final String _tmpPersonNotes;
            if (cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
            }
            _tmpMarker = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _tmpMarker = null;
          }
          _item = new CourseAssignmentMarkWithPersonMarker();
          final long _tmpCamUid;
          _tmpCamUid = cursor.getLong(_cursorIndexOfCamUid);
          _item.setCamUid(_tmpCamUid);
          final long _tmpCamAssignmentUid;
          _tmpCamAssignmentUid = cursor.getLong(_cursorIndexOfCamAssignmentUid);
          _item.setCamAssignmentUid(_tmpCamAssignmentUid);
          final long _tmpCamSubmitterUid;
          _tmpCamSubmitterUid = cursor.getLong(_cursorIndexOfCamSubmitterUid);
          _item.setCamSubmitterUid(_tmpCamSubmitterUid);
          final long _tmpCamMarkerSubmitterUid;
          _tmpCamMarkerSubmitterUid = cursor.getLong(_cursorIndexOfCamMarkerSubmitterUid);
          _item.setCamMarkerSubmitterUid(_tmpCamMarkerSubmitterUid);
          final long _tmpCamMarkerPersonUid;
          _tmpCamMarkerPersonUid = cursor.getLong(_cursorIndexOfCamMarkerPersonUid);
          _item.setCamMarkerPersonUid(_tmpCamMarkerPersonUid);
          final String _tmpCamMarkerComment;
          if (cursor.isNull(_cursorIndexOfCamMarkerComment)) {
            _tmpCamMarkerComment = null;
          } else {
            _tmpCamMarkerComment = cursor.getString(_cursorIndexOfCamMarkerComment);
          }
          _item.setCamMarkerComment(_tmpCamMarkerComment);
          final float _tmpCamMark;
          _tmpCamMark = cursor.getFloat(_cursorIndexOfCamMark);
          _item.setCamMark(_tmpCamMark);
          final float _tmpCamMaxMark;
          _tmpCamMaxMark = cursor.getFloat(_cursorIndexOfCamMaxMark);
          _item.setCamMaxMark(_tmpCamMaxMark);
          final float _tmpCamPenalty;
          _tmpCamPenalty = cursor.getFloat(_cursorIndexOfCamPenalty);
          _item.setCamPenalty(_tmpCamPenalty);
          final long _tmpCamLct;
          _tmpCamLct = cursor.getLong(_cursorIndexOfCamLct);
          _item.setCamLct(_tmpCamLct);
          final long _tmpCamClazzUid;
          _tmpCamClazzUid = cursor.getLong(_cursorIndexOfCamClazzUid);
          _item.setCamClazzUid(_tmpCamClazzUid);
          final boolean _tmpIsGroup;
          final int _tmp_2;
          _tmp_2 = cursor.getInt(_cursorIndexOfIsGroup);
          _tmpIsGroup = _tmp_2 != 0;
          _item.setGroup(_tmpIsGroup);
          _item.setMarker(_tmpMarker);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public CourseAssignmentMark getMarkOfAssignmentForStudent(final long assignmentUid,
      final long submitterUid) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM CourseAssignmentMark\n"
            + "         WHERE camAssignmentUid = ?\n"
            + "           AND camSubmitterUid = ?\n"
            + "      ORDER BY camLct DESC\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camUid");
      final int _cursorIndexOfCamAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camAssignmentUid");
      final int _cursorIndexOfCamSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camSubmitterUid");
      final int _cursorIndexOfCamMarkerSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerSubmitterUid");
      final int _cursorIndexOfCamMarkerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerPersonUid");
      final int _cursorIndexOfCamMarkerComment = CursorUtil.getColumnIndexOrThrow(_cursor, "camMarkerComment");
      final int _cursorIndexOfCamMark = CursorUtil.getColumnIndexOrThrow(_cursor, "camMark");
      final int _cursorIndexOfCamMaxMark = CursorUtil.getColumnIndexOrThrow(_cursor, "camMaxMark");
      final int _cursorIndexOfCamPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "camPenalty");
      final int _cursorIndexOfCamLct = CursorUtil.getColumnIndexOrThrow(_cursor, "camLct");
      final int _cursorIndexOfCamClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "camClazzUid");
      final CourseAssignmentMark _result;
      if (_cursor.moveToFirst()) {
        _result = new CourseAssignmentMark();
        final long _tmpCamUid;
        _tmpCamUid = _cursor.getLong(_cursorIndexOfCamUid);
        _result.setCamUid(_tmpCamUid);
        final long _tmpCamAssignmentUid;
        _tmpCamAssignmentUid = _cursor.getLong(_cursorIndexOfCamAssignmentUid);
        _result.setCamAssignmentUid(_tmpCamAssignmentUid);
        final long _tmpCamSubmitterUid;
        _tmpCamSubmitterUid = _cursor.getLong(_cursorIndexOfCamSubmitterUid);
        _result.setCamSubmitterUid(_tmpCamSubmitterUid);
        final long _tmpCamMarkerSubmitterUid;
        _tmpCamMarkerSubmitterUid = _cursor.getLong(_cursorIndexOfCamMarkerSubmitterUid);
        _result.setCamMarkerSubmitterUid(_tmpCamMarkerSubmitterUid);
        final long _tmpCamMarkerPersonUid;
        _tmpCamMarkerPersonUid = _cursor.getLong(_cursorIndexOfCamMarkerPersonUid);
        _result.setCamMarkerPersonUid(_tmpCamMarkerPersonUid);
        final String _tmpCamMarkerComment;
        if (_cursor.isNull(_cursorIndexOfCamMarkerComment)) {
          _tmpCamMarkerComment = null;
        } else {
          _tmpCamMarkerComment = _cursor.getString(_cursorIndexOfCamMarkerComment);
        }
        _result.setCamMarkerComment(_tmpCamMarkerComment);
        final float _tmpCamMark;
        _tmpCamMark = _cursor.getFloat(_cursorIndexOfCamMark);
        _result.setCamMark(_tmpCamMark);
        final float _tmpCamMaxMark;
        _tmpCamMaxMark = _cursor.getFloat(_cursorIndexOfCamMaxMark);
        _result.setCamMaxMark(_tmpCamMaxMark);
        final float _tmpCamPenalty;
        _tmpCamPenalty = _cursor.getFloat(_cursorIndexOfCamPenalty);
        _result.setCamPenalty(_tmpCamPenalty);
        final long _tmpCamLct;
        _tmpCamLct = _cursor.getLong(_cursorIndexOfCamLct);
        _result.setCamLct(_tmpCamLct);
        final long _tmpCamClazzUid;
        _tmpCamClazzUid = _cursor.getLong(_cursorIndexOfCamClazzUid);
        _result.setCamClazzUid(_tmpCamClazzUid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findNextSubmitterToMarkForAssignment(final long assignmentUid,
      final long submitterUid, final long markerUid, final Continuation<? super Long> $completion) {
    final String _sql = "\n"
            + "         SELECT COALESCE((\n"
            + "            SELECT casSubmitterUid\n"
            + "              FROM CourseAssignmentSubmission\n"
            + "              \n"
            + "                   JOIN ClazzAssignment\n"
            + "                   ON ClazzAssignment.caUid = CourseAssignmentSubmission.casAssignmentUid\n"
            + "              \n"
            + "                   LEFT JOIN CourseAssignmentMark\n"
            + "                   ON CourseAssignmentMark.camSubmitterUid = CourseAssignmentSubmission.casSubmitterUid\n"
            + "                   AND CourseAssignmentMark.camAssignmentUid = ClazzAssignment.caUid\n"
            + "                   \n"
            + "                   LEFT JOIN PeerReviewerAllocation\n"
            + "                   ON praAssignmentUid = ClazzAssignment.caUid\n"
            + "                   AND praToMarkerSubmitterUid = ?\n"
            + "                   \n"
            + "             WHERE CourseAssignmentSubmission.casSubmitterUid != ?\n"
            + "               AND CourseAssignmentSubmission.casSubmitterUid != ?\n"
            + "               AND CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "               AND CourseAssignmentMark.camUid IS NULL\n"
            + "               AND (ClazzAssignment.caMarkingType = 1 \n"
            + "                    OR PeerReviewerAllocation.praMarkerSubmitterUid = ?)\n"
            + "          GROUP BY casSubmitterUid\n"
            + "         LIMIT 1),0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, markerUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, markerUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if (_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
