package com.ustadmobile.core.db

import androidx.room.Database
import com.ustadmobile.core.db.dao.CacheLockJoinDao
import com.ustadmobile.core.db.dao.ClazzAssignmentDao
import com.ustadmobile.core.db.dao.ClazzDao
import com.ustadmobile.core.db.dao.ClazzEnrolmentDao
import com.ustadmobile.core.db.dao.ClazzLogAttendanceRecordDao
import com.ustadmobile.core.db.dao.ClazzLogDao
import com.ustadmobile.core.db.dao.CommentsDao
import com.ustadmobile.core.db.dao.ContentCategoryDao
import com.ustadmobile.core.db.dao.ContentCategorySchemaDao
import com.ustadmobile.core.db.dao.ContentEntryContentCategoryJoinDao
import com.ustadmobile.core.db.dao.ContentEntryDao
import com.ustadmobile.core.db.dao.ContentEntryImportJobDao
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao
import com.ustadmobile.core.db.dao.ContentEntryPicture2Dao
import com.ustadmobile.core.db.dao.ContentEntryPictureDao
import com.ustadmobile.core.db.dao.ContentEntryRelatedEntryJoinDao
import com.ustadmobile.core.db.dao.ContentEntryVersionDao
import com.ustadmobile.core.db.dao.CourseAssignmentMarkDao
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionDao
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionFileDao
import com.ustadmobile.core.db.dao.CourseBlockDao
import com.ustadmobile.core.db.dao.CourseBlockPictureDao
import com.ustadmobile.core.db.dao.CourseGroupMemberDao
import com.ustadmobile.core.db.dao.CourseGroupSetDao
import com.ustadmobile.core.db.dao.CoursePermissionDao
import com.ustadmobile.core.db.dao.CoursePictureDao
import com.ustadmobile.core.db.dao.CourseTerminologyDao
import com.ustadmobile.core.db.dao.DeletedItemDao
import com.ustadmobile.core.db.dao.DiscussionPostDao
import com.ustadmobile.core.db.dao.EnrolmentRequestDao
import com.ustadmobile.core.db.dao.ErrorReportDao
import com.ustadmobile.core.db.dao.ExternalAppPermissionDao
import com.ustadmobile.core.db.dao.HolidayCalendarDao
import com.ustadmobile.core.db.dao.HolidayDao
import com.ustadmobile.core.db.dao.LanguageDao
import com.ustadmobile.core.db.dao.LanguageVariantDao
import com.ustadmobile.core.db.dao.LeavingReasonDao
import com.ustadmobile.core.db.dao.MessageDao
import com.ustadmobile.core.db.dao.OfflineItemDao
import com.ustadmobile.core.db.dao.OfflineItemPendingTransferJob
import com.ustadmobile.core.db.dao.OutgoingReplicationDao
import com.ustadmobile.core.db.dao.PeerReviewerAllocationDao
import com.ustadmobile.core.db.dao.PersonAuth2Dao
import com.ustadmobile.core.db.dao.PersonAuthDao
import com.ustadmobile.core.db.dao.PersonDao
import com.ustadmobile.core.db.dao.PersonGroupDao
import com.ustadmobile.core.db.dao.PersonGroupMemberDao
import com.ustadmobile.core.db.dao.PersonParentJoinDao
import com.ustadmobile.core.db.dao.PersonPictureDao
import com.ustadmobile.core.db.dao.ReportDao
import com.ustadmobile.core.db.dao.ScheduleDao
import com.ustadmobile.core.db.dao.ScopedGrantDao
import com.ustadmobile.core.db.dao.SiteDao
import com.ustadmobile.core.db.dao.SiteTermsDao
import com.ustadmobile.core.db.dao.StudentResultDao
import com.ustadmobile.core.db.dao.SyncNodeDao
import com.ustadmobile.core.db.dao.SystemPermissionDao
import com.ustadmobile.core.db.dao.TransferJobDao
import com.ustadmobile.core.db.dao.TransferJobErrorDao
import com.ustadmobile.core.db.dao.TransferJobItemDao
import com.ustadmobile.core.db.dao.UserSessionDao
import com.ustadmobile.core.db.dao.xapi.ActivityEntityDao
import com.ustadmobile.core.db.dao.xapi.ActivityExtensionDao
import com.ustadmobile.core.db.dao.xapi.ActivityInteractionDao
import com.ustadmobile.core.db.dao.xapi.ActivityLangMapEntryDao
import com.ustadmobile.core.db.dao.xapi.ActorDao
import com.ustadmobile.core.db.dao.xapi.GroupMemberActorJoinDao
import com.ustadmobile.core.db.dao.xapi.StateDeleteCommandDao
import com.ustadmobile.core.db.dao.xapi.StateEntityDao
import com.ustadmobile.core.db.dao.xapi.StatementContextActivityJoinDao
import com.ustadmobile.core.db.dao.xapi.StatementDao
import com.ustadmobile.core.db.dao.xapi.StatementEntityJsonDao
import com.ustadmobile.core.db.dao.xapi.VerbDao
import com.ustadmobile.core.db.dao.xapi.VerbLangMapEntryDao
import com.ustadmobile.core.db.dao.xapi.XapiSessionEntityDao
import com.ustadmobile.door.SyncNode
import com.ustadmobile.door.entities.DoorNode
import com.ustadmobile.door.entities.OutgoingReplication
import com.ustadmobile.door.entities.PendingRepositorySession
import com.ustadmobile.door.entities.ReplicationOperation
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.CacheLockJoin
import com.ustadmobile.lib.db.entities.Clazz
import com.ustadmobile.lib.db.entities.ClazzAssignment
import com.ustadmobile.lib.db.entities.ClazzEnrolment
import com.ustadmobile.lib.db.entities.ClazzLog
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord
import com.ustadmobile.lib.db.entities.Comments
import com.ustadmobile.lib.db.entities.ContentCategory
import com.ustadmobile.lib.db.entities.ContentCategorySchema
import com.ustadmobile.lib.db.entities.ContentEntry
import com.ustadmobile.lib.db.entities.ContentEntryContentCategoryJoin
import com.ustadmobile.lib.db.entities.ContentEntryImportJob
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin
import com.ustadmobile.lib.db.entities.ContentEntryPicture
import com.ustadmobile.lib.db.entities.ContentEntryPicture2
import com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin
import com.ustadmobile.lib.db.entities.ContentEntryVersion
import com.ustadmobile.lib.db.entities.ContentJob
import com.ustadmobile.lib.db.entities.CourseAssignmentMark
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmission
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionFile
import com.ustadmobile.lib.db.entities.CourseBlock
import com.ustadmobile.lib.db.entities.CourseBlockPicture
import com.ustadmobile.lib.db.entities.CourseGroupMember
import com.ustadmobile.lib.db.entities.CourseGroupSet
import com.ustadmobile.lib.db.entities.CoursePermission
import com.ustadmobile.lib.db.entities.CoursePicture
import com.ustadmobile.lib.db.entities.CourseTerminology
import com.ustadmobile.lib.db.entities.DeletedItem
import com.ustadmobile.lib.db.entities.DiscussionPost
import com.ustadmobile.lib.db.entities.EnrolmentRequest
import com.ustadmobile.lib.db.entities.ErrorReport
import com.ustadmobile.lib.db.entities.ExternalAppPermission
import com.ustadmobile.lib.db.entities.Holiday
import com.ustadmobile.lib.db.entities.HolidayCalendar
import com.ustadmobile.lib.db.entities.Language
import com.ustadmobile.lib.db.entities.LanguageVariant
import com.ustadmobile.lib.db.entities.LeavingReason
import com.ustadmobile.lib.db.entities.Message
import com.ustadmobile.lib.db.entities.OfflineItem
import com.ustadmobile.lib.db.entities.PeerReviewerAllocation
import com.ustadmobile.lib.db.entities.Person
import com.ustadmobile.lib.db.entities.PersonAuth
import com.ustadmobile.lib.db.entities.PersonAuth2
import com.ustadmobile.lib.db.entities.PersonGroup
import com.ustadmobile.lib.db.entities.PersonGroupMember
import com.ustadmobile.lib.db.entities.PersonParentJoin
import com.ustadmobile.lib.db.entities.PersonPicture
import com.ustadmobile.lib.db.entities.Report
import com.ustadmobile.lib.db.entities.Schedule
import com.ustadmobile.lib.db.entities.ScopedGrant
import com.ustadmobile.lib.db.entities.Site
import com.ustadmobile.lib.db.entities.SiteTerms
import com.ustadmobile.lib.db.entities.StudentResult
import com.ustadmobile.lib.db.entities.SystemPermission
import com.ustadmobile.lib.db.entities.TransferJob
import com.ustadmobile.lib.db.entities.TransferJobError
import com.ustadmobile.lib.db.entities.TransferJobItem
import com.ustadmobile.lib.db.entities.UserSession
import com.ustadmobile.lib.db.entities.xapi.ActivityEntity
import com.ustadmobile.lib.db.entities.xapi.ActivityExtensionEntity
import com.ustadmobile.lib.db.entities.xapi.ActivityInteractionEntity
import com.ustadmobile.lib.db.entities.xapi.ActivityLangMapEntry
import com.ustadmobile.lib.db.entities.xapi.ActorEntity
import com.ustadmobile.lib.db.entities.xapi.GroupMemberActorJoin
import com.ustadmobile.lib.db.entities.xapi.StateDeleteCommand
import com.ustadmobile.lib.db.entities.xapi.StateEntity
import com.ustadmobile.lib.db.entities.xapi.StatementContextActivityJoin
import com.ustadmobile.lib.db.entities.xapi.StatementEntity
import com.ustadmobile.lib.db.entities.xapi.StatementEntityJson
import com.ustadmobile.lib.db.entities.xapi.VerbEntity
import com.ustadmobile.lib.db.entities.xapi.VerbLangMapEntry
import com.ustadmobile.lib.db.entities.xapi.XapiSessionEntity

@Database(
  entities = arrayOf(ClazzLog::class, ClazzLogAttendanceRecord::class, Schedule::class,
          HolidayCalendar::class, Holiday::class, Person::class, Clazz::class,
          ClazzEnrolment::class, LeavingReason::class, ContentEntry::class,
          ContentEntryContentCategoryJoin::class, ContentEntryParentChildJoin::class,
          ContentEntryRelatedEntryJoin::class, ContentCategorySchema::class, ContentCategory::class,
          Language::class, LanguageVariant::class, PersonAuth::class, PersonGroup::class,
          PersonGroupMember::class, PersonPicture::class, VerbEntity::class, ActivityEntity::class,
          StatementEntity::class, ActorEntity::class, SyncNode::class, Comments::class,
          Report::class, Site::class, SiteTerms::class, PersonParentJoin::class, ScopedGrant::class,
          ErrorReport::class, ClazzAssignment::class, CourseAssignmentSubmission::class,
          CourseAssignmentSubmissionFile::class, CourseAssignmentMark::class,
          PeerReviewerAllocation::class, PersonAuth2::class, UserSession::class, ContentJob::class,
          ContentEntryImportJob::class, CourseBlock::class, CourseTerminology::class,
          CourseGroupSet::class, CourseGroupMember::class, ContentEntryPicture::class,
          ActivityInteractionEntity::class, CoursePicture::class, DiscussionPost::class,
          ExternalAppPermission::class, Message::class, StudentResult::class,
          ContentEntryVersion::class, TransferJob::class, TransferJobItem::class,
          CacheLockJoin::class, OfflineItem::class, OfflineItemPendingTransferJob::class,
          DeletedItem::class, EnrolmentRequest::class, CoursePermission::class,
          SystemPermission::class, CourseBlockPicture::class, ContentEntryPicture2::class,
          TransferJobError::class, VerbLangMapEntry::class, GroupMemberActorJoin::class,
          ActivityLangMapEntry::class, ActivityExtensionEntity::class,
          StatementContextActivityJoin::class, XapiSessionEntity::class, StatementEntityJson::class,
          StateEntity::class, StateDeleteCommand::class, OutgoingReplication::class,
          ReplicationOperation::class, PendingRepositorySession::class, DoorNode::class),
  version = 202,
  views = arrayOf(),
  exportSchema = true,
)
public actual abstract class UmAppDatabase : RoomDatabase() {
  public actual abstract fun personDao(): PersonDao

  public actual abstract fun clazzDao(): ClazzDao

  public actual abstract fun courseBlockDao(): CourseBlockDao

  public actual abstract fun courseTerminologyDao(): CourseTerminologyDao

  public actual abstract fun courseGroupSetDao(): CourseGroupSetDao

  public actual abstract fun courseGroupMemberDao(): CourseGroupMemberDao

  public actual abstract fun clazzEnrolmentDao(): ClazzEnrolmentDao

  public actual abstract fun leavingReasonDao(): LeavingReasonDao

  public actual abstract fun contentEntryDao(): ContentEntryDao

  public actual abstract fun contentEntryContentCategoryJoinDao():
      ContentEntryContentCategoryJoinDao

  public actual abstract fun contentEntryParentChildJoinDao(): ContentEntryParentChildJoinDao

  public actual abstract fun contentEntryRelatedEntryJoinDao(): ContentEntryRelatedEntryJoinDao

  public actual abstract fun contentCategorySchemaDao(): ContentCategorySchemaDao

  public actual abstract fun contentCategoryDao(): ContentCategoryDao

  public actual abstract fun languageDao(): LanguageDao

  public actual abstract fun languageVariantDao(): LanguageVariantDao

  public actual abstract fun personAuthDao(): PersonAuthDao

  public actual abstract fun personGroupDao(): PersonGroupDao

  public actual abstract fun personGroupMemberDao(): PersonGroupMemberDao

  public actual abstract fun personPictureDao(): PersonPictureDao

  public actual abstract fun verbDao(): VerbDao

  public actual abstract fun activityEntityDao(): ActivityEntityDao

  public actual abstract fun reportDao(): ReportDao

  public actual abstract fun statementDao(): StatementDao

  public actual abstract fun actorDao(): ActorDao

  public actual abstract fun clazzLogAttendanceRecordDao(): ClazzLogAttendanceRecordDao

  public actual abstract fun clazzLogDao(): ClazzLogDao

  public actual abstract fun scheduleDao(): ScheduleDao

  public actual abstract fun holidayCalendarDao(): HolidayCalendarDao

  public actual abstract fun holidayDao(): HolidayDao

  public actual abstract fun clazzAssignmentDao(): ClazzAssignmentDao

  public actual abstract fun courseAssignmentSubmissionDao(): CourseAssignmentSubmissionDao

  public actual abstract fun courseAssignmentSubmissionFileDao(): CourseAssignmentSubmissionFileDao

  public actual abstract fun courseAssignmentMarkDao(): CourseAssignmentMarkDao

  public actual abstract fun commentsDao(): CommentsDao

  public actual abstract fun syncNodeDao(): SyncNodeDao

  public actual abstract fun siteDao(): SiteDao

  public actual abstract fun siteTermsDao(): SiteTermsDao

  public actual abstract fun personParentJoinDao(): PersonParentJoinDao

  public actual abstract fun scopedGrantDao(): ScopedGrantDao

  public actual abstract fun errorReportDao(): ErrorReportDao

  public actual abstract fun personAuth2Dao(): PersonAuth2Dao

  public actual abstract fun userSessionDao(): UserSessionDao

  public actual abstract fun contentEntryImportJobDao(): ContentEntryImportJobDao

  public actual abstract fun coursePictureDao(): CoursePictureDao

  public actual abstract fun contentEntryPictureDao(): ContentEntryPictureDao

  public actual abstract fun messageDao(): MessageDao

  public actual abstract fun peerReviewerAllocationDao(): PeerReviewerAllocationDao

  public actual abstract fun discussionPostDao(): DiscussionPostDao

  public actual abstract fun externalAppPermissionDao(): ExternalAppPermissionDao

  public actual abstract fun contentEntryVersionDao(): ContentEntryVersionDao

  public actual abstract fun outgoingReplicationDao(): OutgoingReplicationDao

  public actual abstract fun transferJobDao(): TransferJobDao

  public actual abstract fun transferJobItemDao(): TransferJobItemDao

  public actual abstract fun cacheLockJoinDao(): CacheLockJoinDao

  public actual abstract fun offlineItemDao(): OfflineItemDao

  public actual abstract fun deletedItemDao(): DeletedItemDao

  public actual abstract fun enrolmentRequestDao(): EnrolmentRequestDao

  public actual abstract fun coursePermissionDao(): CoursePermissionDao

  public actual abstract fun systemPermissionDao(): SystemPermissionDao

  public actual abstract fun courseBlockPictureDao(): CourseBlockPictureDao

  public actual abstract fun contentEntryPicture2Dao(): ContentEntryPicture2Dao

  public actual abstract fun transferJobErrorDao(): TransferJobErrorDao

  public actual abstract fun studentResultDao(): StudentResultDao

  public actual abstract fun verbLangMapEntryDao(): VerbLangMapEntryDao

  public actual abstract fun groupMemberActorJoinDao(): GroupMemberActorJoinDao

  public actual abstract fun activityLangMapEntryDao(): ActivityLangMapEntryDao

  public actual abstract fun activityInteractionDao(): ActivityInteractionDao

  public actual abstract fun activityExtensionDao(): ActivityExtensionDao

  public actual abstract fun statementContextActivityJoinDao(): StatementContextActivityJoinDao

  public actual abstract fun xapiSessionEntityDao(): XapiSessionEntityDao

  public actual abstract fun statementEntityJsonDao(): StatementEntityJsonDao

  public actual abstract fun stateEntityDao(): StateEntityDao

  public actual abstract fun stateDeleteCommandDao(): StateDeleteCommandDao
}
