package com.ustadmobile.core.db.dao.xapi

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.xapi.StatementContextActivityJoin
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class StatementContextActivityJoinDao {
  @Insert(
    onConflict = 5,
    entity = Any::class,
  )
  public actual abstract suspend
      fun insertOrIgnoreListAsync(entities: List<StatementContextActivityJoin>)

  @Query(`value` =
      "\n        SELECT StatementContextActivityJoin.*\n          FROM StatementContextActivityJoin\n         WHERE StatementContextActivityJoin.scajFromStatementIdHi = :statementIdHi\n           AND StatementContextActivityJoin.scajFromStatementIdLo = :statementIdLo\n           AND StatementContextActivityJoin.scajContextType = :scajContextType\n    ")
  public actual abstract suspend fun findAllByStatementId(
    statementIdHi: Long,
    statementIdLo: Long,
    scajContextType: Int,
  ): List<StatementContextActivityJoin>
}
