/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.coroutines;

import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.selects.SelectClause2;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\u0000J\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u000fH\u0096\u0001J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\u0018\u0010\u0004\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096A\u00a2\u0006\u0002\u0010\u001aJ\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0096\u0001J\u0013\u0010\u001e\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0001J\u0013\u0010\u001f\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\"\u0010\"\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u00020#8\u0016X\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Landroidx/room/coroutines/ConnectionWithLock;", "Landroidx/sqlite/SQLiteConnection;", "Lkotlinx/coroutines/sync/Mutex;", "delegate", "lock", "<init>", "(Landroidx/sqlite/SQLiteConnection;Lkotlinx/coroutines/sync/Mutex;)V", "acquireCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "acquireThrowable", "", "markAcquired", "context", "markReleased", "dump", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toString", "", "close", "holdsLock", "", "owner", "", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepare", "Landroidx/sqlite/SQLiteStatement;", "sql", "tryLock", "unlock", "isLocked", "()Z", "onLock", "Lkotlinx/coroutines/selects/SelectClause2;", "getOnLock", "()Lkotlinx/coroutines/selects/SelectClause2;", "room-runtime"})
@SourceDebugExtension(value={"SMAP\nConnectionPoolImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionPoolImpl.kt\nandroidx/room/coroutines/ConnectionWithLock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,556:1\n1#2:557\n1863#3,2:558\n*S KotlinDebug\n*F\n+ 1 ConnectionPoolImpl.kt\nandroidx/room/coroutines/ConnectionWithLock\n*L\n317#1:558,2\n*E\n"})
final class ConnectionWithLock
implements SQLiteConnection,
Mutex {
    @NotNull
    private final SQLiteConnection delegate;
    @NotNull
    private final Mutex lock;
    @Nullable
    private CoroutineContext acquireCoroutineContext;
    @Nullable
    private Throwable acquireThrowable;

    public ConnectionWithLock(@NotNull SQLiteConnection delegate, @NotNull Mutex lock) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.delegate = delegate;
        this.lock = lock;
    }

    public /* synthetic */ ConnectionWithLock(SQLiteConnection sQLiteConnection, Mutex mutex, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        }
        this(sQLiteConnection, mutex);
    }

    @NotNull
    public final ConnectionWithLock markAcquired(@NotNull CoroutineContext context) {
        ConnectionWithLock connectionWithLock;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConnectionWithLock $this$markAcquired_u24lambda_u240 = connectionWithLock = this;
        boolean bl = false;
        $this$markAcquired_u24lambda_u240.acquireCoroutineContext = context;
        $this$markAcquired_u24lambda_u240.acquireThrowable = new Throwable();
        return connectionWithLock;
    }

    @NotNull
    public final ConnectionWithLock markReleased() {
        ConnectionWithLock connectionWithLock;
        ConnectionWithLock $this$markReleased_u24lambda_u241 = connectionWithLock = this;
        boolean bl = false;
        $this$markReleased_u24lambda_u241.acquireCoroutineContext = null;
        $this$markReleased_u24lambda_u241.acquireThrowable = null;
        return connectionWithLock;
    }

    public final void dump(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (this.acquireCoroutineContext != null || this.acquireThrowable != null) {
            Object it;
            builder.append("\t\tStatus: Acquired connection").append('\n');
            CoroutineContext coroutineContext = this.acquireCoroutineContext;
            if (coroutineContext != null) {
                it = coroutineContext;
                boolean bl = false;
                builder.append("\t\tCoroutine: " + it).append('\n');
            }
            Throwable throwable = this.acquireThrowable;
            if (throwable != null) {
                it = throwable;
                boolean bl = false;
                builder.append("\t\tAcquired:").append('\n');
                Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)StringsKt.lines((CharSequence)ExceptionsKt.stackTraceToString((Throwable)it)), (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl2 = false;
                    builder.append("\t\t" + line).append('\n');
                }
            }
        } else {
            builder.append("\t\tStatus: Free connection").append('\n');
        }
    }

    @NotNull
    public String toString() {
        return this.delegate.toString();
    }

    @NotNull
    public SQLiteStatement prepare(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return this.delegate.prepare(sql);
    }

    public void close() {
        this.delegate.close();
    }

    public boolean holdsLock(@NotNull Object owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return this.lock.holdsLock(owner);
    }

    @Nullable
    public Object lock(@Nullable Object owner, @NotNull Continuation<? super Unit> $completion) {
        return this.lock.lock(owner, $completion);
    }

    public boolean tryLock(@Nullable Object owner) {
        return this.lock.tryLock(owner);
    }

    public void unlock(@Nullable Object owner) {
        this.lock.unlock(owner);
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @NotNull
    public SelectClause2<Object, Mutex> getOnLock() {
        return this.lock.getOnLock();
    }
}

