/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.content.internal;

import androidx.compose.foundation.content.ReceiveContentListener;
import androidx.compose.foundation.content.ReceiveContentNode;
import androidx.compose.foundation.content.TransferableContent;
import androidx.compose.foundation.content.internal.ReceiveContentConfiguration;
import androidx.compose.foundation.content.internal.ReceiveContentConfigurationKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Landroidx/compose/foundation/content/internal/DynamicReceiveContentConfiguration;", "Landroidx/compose/foundation/content/internal/ReceiveContentConfiguration;", "receiveContentNode", "Landroidx/compose/foundation/content/ReceiveContentNode;", "<init>", "(Landroidx/compose/foundation/content/ReceiveContentNode;)V", "getReceiveContentNode", "()Landroidx/compose/foundation/content/ReceiveContentNode;", "getParentReceiveContentListener", "Landroidx/compose/foundation/content/ReceiveContentListener;", "receiveContentListener", "getReceiveContentListener", "()Landroidx/compose/foundation/content/ReceiveContentListener;", "foundation"})
@StabilityInferred(parameters=0)
public final class DynamicReceiveContentConfiguration
extends ReceiveContentConfiguration {
    @NotNull
    private final ReceiveContentNode receiveContentNode;
    @NotNull
    private final ReceiveContentListener receiveContentListener;
    public static final int $stable = 8;

    public DynamicReceiveContentConfiguration(@NotNull ReceiveContentNode receiveContentNode) {
        Intrinsics.checkNotNullParameter((Object)((Object)receiveContentNode), (String)"receiveContentNode");
        this.receiveContentNode = receiveContentNode;
        this.receiveContentListener = new ReceiveContentListener(this){
            private int nodeEnterCount;
            final /* synthetic */ DynamicReceiveContentConfiguration this$0;
            {
                this.this$0 = $receiver;
            }

            public void onDragStart() {
                this.nodeEnterCount = 0;
                this.this$0.getReceiveContentNode().getReceiveContentListener().onDragStart();
            }

            public void onDragEnd() {
                this.this$0.getReceiveContentNode().getReceiveContentListener().onDragEnd();
                this.nodeEnterCount = 0;
            }

            public void onDragEnter() {
                block1: {
                    int n = this.nodeEnterCount;
                    this.nodeEnterCount = n + 1;
                    if (this.nodeEnterCount == 1) {
                        this.this$0.getReceiveContentNode().getReceiveContentListener().onDragEnter();
                    }
                    ReceiveContentListener receiveContentListener2 = DynamicReceiveContentConfiguration.access$getParentReceiveContentListener(this.this$0);
                    if (receiveContentListener2 == null) break block1;
                    receiveContentListener2.onDragEnter();
                }
            }

            public void onDragExit() {
                block1: {
                    int previous = this.nodeEnterCount;
                    this.nodeEnterCount = RangesKt.coerceAtLeast((int)(this.nodeEnterCount - 1), (int)0);
                    if (this.nodeEnterCount == 0 && previous > 0) {
                        this.this$0.getReceiveContentNode().getReceiveContentListener().onDragExit();
                    }
                    ReceiveContentListener receiveContentListener2 = DynamicReceiveContentConfiguration.access$getParentReceiveContentListener(this.this$0);
                    if (receiveContentListener2 == null) break block1;
                    receiveContentListener2.onDragExit();
                }
            }

            public TransferableContent onReceive(TransferableContent transferableContent) {
                Intrinsics.checkNotNullParameter((Object)transferableContent, (String)"transferableContent");
                TransferableContent transferableContent2 = this.this$0.getReceiveContentNode().getReceiveContentListener().onReceive(transferableContent);
                if (transferableContent2 == null) {
                    return null;
                }
                TransferableContent remaining = transferableContent2;
                ReceiveContentListener receiveContentListener2 = DynamicReceiveContentConfiguration.access$getParentReceiveContentListener(this.this$0);
                if (receiveContentListener2 == null) {
                    return remaining;
                }
                ReceiveContentListener parentReceiveContentListener = receiveContentListener2;
                return parentReceiveContentListener.onReceive(remaining);
            }
        };
    }

    @NotNull
    public final ReceiveContentNode getReceiveContentNode() {
        return this.receiveContentNode;
    }

    private final ReceiveContentListener getParentReceiveContentListener() {
        ReceiveContentConfiguration receiveContentConfiguration = ReceiveContentConfigurationKt.getReceiveContentConfiguration(this.receiveContentNode);
        return receiveContentConfiguration != null ? receiveContentConfiguration.getReceiveContentListener() : null;
    }

    @Override
    @NotNull
    public ReceiveContentListener getReceiveContentListener() {
        return this.receiveContentListener;
    }

    public static final /* synthetic */ ReceiveContentListener access$getParentReceiveContentListener(DynamicReceiveContentConfiguration $this) {
        return $this.getParentReceiveContentListener();
    }
}

