/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList;

import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.PersistentList;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.ObjectRef;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.SmallPersistentVector;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.CommonFunctionsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.ListImplementation;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010*\n\u0002\b\t\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B7\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0010\u001a\u00020\tH\u0002J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013JC\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u0017J?\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\t2\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ5\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001e\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u001fJG\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u001b\u001a\u00020\tH\u0016J;\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010&J3\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010(J?\u0010)\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010*\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010+J=\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010*\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010+J\"\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002000/H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00028\u000002H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00028\u0000042\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u001d\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u00106J\u0016\u00107\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u00108J#\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ?\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\b\u0010;\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010<R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "E", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/AbstractPersistentList;", "root", "", "", "tail", "size", "", "rootShift", "<init>", "([Ljava/lang/Object;[Ljava/lang/Object;II)V", "[Ljava/lang/Object;", "getSize", "()I", "rootSize", "add", "element", "(Ljava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "pushFilledTail", "filledTail", "newTail", "([Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "pushTail", "shift", "([Ljava/lang/Object;I[Ljava/lang/Object;)[Ljava/lang/Object;", "index", "(ILjava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "insertIntoTail", "tailIndex", "([Ljava/lang/Object;ILjava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "insertIntoRoot", "elementCarry", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/ObjectRef;", "([Ljava/lang/Object;IILjava/lang/Object;Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "removeAt", "removeFromTailAt", "([Ljava/lang/Object;III)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "pullLastBufferFromRoot", "([Ljava/lang/Object;II)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "pullLastBuffer", "tailCarry", "([Ljava/lang/Object;IILandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "removeFromRootAt", "removeAll", "predicate", "Lkotlin/Function1;", "", "builder", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "listIterator", "", "bufferFor", "(I)[Ljava/lang/Object;", "get", "(I)Ljava/lang/Object;", "set", "setInRoot", "e", "([Ljava/lang/Object;IILjava/lang/Object;)[Ljava/lang/Object;", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPersistentVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentVector.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector\n+ 2 Preconditions.kt\nandroidx/compose/runtime/PreconditionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n34#2,4:329\n1#3:333\n*S KotlinDebug\n*F\n+ 1 PersistentVector.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector\n*L\n30#1:329,4\n*E\n"})
public final class PersistentVector<E>
extends AbstractPersistentList<E>
implements PersistentList<E> {
    @NotNull
    private final Object[] root;
    @NotNull
    private final Object[] tail;
    private final int size;
    private final int rootShift;
    public static final int $stable = 8;

    public PersistentVector(@NotNull Object[] root, @NotNull Object[] tail, int size, int rootShift) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        this.root = root;
        this.tail = tail;
        this.size = size;
        this.rootShift = rootShift;
        boolean value$iv = this.size() > 32;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalArgumentException("Trie-based persistent vector should have at least 33 elements, got " + this.size());
        }
        CommonFunctionsKt.assert(this.size() - UtilsKt.rootSize(this.size()) <= RangesKt.coerceAtMost((int)this.tail.length, (int)32));
    }

    public int getSize() {
        return this.size;
    }

    private final int rootSize() {
        return UtilsKt.rootSize(this.size());
    }

    @Override
    @NotNull
    public PersistentList<E> add(E element) {
        int tailSize = this.size() - this.rootSize();
        if (tailSize < 32) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newTail = objectArray;
            newTail[tailSize] = element;
            return new PersistentVector<E>(this.root, newTail, this.size() + 1, this.rootShift);
        }
        Object[] newTail = UtilsKt.presizedBufferWith(element);
        return this.pushFilledTail(this.root, this.tail, newTail);
    }

    private final PersistentVector<E> pushFilledTail(Object[] root, Object[] filledTail, Object[] newTail) {
        if (this.size() >> 5 > 1 << this.rootShift) {
            Object[] newRoot = UtilsKt.presizedBufferWith(root);
            int newRootShift = this.rootShift + 5;
            newRoot = this.pushTail(newRoot, newRootShift, filledTail);
            return new PersistentVector<E>(newRoot, newTail, this.size() + 1, newRootShift);
        }
        Object[] newRoot = this.pushTail(root, this.rootShift, filledTail);
        return new PersistentVector<E>(newRoot, newTail, this.size() + 1, this.rootShift);
    }

    private final Object[] pushTail(Object[] root, int shift, Object[] tail) {
        Object[] objectArray;
        int bufferIndex;
        block3: {
            block2: {
                bufferIndex = UtilsKt.indexSegment(this.size() - 1, shift);
                objectArray = root;
                if (root == null) break block2;
                Object[] objectArray2 = Arrays.copyOf(objectArray, 32);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
                objectArray = objectArray2;
                if (objectArray2 != null) break block3;
            }
            objectArray = new Object[32];
        }
        Object[] newRootNode = objectArray;
        newRootNode[bufferIndex] = shift == 5 ? tail : this.pushTail((Object[])newRootNode[bufferIndex], shift - 5, tail);
        return newRootNode;
    }

    @Override
    @NotNull
    public PersistentList<E> add(int index, E element) {
        ListImplementation.checkPositionIndex$runtime(index, this.size());
        if (index == this.size()) {
            return this.add((Object)element);
        }
        int rootSize = this.rootSize();
        if (index >= rootSize) {
            return this.insertIntoTail(this.root, index - rootSize, element);
        }
        ObjectRef elementCarry = new ObjectRef(null);
        Object[] newRoot = this.insertIntoRoot(this.root, this.rootShift, index, element, elementCarry);
        return this.insertIntoTail(newRoot, 0, elementCarry.getValue());
    }

    private final PersistentVector<E> insertIntoTail(Object[] root, int tailIndex, Object element) {
        int tailSize = this.size() - this.rootSize();
        Object[] objectArray = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newTail = objectArray;
        if (tailSize < 32) {
            ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)(tailIndex + 1), (int)tailIndex, (int)tailSize);
            newTail[tailIndex] = element;
            return new PersistentVector<E>(root, newTail, this.size() + 1, this.rootShift);
        }
        Object lastElement = this.tail[31];
        ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)(tailIndex + 1), (int)tailIndex, (int)(tailSize - 1));
        newTail[tailIndex] = element;
        return this.pushFilledTail(root, newTail, UtilsKt.presizedBufferWith(lastElement));
    }

    private final Object[] insertIntoRoot(Object[] root, int shift, int index, Object element, ObjectRef elementCarry) {
        int bufferIndex = UtilsKt.indexSegment(index, shift);
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            }
            Object[] newRoot = objectArray;
            ArraysKt.copyInto((Object[])root, (Object[])newRoot, (int)(bufferIndex + 1), (int)bufferIndex, (int)31);
            elementCarry.setValue(root[31]);
            newRoot[bufferIndex] = element;
            return newRoot;
        }
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newRoot = objectArray;
        int lowerLevelShift = shift - 5;
        Object object = root[bufferIndex];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        newRoot[bufferIndex] = this.insertIntoRoot((Object[])object, lowerLevelShift, index, element, elementCarry);
        for (int i = bufferIndex + 1; i < 32 && newRoot[i] != null; ++i) {
            Object object2 = root[i];
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            newRoot[i] = this.insertIntoRoot((Object[])object2, lowerLevelShift, 0, elementCarry.getValue(), elementCarry);
        }
        return newRoot;
    }

    @Override
    @NotNull
    public PersistentList<E> removeAt(int index) {
        ListImplementation.checkElementIndex$runtime(index, this.size());
        int rootSize = this.rootSize();
        if (index >= rootSize) {
            return this.removeFromTailAt(this.root, rootSize, this.rootShift, index - rootSize);
        }
        Object[] newRoot = this.removeFromRootAt(this.root, this.rootShift, index, new ObjectRef(this.tail[0]));
        return this.removeFromTailAt(newRoot, rootSize, this.rootShift, 0);
    }

    private final PersistentList<E> removeFromTailAt(Object[] root, int rootSize, int shift, int index) {
        int tailSize = this.size() - rootSize;
        CommonFunctionsKt.assert(index < tailSize);
        if (tailSize == 1) {
            return this.pullLastBufferFromRoot(root, rootSize, shift);
        }
        Object[] objectArray = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newTail = objectArray;
        if (index < tailSize - 1) {
            ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)index, (int)(index + 1), (int)tailSize);
        }
        newTail[tailSize - 1] = null;
        return new PersistentVector<E>(root, newTail, rootSize + tailSize - 1, shift);
    }

    private final PersistentList<E> pullLastBufferFromRoot(Object[] root, int rootSize, int shift) {
        if (shift == 0) {
            Object[] objectArray;
            if (root.length == 33) {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            } else {
                objectArray = root;
            }
            Object[] buffer = objectArray;
            return new SmallPersistentVector(buffer);
        }
        ObjectRef tailCarry = new ObjectRef(null);
        Object[] objectArray = this.pullLastBuffer(root, shift, rootSize - 1, tailCarry);
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] newRoot = objectArray;
        Object object = tailCarry.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        Object[] newTail = (Object[])object;
        if (newRoot[1] == null) {
            Object object2 = newRoot[0];
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            Object[] lowerLevelRoot = (Object[])object2;
            return new PersistentVector<E>(lowerLevelRoot, newTail, rootSize, shift - 5);
        }
        return new PersistentVector<E>(newRoot, newTail, rootSize, shift);
    }

    private final Object[] pullLastBuffer(Object[] root, int shift, int index, ObjectRef tailCarry) {
        Object[] newBufferAtIndex;
        Object[] objectArray;
        int bufferIndex = UtilsKt.indexSegment(index, shift);
        if (shift == 5) {
            tailCarry.setValue(root[bufferIndex]);
            objectArray = null;
        } else {
            Object object = root[bufferIndex];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray = newBufferAtIndex = this.pullLastBuffer((Object[])object, shift - 5, index, tailCarry);
        }
        if (newBufferAtIndex == null && bufferIndex == 0) {
            return null;
        }
        Object[] objectArray2 = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
        Object[] newRoot = objectArray2;
        newRoot[bufferIndex] = newBufferAtIndex;
        return newRoot;
    }

    private final Object[] removeFromRootAt(Object[] root, int shift, int index, ObjectRef tailCarry) {
        int bufferIndex = UtilsKt.indexSegment(index, shift);
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            }
            Object[] newRoot = objectArray;
            ArraysKt.copyInto((Object[])root, (Object[])newRoot, (int)bufferIndex, (int)(bufferIndex + 1), (int)32);
            newRoot[31] = tailCarry.getValue();
            tailCarry.setValue(root[bufferIndex]);
            return newRoot;
        }
        int bufferLastIndex = 31;
        if (root[bufferLastIndex] == null) {
            bufferLastIndex = UtilsKt.indexSegment(this.rootSize() - 1, shift);
        }
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newRoot = objectArray;
        int lowerLevelShift = shift - 5;
        int i = bufferLastIndex;
        int n = bufferIndex + 1;
        if (n <= i) {
            while (true) {
                Object object = newRoot[i];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                newRoot[i] = this.removeFromRootAt((Object[])object, lowerLevelShift, 0, tailCarry);
                if (i == n) break;
                --i;
            }
        }
        Object object = newRoot[bufferIndex];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        newRoot[bufferIndex] = this.removeFromRootAt((Object[])object, lowerLevelShift, index, tailCarry);
        return newRoot;
    }

    @Override
    @NotNull
    public PersistentList<E> removeAll(@NotNull Function1<? super E, Boolean> predicate) {
        PersistentList.Builder builder;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        PersistentList.Builder it = builder = this.builder();
        boolean bl = false;
        ((PersistentVectorBuilder)it).removeAllWithPredicate(predicate);
        return ((PersistentVectorBuilder)builder).build();
    }

    @Override
    @NotNull
    public PersistentVectorBuilder<E> builder() {
        return new PersistentVectorBuilder(this, this.root, this.tail, this.rootShift);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        ListImplementation.checkPositionIndex$runtime(index, this.size());
        return new PersistentVectorIterator<Object>(this.root, this.tail, index, this.size(), this.rootShift / 5 + 1);
    }

    private final Object[] bufferFor(int index) {
        if (this.rootSize() <= index) {
            return this.tail;
        }
        Object[] buffer = this.root;
        for (int shift = this.rootShift; shift > 0; shift -= 5) {
            Object object = buffer[UtilsKt.indexSegment(index, shift)];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            buffer = (Object[])object;
        }
        return buffer;
    }

    @Override
    public E get(int index) {
        ListImplementation.checkElementIndex$runtime(index, this.size());
        Object[] buffer = this.bufferFor(index);
        return (E)buffer[index & 0x1F];
    }

    @Override
    @NotNull
    public PersistentList<E> set(int index, E element) {
        ListImplementation.checkElementIndex$runtime(index, this.size());
        if (this.rootSize() <= index) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newTail = objectArray;
            newTail[index & 0x1F] = element;
            return new PersistentVector<E>(this.root, newTail, this.size(), this.rootShift);
        }
        Object[] newRoot = this.setInRoot(this.root, this.rootShift, index, element);
        return new PersistentVector<E>(newRoot, this.tail, this.size(), this.rootShift);
    }

    private final Object[] setInRoot(Object[] root, int shift, int index, Object e) {
        int bufferIndex = UtilsKt.indexSegment(index, shift);
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newRoot = objectArray;
        if (shift == 0) {
            newRoot[bufferIndex] = e;
        } else {
            Object object = newRoot[bufferIndex];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            newRoot[bufferIndex] = this.setInRoot((Object[])object, shift - 5, index, e);
        }
        return newRoot;
    }
}

