/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.annotation.CallSuper;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavDestination;
import androidx.navigation.Navigator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\f\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000f\u001a\u0002H\u0010\"\f\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0006\u00a2\u0006\u0002\u0010\u0012J#\u0010\u000f\u001a\u0002H\u0010\"\f\b\u0000\u0010\u0010*\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0013\u001a\u00020\u0007H\u0017\u00a2\u0006\u0002\u0010\u0014J \u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tJ*\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00072\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0017R\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Landroidx/navigation/NavigatorProvider;", "", "<init>", "()V", "_typeToNavigatorName", "", "Lkotlin/reflect/KClass;", "", "_namedNavigators", "Landroidx/navigation/Navigator;", "Landroidx/navigation/NavDestination;", "navigators", "", "getNavigators", "()Ljava/util/Map;", "getNavigator", "T", "navigatorClass", "(Lkotlin/reflect/KClass;)Landroidx/navigation/Navigator;", "name", "(Ljava/lang/String;)Landroidx/navigation/Navigator;", "addNavigator", "navigator", "Companion", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nNavigatorProvider.nonAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigatorProvider.nonAndroid.kt\nandroidx/navigation/NavigatorProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public class NavigatorProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<KClass<?>, String> _typeToNavigatorName = new LinkedHashMap();
    @NotNull
    private final Map<String, Navigator<? extends NavDestination>> _namedNavigators = new LinkedHashMap();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final Map<String, Navigator<? extends NavDestination>> getNavigators() {
        return this._namedNavigators;
    }

    @NotNull
    public final <T extends Navigator<?>> T getNavigator(@NotNull KClass<T> navigatorClass) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(navigatorClass, (String)"navigatorClass");
                object = this._typeToNavigatorName.get(navigatorClass);
                if (object == null) break block2;
                String name = object;
                boolean bl = false;
                Navigator<? extends NavDestination> navigator = this._namedNavigators.get(name);
                object = navigator;
                if (navigator != null) break block3;
            }
            throw new IllegalStateException("Could not find Navigator with class \"" + navigatorClass + "\". You must call NavController.addNavigator() for each navigation type.");
        }
        Object navigator = object;
        return (T)navigator;
    }

    @CallSuper
    @NotNull
    public <T extends Navigator<?>> T getNavigator(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!Companion.validateName$navigation_common(name)) {
            boolean bl = false;
            String string = "navigator name cannot be an empty string";
            throw new IllegalArgumentException(string.toString());
        }
        Navigator<? extends NavDestination> navigator = this._namedNavigators.get(name);
        if (navigator == null) {
            throw new IllegalStateException("Could not find Navigator with name \"" + name + "\". You must call NavController.addNavigator() for each navigation type.");
        }
        Navigator<? extends NavDestination> navigator2 = navigator;
        return (T)navigator2;
    }

    @Nullable
    public final Navigator<? extends NavDestination> addNavigator(@NotNull Navigator<? extends NavDestination> navigator) {
        Intrinsics.checkNotNullParameter(navigator, (String)"navigator");
        return this.addNavigator(navigator.getName$navigation_common(), navigator);
    }

    @CallSuper
    @Nullable
    public Navigator<? extends NavDestination> addNavigator(@NotNull String name, @NotNull Navigator<? extends NavDestination> navigator) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(navigator, (String)"navigator");
        if (!Companion.validateName$navigation_common(name)) {
            boolean bl = false;
            String string = "Navigator name cannot be an empty string";
            throw new IllegalArgumentException(string.toString());
        }
        this._typeToNavigatorName.put(Reflection.getOrCreateKotlinClass(navigator.getClass()), name);
        Navigator<? extends NavDestination> previousNavigator = this._namedNavigators.get(name);
        if (Intrinsics.areEqual(previousNavigator, navigator)) {
            return navigator;
        }
        Navigator<? extends NavDestination> navigator2 = previousNavigator;
        if (!(!(navigator2 != null ? navigator2.isAttached() : false))) {
            boolean $i$a$-check-NavigatorProvider$addNavigator$42 = false;
            String $i$a$-check-NavigatorProvider$addNavigator$42 = "Navigator " + navigator + " is replacing an already attached " + previousNavigator;
            throw new IllegalStateException($i$a$-check-NavigatorProvider$addNavigator$42.toString());
        }
        if (!(!navigator.isAttached())) {
            boolean bl = false;
            String string = "Navigator " + navigator + " is already attached to another NavController";
            throw new IllegalStateException(string.toString());
        }
        return this._namedNavigators.put(name, navigator);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Landroidx/navigation/NavigatorProvider$Companion;", "", "<init>", "()V", "validateName", "", "name", "", "validateName$navigation_common", "navigation-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean validateName$navigation_common(@Nullable String name) {
            CharSequence charSequence = name;
            return !(charSequence == null || charSequence.length() == 0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

