/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.util.SchemaInfoUtilKt;
import androidx.room.util.TableInfoKt;
import androidx.sqlite.SQLiteConnection;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0005\u001b\u001c\u001d\u001e\u001fBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\b\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006 "}, d2={"Landroidx/room/util/TableInfo;", "", "name", "", "columns", "", "Landroidx/room/util/TableInfo$Column;", "foreignKeys", "", "Landroidx/room/util/TableInfo$ForeignKey;", "indices", "Landroidx/room/util/TableInfo$Index;", "<init>", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;)V", "getName", "()Ljava/lang/String;", "getColumns", "()Ljava/util/Map;", "getForeignKeys", "()Ljava/util/Set;", "getIndices", "equals", "", "other", "hashCode", "", "toString", "CreatedFrom", "Companion", "Column", "ForeignKey", "Index", "room-runtime"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class TableInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, Column> columns;
    @NotNull
    private final Set<ForeignKey> foreignKeys;
    @Nullable
    private final Set<Index> indices;
    public static final int CREATED_FROM_UNKNOWN = 0;
    public static final int CREATED_FROM_ENTITY = 1;
    public static final int CREATED_FROM_DATABASE = 2;

    public TableInfo(@NotNull String name, @NotNull Map<String, Column> columns, @NotNull Set<ForeignKey> foreignKeys, @Nullable Set<Index> indices) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter(foreignKeys, (String)"foreignKeys");
        this.name = name;
        this.columns = columns;
        this.foreignKeys = foreignKeys;
        this.indices = indices;
    }

    public /* synthetic */ TableInfo(String string, Map map2, Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            set2 = null;
        }
        this(string, map2, set, set2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Map<String, Column> getColumns() {
        return this.columns;
    }

    @NotNull
    public final Set<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Nullable
    public final Set<Index> getIndices() {
        return this.indices;
    }

    public boolean equals(@Nullable Object other) {
        return TableInfoKt.equalsCommon(this, other);
    }

    public int hashCode() {
        return TableInfoKt.hashCodeCommon(this);
    }

    @NotNull
    public String toString() {
        return TableInfoKt.toStringCommon(this);
    }

    @JvmStatic
    @NotNull
    public static final TableInfo read(@NotNull SQLiteConnection connection, @NotNull String tableName) {
        return Companion.read(connection, tableName);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0017\b\u0007\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001d\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001c\u0010\u0016\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011\u00a8\u0006\u001f"}, d2={"Landroidx/room/util/TableInfo$Column;", "", "name", "", "type", "notNull", "", "primaryKeyPosition", "", "defaultValue", "createdFrom", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZILjava/lang/String;I)V", "getName", "()Ljava/lang/String;", "getType", "getNotNull", "()Z", "getPrimaryKeyPosition", "()I", "getDefaultValue", "getCreatedFrom", "affinity", "getAffinity$annotations", "()V", "getAffinity", "isPrimaryKey", "equals", "other", "hashCode", "toString", "room-runtime"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final class Column {
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        private final boolean notNull;
        private final int primaryKeyPosition;
        @Nullable
        private final String defaultValue;
        private final int createdFrom;
        private final int affinity;

        public Column(@NotNull String name, @NotNull String type, boolean notNull, int primaryKeyPosition, @Nullable String defaultValue, int createdFrom) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.name = name;
            this.type = type;
            this.notNull = notNull;
            this.primaryKeyPosition = primaryKeyPosition;
            this.defaultValue = defaultValue;
            this.createdFrom = createdFrom;
            this.affinity = SchemaInfoUtilKt.findAffinity(this.type);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final boolean getNotNull() {
            return this.notNull;
        }

        public final int getPrimaryKeyPosition() {
            return this.primaryKeyPosition;
        }

        @Nullable
        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final int getCreatedFrom() {
            return this.createdFrom;
        }

        public final int getAffinity() {
            return this.affinity;
        }

        @ColumnInfo.SQLiteTypeAffinity
        public static /* synthetic */ void getAffinity$annotations() {
        }

        public final boolean isPrimaryKey() {
            return this.primaryKeyPosition > 0;
        }

        public boolean equals(@Nullable Object other) {
            return TableInfoKt.equalsCommon(this, other);
        }

        public int hashCode() {
            return TableInfoKt.hashCodeCommon(this);
        }

        @NotNull
        public String toString() {
            return TableInfoKt.toStringCommon(this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/room/util/TableInfo$Companion;", "", "<init>", "()V", "CREATED_FROM_UNKNOWN", "", "CREATED_FROM_ENTITY", "CREATED_FROM_DATABASE", "read", "Landroidx/room/util/TableInfo;", "connection", "Landroidx/sqlite/SQLiteConnection;", "tableName", "", "room-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TableInfo read(@NotNull SQLiteConnection connection, @NotNull String tableName) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            return SchemaInfoUtilKt.readTableInfo(connection, tableName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/room/util/TableInfo$CreatedFrom;", "", "room-runtime"})
    public static @interface CreatedFrom {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0018"}, d2={"Landroidx/room/util/TableInfo$ForeignKey;", "", "referenceTable", "", "onDelete", "onUpdate", "columnNames", "", "referenceColumnNames", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getReferenceTable", "()Ljava/lang/String;", "getOnDelete", "getOnUpdate", "getColumnNames", "()Ljava/util/List;", "getReferenceColumnNames", "equals", "", "other", "hashCode", "", "toString", "room-runtime"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final class ForeignKey {
        @NotNull
        private final String referenceTable;
        @NotNull
        private final String onDelete;
        @NotNull
        private final String onUpdate;
        @NotNull
        private final List<String> columnNames;
        @NotNull
        private final List<String> referenceColumnNames;

        public ForeignKey(@NotNull String referenceTable, @NotNull String onDelete, @NotNull String onUpdate, @NotNull List<String> columnNames, @NotNull List<String> referenceColumnNames) {
            Intrinsics.checkNotNullParameter((Object)referenceTable, (String)"referenceTable");
            Intrinsics.checkNotNullParameter((Object)onDelete, (String)"onDelete");
            Intrinsics.checkNotNullParameter((Object)onUpdate, (String)"onUpdate");
            Intrinsics.checkNotNullParameter(columnNames, (String)"columnNames");
            Intrinsics.checkNotNullParameter(referenceColumnNames, (String)"referenceColumnNames");
            this.referenceTable = referenceTable;
            this.onDelete = onDelete;
            this.onUpdate = onUpdate;
            this.columnNames = columnNames;
            this.referenceColumnNames = referenceColumnNames;
        }

        @NotNull
        public final String getReferenceTable() {
            return this.referenceTable;
        }

        @NotNull
        public final String getOnDelete() {
            return this.onDelete;
        }

        @NotNull
        public final String getOnUpdate() {
            return this.onUpdate;
        }

        @NotNull
        public final List<String> getColumnNames() {
            return this.columnNames;
        }

        @NotNull
        public final List<String> getReferenceColumnNames() {
            return this.referenceColumnNames;
        }

        public boolean equals(@Nullable Object other) {
            return TableInfoKt.equalsCommon(this, other);
        }

        public int hashCode() {
            return TableInfoKt.hashCodeCommon(this);
        }

        @NotNull
        public String toString() {
            return TableInfoKt.toStringCommon(this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0010\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Landroidx/room/util/TableInfo$Index;", "", "name", "", "unique", "", "columns", "", "orders", "<init>", "(Ljava/lang/String;ZLjava/util/List;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getUnique", "()Z", "getColumns", "()Ljava/util/List;", "getOrders", "setOrders", "(Ljava/util/List;)V", "equals", "other", "hashCode", "", "toString", "Companion", "room-runtime"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @SourceDebugExtension(value={"SMAP\nTableInfo.jvmNative.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableInfo.jvmNative.kt\nandroidx/room/util/TableInfo$Index\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
    public static final class Index {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        private final boolean unique;
        @NotNull
        private final List<String> columns;
        @NotNull
        private List<String> orders;
        @NotNull
        public static final String DEFAULT_PREFIX = "index_";

        public Index(@NotNull String name, boolean unique, @NotNull List<String> columns, @NotNull List<String> orders) {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter(orders, (String)"orders");
            this.name = name;
            this.unique = unique;
            this.columns = columns;
            this.orders = orders;
            Index index = this;
            Collection collection2 = this.orders;
            if (collection2.isEmpty()) {
                Index index2 = index;
                boolean bl = false;
                int n = this.columns.size();
                ArrayList<String> arrayList = new ArrayList<String>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<String> arrayList2 = arrayList;
                    boolean bl2 = false;
                    arrayList2.add("ASC");
                }
                collection = arrayList;
                index = index2;
            } else {
                collection = collection2;
            }
            index.orders = (List)collection;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean getUnique() {
            return this.unique;
        }

        @NotNull
        public final List<String> getColumns() {
            return this.columns;
        }

        @NotNull
        public final List<String> getOrders() {
            return this.orders;
        }

        public final void setOrders(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.orders = list;
        }

        public boolean equals(@Nullable Object other) {
            return TableInfoKt.equalsCommon(this, other);
        }

        public int hashCode() {
            return TableInfoKt.hashCodeCommon(this);
        }

        @NotNull
        public String toString() {
            return TableInfoKt.toStringCommon(this);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/room/util/TableInfo$Index$Companion;", "", "<init>", "()V", "DEFAULT_PREFIX", "", "room-runtime"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

