/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 #*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001#B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000eJ'\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0012J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0015J'\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0018J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0019J-\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u001cJ&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0019J/\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u001eJ-\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/room/EntityUpsertAdapter;", "T", "", "entityInsertAdapter", "Landroidx/room/EntityInsertAdapter;", "updateAdapter", "Landroidx/room/EntityDeleteOrUpdateAdapter;", "<init>", "(Landroidx/room/EntityInsertAdapter;Landroidx/room/EntityDeleteOrUpdateAdapter;)V", "upsert", "", "connection", "Landroidx/sqlite/SQLiteConnection;", "entity", "(Landroidx/sqlite/SQLiteConnection;Ljava/lang/Object;)V", "entities", "", "(Landroidx/sqlite/SQLiteConnection;[Ljava/lang/Object;)V", "", "upsertAndReturnId", "", "(Landroidx/sqlite/SQLiteConnection;Ljava/lang/Object;)J", "upsertAndReturnIdsArray", "", "(Landroidx/sqlite/SQLiteConnection;[Ljava/lang/Object;)[J", "", "upsertAndReturnIdsList", "", "(Landroidx/sqlite/SQLiteConnection;[Ljava/lang/Object;)Ljava/util/List;", "upsertAndReturnIdsArrayBox", "(Landroidx/sqlite/SQLiteConnection;[Ljava/lang/Object;)[Ljava/lang/Long;", "(Landroidx/sqlite/SQLiteConnection;Ljava/util/Collection;)[Ljava/lang/Long;", "checkUniquenessException", "ex", "Landroidx/sqlite/SQLiteException;", "Companion", "room-runtime"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@SourceDebugExtension(value={"SMAP\nEntityUpsertAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityUpsertAdapter.kt\nandroidx/room/EntityUpsertAdapter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n13402#2,2:239\n13402#2,2:243\n1863#3,2:241\n1863#3,2:245\n*S KotlinDebug\n*F\n+ 1 EntityUpsertAdapter.kt\nandroidx/room/EntityUpsertAdapter\n*L\n61#1:239,2\n139#1:243,2\n73#1:241,2\n157#1:245,2\n*E\n"})
public final class EntityUpsertAdapter<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityInsertAdapter<T> entityInsertAdapter;
    @NotNull
    private final EntityDeleteOrUpdateAdapter<T> updateAdapter;
    @NotNull
    private static final String SQLITE_CONSTRAINT_PRIMARYKEY = "1555";
    @NotNull
    private static final String SQLITE_CONSTRAINT_UNIQUE = "2067";
    @NotNull
    private static final String ErrorMsg = "unique";

    public EntityUpsertAdapter(@NotNull EntityInsertAdapter<T> entityInsertAdapter, @NotNull EntityDeleteOrUpdateAdapter<T> updateAdapter) {
        Intrinsics.checkNotNullParameter(entityInsertAdapter, (String)"entityInsertAdapter");
        Intrinsics.checkNotNullParameter(updateAdapter, (String)"updateAdapter");
        this.entityInsertAdapter = entityInsertAdapter;
        this.updateAdapter = updateAdapter;
    }

    public final void upsert(@NotNull SQLiteConnection connection, @Nullable T entity) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        try {
            this.entityInsertAdapter.insert(connection, entity);
        }
        catch (SQLiteException ex) {
            this.checkUniquenessException(ex);
            this.updateAdapter.handle(connection, entity);
        }
    }

    public final void upsert(@NotNull SQLiteConnection connection, @Nullable T[] entities) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (entities == null) {
            return;
        }
        T[] $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            T element$iv;
            T entity = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            try {
                this.entityInsertAdapter.insert(connection, entity);
                continue;
            }
            catch (SQLiteException ex) {
                this.checkUniquenessException(ex);
                this.updateAdapter.handle(connection, entity);
            }
        }
    }

    public final void upsert(@NotNull SQLiteConnection connection, @Nullable Iterable<? extends T> entities) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (entities == null) {
            return;
        }
        Iterable<T> $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        Iterator<T> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            T element$iv;
            T entity = element$iv = iterator.next();
            boolean bl = false;
            try {
                this.entityInsertAdapter.insert(connection, entity);
            }
            catch (SQLiteException ex) {
                this.checkUniquenessException(ex);
                this.updateAdapter.handle(connection, entity);
            }
        }
    }

    public final long upsertAndReturnId(@NotNull SQLiteConnection connection, @Nullable T entity) {
        long l;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        try {
            l = this.entityInsertAdapter.insertAndReturnId(connection, entity);
        }
        catch (SQLiteException ex) {
            this.checkUniquenessException(ex);
            this.updateAdapter.handle(connection, entity);
            l = -1L;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final long[] upsertAndReturnIdsArray(@NotNull SQLiteConnection connection, @Nullable T[] entities) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (entities == null) {
            return new long[0];
        }
        int n = entities.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            long l;
            int n2;
            long[] lArray2;
            int n3;
            int n4 = n3 = i;
            long[] lArray3 = lArray;
            try {
                lArray2 = lArray3;
                n2 = n4;
                l = this.entityInsertAdapter.insertAndReturnId(connection, entities[n3]);
            }
            catch (SQLiteException sQLiteException) {
                void ex;
                lArray2 = lArray3;
                n2 = n4;
                this.checkUniquenessException((SQLiteException)ex);
                this.updateAdapter.handle(connection, entities[n3]);
                l = -1L;
            }
            lArray2[n2] = l;
        }
        return lArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final long[] upsertAndReturnIdsArray(@NotNull SQLiteConnection connection, @Nullable Collection<? extends T> entities) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (entities == null) {
            return new long[0];
        }
        int n = entities.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            long l;
            int n2;
            long[] lArray2;
            int n3;
            int n4 = n3 = i;
            long[] lArray3 = lArray;
            try {
                lArray2 = lArray3;
                n2 = n4;
                l = this.entityInsertAdapter.insertAndReturnId(connection, CollectionsKt.elementAt((Iterable)entities, (int)n3));
            }
            catch (SQLiteException sQLiteException) {
                void ex;
                lArray2 = lArray3;
                n2 = n4;
                this.checkUniquenessException((SQLiteException)ex);
                this.updateAdapter.handle(connection, CollectionsKt.elementAt((Iterable)entities, (int)n3));
                l = -1L;
            }
            lArray2[n2] = l;
        }
        return lArray;
    }

    @NotNull
    public final List<Long> upsertAndReturnIdsList(@NotNull SQLiteConnection connection, @Nullable T[] entities) {
        List list;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (entities == null) {
            return CollectionsKt.emptyList();
        }
        List $this$upsertAndReturnIdsList_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        T[] $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            T element$iv;
            T entity = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            try {
                $this$upsertAndReturnIdsList_u24lambda_u243.add(this.entityInsertAdapter.insertAndReturnId(connection, entity));
                continue;
            }
            catch (SQLiteException ex) {
                this.checkUniquenessException(ex);
                this.updateAdapter.handle(connection, entity);
                $this$upsertAndReturnIdsList_u24lambda_u243.add(-1L);
            }
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public final List<Long> upsertAndReturnIdsList(@NotNull SQLiteConnection connection, @Nullable Collection<? extends T> entities) {
        List list;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (entities == null) {
            return CollectionsKt.emptyList();
        }
        List $this$upsertAndReturnIdsList_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object entity = element$iv = iterator.next();
            boolean bl2 = false;
            try {
                $this$upsertAndReturnIdsList_u24lambda_u245.add(this.entityInsertAdapter.insertAndReturnId(connection, entity));
            }
            catch (SQLiteException ex) {
                this.checkUniquenessException(ex);
                this.updateAdapter.handle(connection, entity);
                $this$upsertAndReturnIdsList_u24lambda_u245.add(-1L);
            }
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Long[] upsertAndReturnIdsArrayBox(@NotNull SQLiteConnection connection, @Nullable T[] entities) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (entities == null) {
            return new Long[0];
        }
        int n = entities.length;
        Long[] longArray = new Long[n];
        for (int i = 0; i < n; ++i) {
            long l;
            int n2;
            Long[] longArray2;
            int n3;
            int n4 = n3 = i;
            Long[] longArray3 = longArray;
            try {
                longArray2 = longArray3;
                n2 = n4;
                l = this.entityInsertAdapter.insertAndReturnId(connection, entities[n3]);
            }
            catch (SQLiteException sQLiteException) {
                void ex;
                longArray2 = longArray3;
                n2 = n4;
                this.checkUniquenessException((SQLiteException)ex);
                this.updateAdapter.handle(connection, entities[n3]);
                l = -1L;
            }
            longArray2[n2] = l;
        }
        return longArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Long[] upsertAndReturnIdsArrayBox(@NotNull SQLiteConnection connection, @Nullable Collection<? extends T> entities) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (entities == null) {
            return new Long[0];
        }
        int n = entities.size();
        Long[] longArray = new Long[n];
        for (int i = 0; i < n; ++i) {
            long l;
            int n2;
            Long[] longArray2;
            int n3;
            int n4 = n3 = i;
            Long[] longArray3 = longArray;
            try {
                longArray2 = longArray3;
                n2 = n4;
                l = this.entityInsertAdapter.insertAndReturnId(connection, CollectionsKt.elementAt((Iterable)entities, (int)n3));
            }
            catch (SQLiteException sQLiteException) {
                void ex;
                longArray2 = longArray3;
                n2 = n4;
                this.checkUniquenessException((SQLiteException)ex);
                this.updateAdapter.handle(connection, CollectionsKt.elementAt((Iterable)entities, (int)n3));
                l = -1L;
            }
            longArray2[n2] = l;
        }
        return longArray;
    }

    private final void checkUniquenessException(SQLiteException ex) {
        boolean hasUniqueConstraintEx;
        String string = ex.getMessage();
        if (string == null) {
            throw ex;
        }
        String message = string;
        boolean bl = hasUniqueConstraintEx = StringsKt.contains((CharSequence)message, (CharSequence)ErrorMsg, (boolean)true) || StringsKt.contains$default((CharSequence)message, (CharSequence)SQLITE_CONSTRAINT_UNIQUE, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)SQLITE_CONSTRAINT_PRIMARYKEY, (boolean)false, (int)2, null);
        if (!hasUniqueConstraintEx) {
            throw ex;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/room/EntityUpsertAdapter$Companion;", "", "<init>", "()V", "SQLITE_CONSTRAINT_PRIMARYKEY", "", "SQLITE_CONSTRAINT_UNIQUE", "ErrorMsg", "room-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

