/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.annotation.RestrictTo;
import androidx.navigation.NavUri;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001:\u0001\u000fB'\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0005H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0010"}, d2={"Landroidx/navigation/NavDeepLinkRequest;", "", "uri", "Landroidx/navigation/NavUri;", "action", "", "mimeType", "<init>", "(Landroidx/navigation/NavUri;Ljava/lang/String;Ljava/lang/String;)V", "getUri", "()Landroidx/navigation/NavUri;", "getAction", "()Ljava/lang/String;", "getMimeType", "toString", "Builder", "navigation-common"})
public class NavDeepLinkRequest {
    @Nullable
    private final NavUri uri;
    @Nullable
    private final String action;
    @Nullable
    private final String mimeType;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public NavDeepLinkRequest(@Nullable NavUri uri, @Nullable String action, @Nullable String mimeType) {
        this.uri = uri;
        this.action = action;
        this.mimeType = mimeType;
    }

    @Nullable
    public NavUri getUri() {
        return this.uri;
    }

    @Nullable
    public String getAction() {
        return this.action;
    }

    @Nullable
    public String getMimeType() {
        return this.mimeType;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("NavDeepLinkRequest");
        $this$toString_u24lambda_u240.append("{");
        if (this.getUri() != null) {
            $this$toString_u24lambda_u240.append(" uri=");
            $this$toString_u24lambda_u240.append(String.valueOf(this.getUri()));
        }
        if (this.getAction() != null) {
            $this$toString_u24lambda_u240.append(" action=");
            $this$toString_u24lambda_u240.append(this.getAction());
        }
        if (this.getMimeType() != null) {
            $this$toString_u24lambda_u240.append(" mimetype=");
            $this$toString_u24lambda_u240.append(this.getMimeType());
        }
        $this$toString_u24lambda_u240.append(" }");
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/navigation/NavDeepLinkRequest$Builder;", "", "<init>", "()V", "uri", "Landroidx/navigation/NavUri;", "action", "", "mimeType", "setUri", "setAction", "setMimeType", "build", "Landroidx/navigation/NavDeepLinkRequest;", "Companion", "navigation-common"})
    @SourceDebugExtension(value={"SMAP\nNavDeepLinkRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavDeepLinkRequest.kt\nandroidx/navigation/NavDeepLinkRequest$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1#2:173\n*E\n"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private NavUri uri;
        @Nullable
        private String action;
        @Nullable
        private String mimeType;

        private Builder() {
        }

        @NotNull
        public final Builder setUri(@NotNull NavUri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
            return this;
        }

        @NotNull
        public final Builder setAction(@NotNull String action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            if (!(((CharSequence)action).length() > 0)) {
                boolean bl = false;
                String string = "The NavDeepLinkRequest cannot have an empty action.";
                throw new IllegalArgumentException(string.toString());
            }
            this.action = action;
            return this;
        }

        @NotNull
        public final Builder setMimeType(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            CharSequence charSequence = mimeType;
            boolean mimeTypeMatcher = new Regex("^[-\\w*.]+/[-\\w+*.]+$").matches(charSequence);
            if (!mimeTypeMatcher) {
                boolean bl = false;
                String string = "The given mimeType " + mimeType + " does not match to required \"type/subtype\" format";
                throw new IllegalArgumentException(string.toString());
            }
            this.mimeType = mimeType;
            return this;
        }

        @NotNull
        public final NavDeepLinkRequest build() {
            return new NavDeepLinkRequest(this.uri, this.action, this.mimeType);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromUri(@NotNull NavUri uri) {
            return Companion.fromUri(uri);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromAction(@NotNull String action) {
            return Companion.fromAction(action);
        }

        @JvmStatic
        @NotNull
        public static final Builder fromMimeType(@NotNull String mimeType) {
            return Companion.fromMimeType(mimeType);
        }

        public /* synthetic */ Builder(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nH\u0007\u00a8\u0006\r"}, d2={"Landroidx/navigation/NavDeepLinkRequest$Builder$Companion;", "", "<init>", "()V", "fromUri", "Landroidx/navigation/NavDeepLinkRequest$Builder;", "uri", "Landroidx/navigation/NavUri;", "fromAction", "action", "", "fromMimeType", "mimeType", "navigation-common"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder fromUri(@NotNull NavUri uri) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Builder builder = new Builder(null);
                builder.setUri(uri);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromAction(@NotNull String action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                if (!(((CharSequence)action).length() > 0)) {
                    boolean bl = false;
                    String string = "The NavDeepLinkRequest cannot have an empty action.";
                    throw new IllegalArgumentException(string.toString());
                }
                Builder builder = new Builder(null);
                builder.setAction(action);
                return builder;
            }

            @JvmStatic
            @NotNull
            public final Builder fromMimeType(@NotNull String mimeType) {
                Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
                Builder builder = new Builder(null);
                builder.setMimeType(mimeType);
                return builder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

